/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.xmlnode;

import java.io.PrintWriter;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.xmlnode.XMLNode;

public class XMLTextNode
extends XMLNode {
    private String text;
    private boolean isComment = false;

    public XMLTextNode() {
    }

    public XMLTextNode(String string) {
        this.setText(string);
    }

    public XMLNode setText(String string) {
        this.text = string;
        if (string != null && string.startsWith("<!--") && string.endsWith("-->")) {
            this.isComment = true;
        }
        return this;
    }

    public boolean isComment() {
        return this.isComment;
    }

    public String getText() {
        return this.text;
    }

    public boolean isTextNode() {
        return true;
    }

    public void write(PrintWriter printWriter) {
        if (this.isSpace) {
            printWriter.write("[SPACE[");
        } else {
            printWriter.write("[TEXT[");
        }
        printWriter.write(this.getText());
        if (this.isSpace) {
            printWriter.println("]SPACE]");
        } else {
            printWriter.println("]TEXT]");
        }
    }

    public void write(XMLOutputStream xMLOutputStream) throws XMLStreamException {
        this.writeText(xMLOutputStream);
    }

    protected void writeText(PrintWriter printWriter) {
        if (this.getText() != null) {
            printWriter.write(this.getText());
        }
    }
}

