/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.xmlnode;

import java.io.IOException;
import weblogic.utils.AssertionError;
import weblogic.xml.babel.stream.XMLWriter;
import weblogic.xml.stream.ChangePrefixMapping;
import weblogic.xml.stream.CharacterData;
import weblogic.xml.stream.Comment;
import weblogic.xml.stream.EndDocument;
import weblogic.xml.stream.EndElement;
import weblogic.xml.stream.EndPrefixMapping;
import weblogic.xml.stream.EntityReference;
import weblogic.xml.stream.ProcessingInstruction;
import weblogic.xml.stream.Space;
import weblogic.xml.stream.StartDocument;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.StartPrefixMapping;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.xmlnode.XMLNode;

public class XMLNodeWriter
extends XMLWriter {
    private XMLNode root;
    private XMLNode current;

    public XMLNodeWriter(XMLNode xMLNode) {
        this.root = xMLNode;
        this.current = xMLNode;
        this.init();
    }

    public void reset() {
    }

    private XMLNode getCurrent() {
        if (this.current == null) {
            throw new AssertionError("Cant find current element, root=" + this.root);
        }
        return this.current;
    }

    public void write(StartElement startElement) throws XMLStreamException {
        try {
            XMLName xMLName = startElement.getName();
            XMLNode xMLNode = this.getCurrent().addChild(xMLName.getLocalName(), xMLName.getPrefix(), xMLName.getNamespaceUri());
            if (this.writeElementNameSpaces) {
                xMLNode.readNamespace(startElement);
            }
            xMLNode.readAttributes(startElement);
            this.current = xMLNode;
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void write(EndElement endElement) throws XMLStreamException {
        this.current = this.getCurrent().getParent();
    }

    public void write(ProcessingInstruction processingInstruction) throws XMLStreamException {
    }

    public void write(CharacterData characterData) throws XMLStreamException {
        this.getCurrent().addText(characterData.getContent());
    }

    public void write(StartDocument startDocument) throws XMLStreamException {
        this.reset();
    }

    public void write(EndDocument endDocument) throws XMLStreamException {
    }

    public void write(Comment comment) throws XMLStreamException {
    }

    public void write(StartPrefixMapping startPrefixMapping) throws XMLStreamException {
    }

    public void write(ChangePrefixMapping changePrefixMapping) throws XMLStreamException {
    }

    public void write(EndPrefixMapping endPrefixMapping) throws XMLStreamException {
    }

    public void write(EntityReference entityReference) throws XMLStreamException {
    }

    public void write(Space space) throws XMLStreamException {
        this.getCurrent().addText(space.getContent());
    }

    public void flush() throws XMLStreamException {
    }

    public boolean write(XMLEvent xMLEvent) throws XMLStreamException {
        switch (xMLEvent.getType()) {
            case 2: {
                this.write((StartElement)xMLEvent);
                break;
            }
            case 4: {
                this.write((EndElement)xMLEvent);
                break;
            }
            case 8: {
                this.write((ProcessingInstruction)xMLEvent);
                break;
            }
            case 16: {
                this.write((CharacterData)xMLEvent);
                break;
            }
            case 32: {
                this.write((Comment)xMLEvent);
                break;
            }
            case 256: {
                this.write((StartDocument)xMLEvent);
                break;
            }
            case 512: {
                this.write((EndDocument)xMLEvent);
                break;
            }
            case 1024: {
                this.write((StartPrefixMapping)xMLEvent);
                break;
            }
            case 2048: {
                this.write((EndPrefixMapping)xMLEvent);
                break;
            }
            case 4096: {
                this.write((ChangePrefixMapping)xMLEvent);
                break;
            }
            case 8192: {
                this.write((EntityReference)xMLEvent);
                break;
            }
            case 64: {
                this.write((Space)xMLEvent);
                break;
            }
            case 128: {
                throw new XMLStreamException("Attempt to write a null element.");
            }
            default: {
                throw new XMLStreamException("Attempt to write unknown element [" + xMLEvent.getType() + "]");
            }
        }
        return true;
    }

    protected void init() {
        this.setWriteHeader(true);
        this.setWriteElementNameSpaces(true);
        this.setWriteAll(false);
        this.setShowNamespaceBindings(false);
        this.setNormalizeWhiteSpace(false);
        this.reset();
    }
}

