/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.xmlnode;

import java.io.FileInputStream;
import java.util.Iterator;
import weblogic.utils.collections.Stack;
import weblogic.xml.stream.ElementFilter;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.util.TypeFilter;
import weblogic.xml.xmlnode.XMLEndNode;
import weblogic.xml.xmlnode.XMLNode;

public class XMLNodeIterator {
    private Stack iteratorStack = new Stack();
    private Stack nameStack = new Stack();
    private XMLNode nextNode;
    private XMLNode rootNode;
    private int depth;

    public XMLNodeIterator(XMLNode xMLNode) {
        if (xMLNode == null) {
            this.nextNode = null;
            return;
        }
        this.rootNode = xMLNode;
        this.nextNode = xMLNode;
        this.iteratorStack.push(xMLNode.getChildren());
        this.nameStack.push(xMLNode.getName());
    }

    public int getDepth() {
        return this.depth;
    }

    public void reset() {
        this.nextNode = this.rootNode;
        this.iteratorStack.clear();
        this.iteratorStack.push(this.nextNode.getChildren());
        this.nameStack.clear();
        this.nameStack.push(this.rootNode.getName());
    }

    public boolean hasNext() {
        return this.nextNode != null;
    }

    public XMLNode next() {
        XMLNode xMLNode = this.nextNode;
        if (this.iteratorStack.isEmpty()) {
            this.nextNode = null;
            return xMLNode;
        }
        if (!this.iteratorStack.isEmpty()) {
            Iterator iterator = (Iterator)this.iteratorStack.peek();
            if (!iterator.hasNext()) {
                this.iteratorStack.pop();
                this.nextNode = new XMLEndNode((XMLName)this.nameStack.pop());
                return xMLNode;
            }
            this.nextNode = (XMLNode)iterator.next();
            if (!this.nextNode.isTextNode()) {
                this.iteratorStack.push(this.nextNode.getChildren());
                this.nameStack.push(this.nextNode.getName());
            }
            return xMLNode;
        }
        this.nextNode = null;
        return xMLNode;
    }

    public void print() {
        while (this.hasNext()) {
            XMLNode xMLNode = this.next();
            if (xMLNode.isTextNode() && xMLNode.getText() != null) {
                System.out.println(xMLNode.getText());
                continue;
            }
            if (xMLNode.isEndNode()) {
                System.out.println("</" + xMLNode.getName() + ">");
                continue;
            }
            System.out.println("<" + xMLNode.getName() + ">");
        }
    }

    public void print2() {
        while (this.hasNext()) {
            XMLNode xMLNode = this.next();
            if (xMLNode.isTextNode() && xMLNode.getText() != null) {
                System.out.println(xMLNode.createCharacterData());
                continue;
            }
            if (xMLNode.isEndNode()) {
                System.out.println(xMLNode.createEndElement());
                continue;
            }
            System.out.println(xMLNode.createStartElement());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        XMLInputStreamFactory xMLInputStreamFactory = XMLInputStreamFactory.newInstance();
        TypeFilter typeFilter = new TypeFilter(22);
        XMLInputStream xMLInputStream = xMLInputStreamFactory.newInputStream(new FileInputStream(stringArray[0]), (ElementFilter)typeFilter);
        XMLNode xMLNode = new XMLNode();
        xMLNode.read(xMLInputStream);
        XMLNodeIterator xMLNodeIterator = new XMLNodeIterator(xMLNode);
        xMLNodeIterator.reset();
        xMLNodeIterator.print();
        xMLNodeIterator.reset();
        xMLNodeIterator.print2();
    }
}

