/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.xmlnode;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.InputSource;
import weblogic.utils.StackTraceUtils;
import weblogic.xml.babel.stream.XMLInputStreamBase;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.AttributeIterator;
import weblogic.xml.stream.CharacterData;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.EndElement;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLOutputStreamFactory;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.events.AttributeImpl;
import weblogic.xml.stream.events.CharacterDataEvent;
import weblogic.xml.stream.events.EndElementEvent;
import weblogic.xml.stream.events.Name;
import weblogic.xml.stream.events.SpaceEvent;
import weblogic.xml.stream.events.StartElementEvent;
import weblogic.xml.stream.util.TypeFilter;
import weblogic.xml.stream.util.XMLInputStreamFilterBase;
import weblogic.xml.xmlnode.EmptyIterator;
import weblogic.xml.xmlnode.ReferenceMap;
import weblogic.xml.xmlnode.XMLNodeInputStream;
import weblogic.xml.xmlnode.XMLNodeIterator;
import weblogic.xml.xmlnode.XMLTextNode;

public class XMLNode {
    private static final EmptyIterator emptyIterator = new EmptyIterator();
    private static final boolean debug = false;
    protected XMLNode parent;
    protected XMLName name;
    protected String href;
    protected String id;
    protected boolean isSpace = false;
    private ArrayList children;
    private Map attributes;
    private Map globalNamespaceMap;
    private ReferenceMap hrefs;
    private HashMap namespaceMap;
    private String currentLocation = null;

    public XMLNode() {
    }

    public XMLNode(String string) {
        this.currentLocation = string;
    }

    public XMLNode(XMLName xMLName) {
        this.name = xMLName;
    }

    public void setParent(XMLNode xMLNode) {
        this.parent = xMLNode;
    }

    public XMLNode setText(String string) {
        new Error("This method is not supported").printStackTrace();
        this.addText(string);
        return this;
    }

    public void setHref(String string) {
        this.href = string;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setReferenceMap(ReferenceMap referenceMap) {
        this.hrefs = referenceMap;
    }

    public void setGlobalNamespaceMap(Map map) {
        this.globalNamespaceMap = map;
    }

    public void setName(XMLName xMLName) {
        this.name = xMLName;
    }

    public void setName(String string, String string2, String string3) {
        this.setName(this.createXMLName(string, string2, string3));
    }

    public XMLNode getParent() {
        return this.parent;
    }

    public XMLNode getChild(String string, String string2) {
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            XMLName xMLName;
            XMLNode xMLNode = (XMLNode)iterator.next();
            if (xMLNode.isTextNode() || !string.equals((xMLName = xMLNode.getName()).getLocalName()) || string2 != null && !string2.equals(xMLName.getNamespaceUri())) continue;
            return xMLNode;
        }
        return null;
    }

    public boolean isTextNode() {
        return false;
    }

    public boolean isEndNode() {
        return false;
    }

    public String getHref() {
        return this.href;
    }

    public String getId() {
        return this.id;
    }

    public ReferenceMap getReferenceMap() {
        return this.hrefs();
    }

    public Map getGlobalNamespaceMap() {
        if (this.globalNamespaceMap == null) {
            this.globalNamespaceMap = new HashMap();
            this.globalNamespaceMap.put("xml", "http://www.w3.org/XML/1998/namespace");
        }
        return this.globalNamespaceMap;
    }

    public String getAttribute(XMLName xMLName) {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.get(xMLName);
    }

    public String getAttribute(String string, String string2) {
        if (this.attributes == null) {
            return null;
        }
        Iterator iterator = this.getAttributes();
        while (iterator.hasNext()) {
            XMLName xMLName = (XMLName)iterator.next();
            if (!string.equals(xMLName.getLocalName()) || string2 != null && !string2.equals(xMLName.getNamespaceUri())) continue;
            return this.getAttribute(xMLName);
        }
        return null;
    }

    public Iterator getAttributes() {
        return this.attributes().keySet().iterator();
    }

    public String getNamespaceURI(String string) {
        String string2 = null;
        if (this.namespaceMap != null) {
            string2 = (String)this.namespaceMap.get(string);
        }
        if (string2 == null && this.getParent() != null) {
            string2 = this.getParent().getNamespaceURI(string);
        }
        return string2;
    }

    public Iterator getNamespacePrefixes() {
        if (this.namespaceMap == null) {
            return emptyIterator;
        }
        return this.namespaceMap.keySet().iterator();
    }

    public XMLName getName() {
        return this.name;
    }

    public Iterator getChildren() {
        if (this.children == null) {
            return emptyIterator;
        }
        return this.children.iterator();
    }

    public Iterator getChildren(String string, String string2) {
        ArrayList<XMLNode> arrayList = new ArrayList<XMLNode>();
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            XMLName xMLName;
            XMLNode xMLNode = (XMLNode)iterator.next();
            if (xMLNode.isTextNode() || !string.equals((xMLName = xMLNode.getName()).getLocalName()) || string2 != null && !string2.equals(xMLName.getNamespaceUri())) continue;
            arrayList.add(xMLNode);
        }
        return arrayList.iterator();
    }

    public Iterator getChildren(XMLName xMLName) {
        ArrayList<XMLNode> arrayList = new ArrayList<XMLNode>();
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            XMLNode xMLNode = (XMLNode)iterator.next();
            if (!xMLName.equals(xMLNode.getName())) continue;
            arrayList.add(xMLNode);
        }
        return arrayList.iterator();
    }

    public String getText() {
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            XMLNode xMLNode = (XMLNode)iterator.next();
            if (!(xMLNode instanceof XMLTextNode)) continue;
            return xMLNode.getText();
        }
        return null;
    }

    public void detachNode() {
        this.parent.removeChild(this);
        this.parent = null;
    }

    public void recycleNode() {
    }

    public XMLInputStream stream() {
        XMLNodeInputStream xMLNodeInputStream = new XMLNodeInputStream(this);
        xMLNodeInputStream.setReferenceResolver(this.hrefs());
        return xMLNodeInputStream;
    }

    public void removeChild(XMLNode xMLNode) {
        if (this.children == null) {
            return;
        }
        int n = this.children.indexOf(xMLNode);
        if (n != -1) {
            this.children.remove(n);
        }
    }

    public XMLNode addChild(XMLName xMLName) {
        XMLNode xMLNode = this.createChild(xMLName);
        xMLNode.setGlobalNamespaceMap(this.getGlobalNamespaceMap());
        xMLNode.setReferenceMap(this.getReferenceMap());
        xMLNode.name = xMLName;
        this.addChild(xMLNode);
        return xMLNode;
    }

    public XMLNode insertChild(XMLNode xMLNode, int n) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        if (xMLNode.parent != null) {
            xMLNode.inheritNamespace();
        }
        xMLNode.parent = this;
        this.children.add(n, xMLNode);
        return xMLNode;
    }

    public XMLNode addChild(XMLNode xMLNode) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        if (xMLNode.parent != null) {
            xMLNode.inheritNamespace();
        }
        xMLNode.parent = this;
        this.children.add(xMLNode);
        return xMLNode;
    }

    public void inheritNamespace() {
        for (XMLNode xMLNode = this.getParent(); xMLNode != null; xMLNode = xMLNode.getParent()) {
            Iterator iterator = xMLNode.namespaceMap().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                if (this.namespaceMap().containsKey(string)) continue;
                this.addNamespace(string, string2);
            }
        }
    }

    public XMLNode addChild(String string) {
        return this.addChild(this.createXMLName(string, null, null));
    }

    public XMLNode addChild(String string, String string2) {
        return this.addChild(this.createXMLName(string, string2, null));
    }

    public XMLNode addChild(String string, String string2, String string3) {
        return this.addChild(this.createXMLName(string, string2, string3));
    }

    public XMLNode addText(String string) {
        XMLNode xMLNode = this.createTextChild(string);
        if (this.isSpace) {
            xMLNode.isSpace = true;
        }
        return this.addChild(xMLNode);
    }

    public XMLNode addAttribute(XMLName xMLName, String string) {
        if (string == null) {
            throw new IllegalArgumentException("attribute can not have null value:" + xMLName);
        }
        if ("xmlns".equals(xMLName.getPrefix())) {
            throw new IllegalArgumentException("This is not an attribute, it is a namespace:" + xMLName);
        }
        this.attributes().put(xMLName, string);
        return this;
    }

    public XMLNode addAttribute(String string, String string2, String string3, String string4) {
        return this.addAttribute(this.createXMLName(string, string2, string3), string4);
    }

    public XMLNode addNamespace(String string, String string2) {
        this.namespaceMap().put(string, string2);
        this.getGlobalNamespaceMap().put(string, string2);
        return this;
    }

    public boolean removeAttribute(XMLName xMLName) {
        return this.attributes().remove(xMLName) != null;
    }

    public boolean removeNamespace(String string) {
        if (this.namespaceMap == null) {
            return false;
        }
        return this.namespaceMap.remove(string) != null;
    }

    public void removeTextNodes() {
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof XMLTextNode)) continue;
            iterator.remove();
        }
    }

    public XMLNodeIterator iterator() {
        return new XMLNodeIterator(this);
    }

    public void write(XMLOutputStream xMLOutputStream) throws XMLStreamException {
        xMLOutputStream.add(ElementFactory.createStartElement(this.name.getNamespaceUri(), this.name.getLocalName(), this.name.getPrefix()));
        this.writeNamespace(xMLOutputStream);
        this.writeAttributes(xMLOutputStream);
        this.writeChildren(xMLOutputStream);
        xMLOutputStream.add(ElementFactory.createEndElement(this.name.getNamespaceUri(), this.name.getLocalName(), this.name.getPrefix()));
    }

    public void read(InputStream inputStream) throws IOException {
        this.read(inputStream, false);
    }

    public void read(InputStream inputStream, boolean bl) throws IOException {
        try {
            TypeFilter typeFilter = bl ? new TypeFilter(22) : new TypeFilter(86);
            XMLInputStreamFilterBase xMLInputStreamFilterBase = new XMLInputStreamFilterBase();
            XMLInputStreamBase xMLInputStreamBase = new XMLInputStreamBase();
            xMLInputStreamBase.open(new InputSource(inputStream));
            xMLInputStreamBase.skip(2);
            xMLInputStreamFilterBase.setParent(xMLInputStreamBase);
            xMLInputStreamFilterBase.setFilter(typeFilter);
            this.read(xMLInputStreamFilterBase);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new IOException("failed to create xml input stream:" + xMLStreamException);
        }
    }

    public void read(XMLInputStream xMLInputStream) throws IOException {
        try {
            if (!xMLInputStream.hasNext()) {
                throw new IOException("start element not found");
            }
            XMLEvent xMLEvent = xMLInputStream.next();
            if (xMLEvent.getType() != 2) {
                throw new IOException("is not a start element:" + xMLEvent);
            }
            this.name = this.createXMLName(xMLEvent.getName());
            this.readAttributes((StartElement)xMLEvent);
            this.readNamespace((StartElement)xMLEvent);
            this.readChildren(xMLEvent, xMLInputStream);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new IOException("error:" + xMLStreamException);
        }
    }

    public StartElement createStartElement() {
        String string;
        Object object;
        Map.Entry entry;
        StartElementEvent startElementEvent = new StartElementEvent(this.name);
        Iterator iterator = this.attributes().entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            object = (XMLName)entry.getKey();
            string = (String)entry.getValue();
            startElementEvent.addAttribute(new AttributeImpl((XMLName)object, string, "CDATA"));
        }
        iterator = this.namespaceMap().entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            object = (String)entry.getKey();
            string = (String)entry.getValue();
            if (((String)object).equals("")) {
                object = null;
                this.getGlobalNamespaceMap().put("", string);
                Attribute attribute = ElementFactory.createNamespaceAttribute(null, string);
                startElementEvent.addNamespace(attribute);
                continue;
            }
            this.getGlobalNamespaceMap().put(object, string);
            startElementEvent.addNamespace(ElementFactory.createNamespaceAttribute((String)object, string));
        }
        startElementEvent.setTransientNamespaceMap(this.globalNamespaceMap);
        return startElementEvent;
    }

    public EndElement createEndElement() {
        return new EndElementEvent(this.name);
    }

    public CharacterData createCharacterData() {
        if (this.isSpace) {
            return new SpaceEvent(this.getText());
        }
        return new CharacterDataEvent(this.getText());
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        XMLOutputStream xMLOutputStream = null;
        try {
            xMLOutputStream = XMLOutputStreamFactory.newInstance().newDebugOutputStream(stringWriter);
            xMLOutputStream.add(this.stream());
            xMLOutputStream.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            return "Exception in: " + this.getClass().getName() + ".toString(): " + StackTraceUtils.throwable2StackTrace(xMLStreamException);
        }
        return stringWriter.getBuffer().toString();
    }

    protected void writeNamespace(XMLOutputStream xMLOutputStream) throws XMLStreamException {
        Iterator iterator = this.namespaceMap().keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.namespaceMap.get(string);
            xMLOutputStream.add(ElementFactory.createNamespaceAttribute("".equals(string) ? null : string, string2));
        }
    }

    protected void writeAttributes(XMLOutputStream xMLOutputStream) throws XMLStreamException {
        if (this.attributes == null) {
            return;
        }
        Iterator iterator = this.attributes.keySet().iterator();
        while (iterator.hasNext()) {
            XMLName xMLName = (XMLName)iterator.next();
            String string = (String)this.attributes.get(xMLName);
            xMLOutputStream.add(ElementFactory.createAttribute(xMLName, string));
        }
    }

    protected void writeText(XMLOutputStream xMLOutputStream) throws XMLStreamException {
        if (this.getText() != null) {
            xMLOutputStream.add(ElementFactory.createCharacterData(this.getText()));
        }
    }

    protected void writeChildren(XMLOutputStream xMLOutputStream) throws XMLStreamException {
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            XMLNode xMLNode = (XMLNode)iterator.next();
            xMLNode.write(xMLOutputStream);
        }
    }

    protected XMLNode createChild(XMLName xMLName) {
        return new XMLNode(xMLName);
    }

    protected XMLNode createTextChild(String string) {
        return new XMLTextNode(string);
    }

    protected XMLName createXMLName(String string, String string2, String string3) {
        return new Name(string3, string, string2);
    }

    void readAttributes(StartElement startElement) throws IOException {
        AttributeIterator attributeIterator = startElement.getAttributes();
        while (attributeIterator.hasNext()) {
            Attribute attribute = attributeIterator.next();
            XMLName xMLName = this.createXMLName(attribute.getName());
            String string = attribute.getName().getLocalName();
            if (string.equals("href")) {
                this.href = attribute.getValue();
                this.hrefs().addReference(this.href, this);
            } else if (string.equals("id")) {
                this.id = attribute.getValue();
                this.hrefs().addTarget(this.id, this);
            }
            this.addAttribute(xMLName, attribute.getValue());
        }
    }

    void readNamespace(StartElement startElement) throws IOException {
        AttributeIterator attributeIterator = startElement.getNamespaces();
        if (attributeIterator != null) {
            while (attributeIterator.hasNext()) {
                Attribute attribute = attributeIterator.next();
                XMLName xMLName = this.createXMLName(attribute.getName());
                if (xMLName.getLocalName().equals("xmlns")) {
                    this.addNamespace("", attribute.getValue());
                    continue;
                }
                this.addNamespace(xMLName.getLocalName(), attribute.getValue());
            }
        }
    }

    final ReferenceMap hrefs() {
        if (this.hrefs == null) {
            this.hrefs = new ReferenceMap();
        }
        return this.hrefs;
    }

    private final Map attributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        return this.attributes;
    }

    private final Map namespaceMap() {
        if (this.namespaceMap == null) {
            this.namespaceMap = new HashMap();
        }
        return this.namespaceMap;
    }

    private void readChildren(XMLEvent xMLEvent, XMLInputStream xMLInputStream) throws XMLStreamException, IOException {
        block6: while (xMLInputStream.hasNext()) {
            XMLEvent xMLEvent2 = xMLInputStream.peek();
            this.isSpace = false;
            switch (xMLEvent2.getType()) {
                case 2: {
                    Object object;
                    XMLName xMLName = xMLEvent2.getName();
                    XMLNode xMLNode = this.addChild(this.createXMLName(xMLName));
                    xMLNode.read(xMLInputStream);
                    if (this.currentLocation == null || !xMLName.getLocalName().equals("include") || (object = xMLNode.getAttribute("schemaLocation", null)) == null || ((String)object).startsWith("/") || ((String)object).indexOf(58) >= 0) continue block6;
                    xMLNode.addAttribute("schemaLocation", null, null, this.currentLocation + "/" + (String)object);
                    continue block6;
                }
                case 16: {
                    this.addText(((CharacterData)xMLEvent2).getContent());
                    xMLInputStream.next();
                    continue block6;
                }
                case 64: {
                    Object object = this.addText(((CharacterData)xMLEvent2).getContent());
                    ((XMLNode)object).isSpace = true;
                    xMLInputStream.next();
                    continue block6;
                }
                case 4: {
                    xMLInputStream.next();
                    return;
                }
            }
            xMLInputStream.next();
        }
    }

    private XMLName createXMLName(XMLName xMLName) {
        return this.createXMLName(xMLName.getLocalName(), xMLName.getPrefix(), xMLName.getNamespaceUri());
    }

    public static void main(String[] stringArray) throws Exception {
        XMLNode xMLNode = new XMLNode();
        xMLNode.read(new FileInputStream(stringArray[0]));
        System.out.println("-------pretty output----------");
        System.out.println(xMLNode);
    }
}

