/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.xmlnode;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import weblogic.utils.collections.NumericValueHashtable;
import weblogic.xml.stream.ReferenceResolver;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.xmlnode.XMLNode;
import weblogic.xml.xmlnode.XMLNodeException;

public class ReferenceMap
implements ReferenceResolver {
    protected Map targetNodes = new HashMap();
    protected NumericValueHashtable referenceCount = new NumericValueHashtable();
    protected List nodesToProcess = new ArrayList();

    public List getNodesToProcess() {
        return this.nodesToProcess;
    }

    public XMLNode getTarget(String string) throws XMLNodeException {
        XMLNode xMLNode = (XMLNode)this.targetNodes.get(this.removeHash(string));
        if (xMLNode == null) {
            throw new XMLNodeException("Reference to an unknown id[" + string + "]");
        }
        return xMLNode;
    }

    public String getId(String string) {
        return this.removeHash(string);
    }

    public void addReference(String string, XMLNode xMLNode) {
        if (string == null) {
            throw new NullPointerException("id may not be null");
        }
        this.nodesToProcess.add(xMLNode);
        long l = this.numReference(this.removeHash(string));
        this.referenceCount.put(this.removeHash(string), ++l);
    }

    public long numReference(String string) {
        if (string == null) {
            return 0L;
        }
        return this.referenceCount.get(this.removeHash(string));
    }

    public void clear() {
        this.targetNodes.clear();
        this.referenceCount.clear();
        this.nodesToProcess.clear();
    }

    public void addTarget(String string, XMLNode xMLNode) {
        this.targetNodes.put(string, xMLNode);
    }

    public XMLInputStream resolve(String string) throws XMLStreamException {
        try {
            return this.getTarget(string).stream();
        }
        catch (XMLNodeException xMLNodeException) {
            throw new XMLStreamException(xMLNodeException);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.targetNodes.entrySet().iterator();
        stringBuffer.append("[KEY][COUNT]-->[XMLNODE]\n");
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            XMLNode xMLNode = (XMLNode)entry.getValue();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println(xMLNode);
            stringWriter.toString();
            stringBuffer.append("[" + entry.getKey() + "][" + this.numReference((String)entry.getKey()) + "]-->[" + stringWriter.toString() + "]\n");
        }
        stringBuffer.append("---------------\n");
        return stringBuffer.toString();
    }

    protected String removeHash(String string) {
        if (string.charAt(0) == '#') {
            return string.substring(1);
        }
        return string;
    }
}

