/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.xmlnode;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.InputSource;
import weblogic.utils.collections.Pool;
import weblogic.utils.collections.StackPool;
import weblogic.xml.babel.baseparser.Attribute;
import weblogic.xml.babel.baseparser.BaseParser;
import weblogic.xml.babel.baseparser.CharDataElement;
import weblogic.xml.babel.baseparser.Element;
import weblogic.xml.babel.baseparser.ParseException;
import weblogic.xml.babel.baseparser.StartElement;
import weblogic.xml.babel.scanner.ScannerException;
import weblogic.xml.babel.stream.XMLInputStreamBase;
import weblogic.xml.xmlnode.XMLNode;
import weblogic.xml.xmlnode.XMLNodeException;

public class NodeBuilder {
    private static Pool parserPool = new StackPool(32);
    private BaseParser baseParser;
    private XMLNode current;

    public NodeBuilder(XMLNode xMLNode, InputStream inputStream) throws IOException, ScannerException, XMLNodeException, ParseException {
        this.current = xMLNode;
        this.baseParser = new BaseParser(inputStream);
        this.build();
    }

    public NodeBuilder(XMLNode xMLNode, Reader reader) throws IOException, ScannerException, XMLNodeException, ParseException {
        this.current = xMLNode;
        this.grabBaseParser(reader);
        this.build();
        this.releaseBaseParser();
    }

    public void grabBaseParser(Reader reader) throws IOException, ScannerException {
        this.baseParser = (BaseParser)parserPool.remove();
        if (this.baseParser == null) {
            this.baseParser = new BaseParser(reader);
        } else {
            this.baseParser.recycle(reader);
        }
    }

    public void releaseBaseParser() {
        parserPool.add(this.baseParser);
        this.baseParser = null;
    }

    private void build() throws XMLNodeException, ParseException, IOException, ScannerException {
        Element element = this.skipToStartElement();
        this.populateRoot((StartElement)element);
        this.populateChildren();
    }

    private void populateRoot(StartElement startElement) {
        this.current.setName(this.current.createXMLName(startElement.getLocalName(), startElement.getPrefix(), startElement.getURI()));
        this.populateAttributes(startElement);
    }

    private void populateAttributes(StartElement startElement) {
        List list = startElement.getAttributes();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (attribute.isNameSpaceDeclaration()) {
                this.current.addNamespace(attribute.getLocalName(), attribute.getValue());
                continue;
            }
            if (attribute.declaresDefaultNameSpace()) {
                this.current.addNamespace("", attribute.getValue());
                continue;
            }
            this.current.addAttribute(attribute.getLocalName(), attribute.getPrefix(), attribute.getURI(), attribute.getValue());
            this.handleHref(attribute);
        }
    }

    private void handleHref(Attribute attribute) {
        if (attribute.getLocalName().equals("href")) {
            String string = attribute.getValue();
            this.current.hrefs().addReference(string, this.current);
        } else if (attribute.getLocalName().equals("id")) {
            String string = attribute.getValue();
            this.current.hrefs().addTarget(string, this.current);
        }
    }

    private void populateChildren() throws ParseException, IOException, ScannerException {
        while (this.baseParser.hasNext()) {
            Element element = this.baseParser.parseSome();
            switch (element.type) {
                case 3: {
                    this.current = this.current.getParent();
                    return;
                }
                case 0: {
                    XMLNode xMLNode;
                    this.current = xMLNode = this.current.addChild(element.getLocalName(), element.getPrefix(), element.getURI());
                    this.populateAttributes((StartElement)element);
                    this.populateChildren();
                    break;
                }
                case 5: {
                    XMLNode xMLNode = this.current.addText(((CharDataElement)element).getContent());
                    break;
                }
                case 7: {
                    XMLNode xMLNode = this.current.addText(((CharDataElement)element).getContent());
                    xMLNode.isSpace = true;
                }
            }
        }
        throw new ParseException("Unable to find end element for:" + this.current);
    }

    private Element skipToStartElement() throws XMLNodeException, ParseException, IOException, ScannerException {
        while (this.baseParser.hasNext()) {
            Element element = this.baseParser.parseSome();
            if (element.type != 0) continue;
            return element;
        }
        throw new XMLNodeException("unable to find start element");
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        int n;
        int n2;
        int n3 = Integer.parseInt(stringArray[0]);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileInputStream fileInputStream = new FileInputStream(stringArray[1]);
        while ((n2 = fileInputStream.read()) != -1) {
            byteArrayOutputStream.write((char)n2);
        }
        byteArrayOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        long l = System.currentTimeMillis();
        for (n = 0; n < n3; ++n) {
            object = new XMLNode();
            ((XMLNode)object).read(new ByteArrayInputStream(byArray));
        }
        System.out.println("old node " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        for (n = 0; n < n3; ++n) {
            object = new XMLInputStreamBase();
            ((XMLInputStreamBase)object).open(new InputSource(new ByteArrayInputStream(byArray)));
            while (((XMLInputStreamBase)object).hasNext()) {
                ((XMLInputStreamBase)object).next();
            }
        }
        System.out.println("stream " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        for (n = 0; n < n3; ++n) {
            object = new XMLNode();
            new NodeBuilder((XMLNode)object, new ByteArrayInputStream(byArray));
        }
        System.out.println("new node " + (System.currentTimeMillis() - l));
    }
}

