/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.stream.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import weblogic.utils.collections.Pool;
import weblogic.utils.collections.StackPool;
import weblogic.xml.babel.reader.XmlReader;
import weblogic.xml.babel.stream.XMLInputStreamBase;
import weblogic.xml.stream.ElementFilter;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.util.TypeFilter;
import weblogic.xml.stream.util.XMLInputStreamFilterBase;

public final class RecyclingFactory {
    private static final boolean debug = false;
    private Pool pool;
    private static final XMLInputStreamFactory factory = XMLInputStreamFactory.newInstance();

    public RecyclingFactory() {
        this.pool = new StackPool(32);
    }

    public RecyclingFactory(int n) {
        this.pool = new StackPool(n);
    }

    private static XMLInputStream wrap(XMLInputStream xMLInputStream, ElementFilter elementFilter) throws XMLStreamException {
        return new XMLInputStreamFilterBase(xMLInputStream, elementFilter);
    }

    public XMLInputStream remove(InputStream inputStream) throws XMLStreamException {
        try {
            return this.remove(XmlReader.createReader(inputStream));
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public XMLInputStream remove(Reader reader) throws XMLStreamException {
        XMLInputStreamBase xMLInputStreamBase = (XMLInputStreamBase)this.pool.remove();
        if (xMLInputStreamBase == null) {
            return factory.newInputStream(reader);
        }
        xMLInputStreamBase.recycle(reader);
        return xMLInputStreamBase;
    }

    public XMLInputStream remove(InputStream inputStream, ElementFilter elementFilter) throws XMLStreamException {
        return RecyclingFactory.wrap(this.remove(inputStream), elementFilter);
    }

    public XMLInputStream remove(Reader reader, ElementFilter elementFilter) throws XMLStreamException {
        return RecyclingFactory.wrap(this.remove(reader), elementFilter);
    }

    public boolean add(XMLInputStream xMLInputStream) throws XMLStreamException {
        if (xMLInputStream instanceof XMLInputStreamBase) {
            ((XMLInputStreamBase)xMLInputStream).clear();
            this.pool.add(xMLInputStream);
            return true;
        }
        if (xMLInputStream instanceof XMLInputStreamFilterBase) {
            return this.add(((XMLInputStreamFilterBase)xMLInputStream).getParent());
        }
        return false;
    }

    public static void main(String[] stringArray) throws Exception {
        RecyclingFactory recyclingFactory = new RecyclingFactory();
        TypeFilter typeFilter = new TypeFilter(6);
        for (int i = 0; i < 50; ++i) {
            XMLInputStream xMLInputStream = recyclingFactory.remove(new FileInputStream(stringArray[0]));
            XMLInputStream xMLInputStream2 = recyclingFactory.remove(new FileInputStream(stringArray[0]));
            recyclingFactory.add(xMLInputStream);
            recyclingFactory.add(xMLInputStream2);
            xMLInputStream = recyclingFactory.remove(new FileInputStream(stringArray[0]), (ElementFilter)typeFilter);
            xMLInputStream2 = RecyclingFactory.wrap(xMLInputStream, typeFilter);
            System.out.println(recyclingFactory.add(xMLInputStream));
            System.out.println(recyclingFactory.add(xMLInputStream2));
        }
    }
}

