/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.stream;

import java.util.Iterator;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.AttributeIterator;
import weblogic.xml.stream.CharacterData;
import weblogic.xml.stream.Comment;
import weblogic.xml.stream.EndDocument;
import weblogic.xml.stream.EndElement;
import weblogic.xml.stream.ProcessingInstruction;
import weblogic.xml.stream.Space;
import weblogic.xml.stream.StartDocument;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.events.AttributeImpl;
import weblogic.xml.stream.events.AttributeIteratorImpl;
import weblogic.xml.stream.events.CharacterDataEvent;
import weblogic.xml.stream.events.CommentEvent;
import weblogic.xml.stream.events.EndDocumentEvent;
import weblogic.xml.stream.events.EndElementEvent;
import weblogic.xml.stream.events.Name;
import weblogic.xml.stream.events.ProcessingInstructionEvent;
import weblogic.xml.stream.events.SpaceEvent;
import weblogic.xml.stream.events.StartDocumentEvent;
import weblogic.xml.stream.events.StartElementEvent;

public class ElementFactory {
    public static XMLName createXMLName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The local name of an XMLName may not be null.");
        }
        return new Name(string);
    }

    public static XMLName createXMLName(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("The local name of an XMLName may not be null.");
        }
        return new Name(string, string2);
    }

    public static XMLName createXMLName(String string, String string2, String string3) {
        if (string2 == null) {
            throw new IllegalArgumentException("The local name of an XMLName may not be null.");
        }
        return new Name(string, string2, string3);
    }

    public static Attribute createAttribute(String string, String string2) {
        return new AttributeImpl(string, string2);
    }

    public static Attribute createAttribute(String string, String string2, String string3) {
        return new AttributeImpl(string, string2, string3);
    }

    public static Attribute createAttribute(XMLName xMLName, String string, String string2) {
        return new AttributeImpl(xMLName, string, string2);
    }

    public static Attribute createAttribute(XMLName xMLName, String string) {
        return new AttributeImpl(xMLName, string, "CDATA");
    }

    public static Attribute createNamespaceAttribute(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("namespaceUri cannot be null");
        }
        if (string == null) {
            return ElementFactory.createAttribute("xmlns", string2);
        }
        return ElementFactory.createAttribute(ElementFactory.createXMLName(null, string, "xmlns"), string2, "CDATA");
    }

    public static StartElement createStartElement(String string, String string2, String string3) {
        return new StartElementEvent(new Name(string, string2, string3));
    }

    public static StartElement createStartElement(String string, String string2) {
        return new StartElementEvent(new Name(string, string2));
    }

    public static StartElement createStartElement(String string) {
        return new StartElementEvent(new Name(string));
    }

    public static StartElement createStartElement(XMLName xMLName) {
        return new StartElementEvent(xMLName);
    }

    public static StartElement createStartElement(XMLName xMLName, AttributeIterator attributeIterator) {
        StartElementEvent startElementEvent = new StartElementEvent(xMLName);
        if (attributeIterator != null) {
            while (attributeIterator.hasNext()) {
                startElementEvent.addAttribute(attributeIterator.next());
            }
        }
        return startElementEvent;
    }

    public static StartElement createStartElement(XMLName xMLName, AttributeIterator attributeIterator, AttributeIterator attributeIterator2) {
        StartElementEvent startElementEvent = new StartElementEvent(xMLName);
        if (attributeIterator != null) {
            while (attributeIterator.hasNext()) {
                startElementEvent.addAttribute(attributeIterator.next());
            }
        }
        if (attributeIterator2 != null) {
            while (attributeIterator2.hasNext()) {
                startElementEvent.addNamespace(attributeIterator2.next());
            }
        }
        return startElementEvent;
    }

    public static EndElement createEndElement(XMLName xMLName) {
        return new EndElementEvent(xMLName);
    }

    public static EndElement createEndElement(String string, String string2, String string3) {
        return new EndElementEvent(new Name(string, string2, string3));
    }

    public static EndElement createEndElement(String string, String string2) {
        return new EndElementEvent(new Name(string, string2));
    }

    public static EndElement createEndElement(String string) {
        return new EndElementEvent(new Name(string));
    }

    public static CharacterData createCharacterData(String string) {
        return new CharacterDataEvent(string);
    }

    public static ProcessingInstruction createProcessingInstruction(XMLName xMLName, String string) {
        return new ProcessingInstructionEvent(xMLName, string);
    }

    public static Space createSpace(String string) {
        return new SpaceEvent(string);
    }

    public static Comment createComment(String string) {
        return new CommentEvent(string);
    }

    public static StartDocument createStartDocument() {
        return new StartDocumentEvent();
    }

    public static StartDocument createStartDocument(String string, String string2, String string3) {
        StartDocumentEvent startDocumentEvent = new StartDocumentEvent();
        startDocumentEvent.setEncoding(string);
        startDocumentEvent.setStandalone(string3);
        startDocumentEvent.setVersion(string2);
        return startDocumentEvent;
    }

    public static StartDocument createStartDocument(String string, String string2) {
        StartDocumentEvent startDocumentEvent = new StartDocumentEvent();
        startDocumentEvent.setEncoding(string);
        startDocumentEvent.setVersion(string2);
        return startDocumentEvent;
    }

    public static StartDocument createStartDocument(String string) {
        StartDocumentEvent startDocumentEvent = new StartDocumentEvent();
        startDocumentEvent.setEncoding(string);
        return startDocumentEvent;
    }

    public static EndDocument createEndDocument() {
        return new EndDocumentEvent();
    }

    public static AttributeIterator createAttributeIterator(Iterator iterator) {
        return new AttributeIteratorImpl(iterator);
    }
}

