/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types.util;

import java.math.BigInteger;
import weblogic.xml.schema.types.Duration;

public class XSDDurationSerializer {
    private static final char YEAR = 'Y';
    private static final char MONTH = 'M';
    private static final char DAY = 'D';
    private static final char HOUR = 'H';
    private static final char MINUTE = 'M';
    private static final char SECOND = 'S';

    public static String getString(Duration duration) {
        StringBuffer stringBuffer = new StringBuffer();
        XSDDurationSerializer.setSign(duration, stringBuffer);
        stringBuffer.append('P');
        XSDDurationSerializer.setDate(duration, stringBuffer);
        XSDDurationSerializer.setTime(duration, stringBuffer);
        return stringBuffer.toString();
    }

    private static void setSign(Duration duration, StringBuffer stringBuffer) {
        if (duration.getSignum() == -1) {
            stringBuffer.append('-');
        }
    }

    private static void setDate(Duration duration, StringBuffer stringBuffer) {
        BigInteger bigInteger = duration.getYears();
        if (bigInteger != null) {
            stringBuffer.append(bigInteger.toString() + 'Y');
        }
        if ((bigInteger = duration.getMonths()) != null) {
            stringBuffer.append(bigInteger.toString() + 'M');
        }
        if ((bigInteger = duration.getDays()) != null) {
            stringBuffer.append(bigInteger.toString() + 'D');
        }
    }

    private static void setTime(Duration duration, StringBuffer stringBuffer) {
        stringBuffer.append('T');
        int n = 0;
        BigInteger bigInteger = duration.getHours();
        if (bigInteger != null) {
            stringBuffer.append(bigInteger.toString() + 'H');
            ++n;
        }
        if ((bigInteger = duration.getMinutes()) != null) {
            stringBuffer.append(bigInteger.toString() + 'M');
            ++n;
        }
        if ((bigInteger = duration.getSeconds()) != null) {
            stringBuffer.append(bigInteger.toString());
            ++n;
            bigInteger = duration.getSecondFraction();
            if (bigInteger != null) {
                stringBuffer.append('.' + bigInteger.toString() + 'S');
            } else {
                stringBuffer.append('S');
            }
        }
        if (n == 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
    }
}

