/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types.util;

import java.util.Calendar;

public class XSDDateTimeSerializer {
    protected static final char MINUS = '-';
    protected static final char PLUS = '+';
    protected static final char COLON = ':';
    protected static final char PERIOD = '.';
    protected static final char ZERO = '0';
    protected static final char T = 'T';

    public static String getString(Calendar calendar) {
        StringBuffer stringBuffer = new StringBuffer();
        XSDDateTimeSerializer.setEra(calendar, stringBuffer);
        XSDDateTimeSerializer.setDate(calendar, stringBuffer);
        stringBuffer.append('T');
        XSDDateTimeSerializer.setTime(calendar, stringBuffer);
        XSDDateTimeSerializer.setTimeZone(calendar, stringBuffer);
        return stringBuffer.toString();
    }

    protected static void setEra(Calendar calendar, StringBuffer stringBuffer) {
        if (calendar.get(0) == 0) {
            stringBuffer.append('-');
        }
    }

    protected static void setDate(Calendar calendar, StringBuffer stringBuffer) {
        XSDDateTimeSerializer.setYear(calendar, stringBuffer);
        stringBuffer.append('-');
        XSDDateTimeSerializer.setMonth(calendar, stringBuffer);
        stringBuffer.append('-');
        XSDDateTimeSerializer.setDay(calendar, stringBuffer);
    }

    protected static void setYear(Calendar calendar, StringBuffer stringBuffer) {
        int n = calendar.get(1);
        if (n < 10) {
            stringBuffer.append("000");
        } else if (n < 100) {
            stringBuffer.append("00");
        } else if (n < 1000) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
    }

    protected static void setMonth(Calendar calendar, StringBuffer stringBuffer) {
        int n = calendar.get(2) + 1;
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
    }

    protected static void setDay(Calendar calendar, StringBuffer stringBuffer) {
        int n = calendar.get(5);
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
    }

    protected static void setTime(Calendar calendar, StringBuffer stringBuffer) {
        int n = calendar.get(11);
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
        stringBuffer.append(':');
        int n2 = calendar.get(12);
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2);
        stringBuffer.append(':');
        int n3 = calendar.get(13);
        if (n3 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n3);
        int n4 = calendar.get(14);
        if (n4 != 0) {
            stringBuffer.append('.');
            if (n4 < 100) {
                stringBuffer.append('0');
            }
            if (n4 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n4);
        }
    }

    protected static void setTimeZone(Calendar calendar, StringBuffer stringBuffer) {
        int n = 0;
        n = calendar.isSet(0) && calendar.isSet(1) && calendar.isSet(2) && calendar.isSet(5) && calendar.isSet(7) && calendar.isSet(14) ? calendar.getTimeZone().getOffset(calendar.get(0), calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), calendar.get(14)) : calendar.getTimeZone().getRawOffset();
        if (n == 0) {
            stringBuffer.append('Z');
            return;
        }
        boolean bl = false;
        if (n < 0) {
            n *= -1;
            bl = true;
        }
        int n2 = n % 1000;
        int n3 = (n - n2) / 1000;
        int n4 = n3 % 60;
        int n5 = (n3 - n4) / 60;
        int n6 = n5 % 60;
        int n7 = (n5 - n6) / 60;
        if (bl) {
            stringBuffer.append('-');
        } else {
            stringBuffer.append('+');
        }
        if (n7 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n7);
        stringBuffer.append(':');
        if (n6 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n6);
    }
}

