/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types.util;

import java.util.Calendar;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class XSDDateTimeDeserializer {
    private static final boolean VERBOSE = false;
    private static final String DELIMITERS = "-,+,:,T,Z";
    private static final String MINUS = "-";
    private static final String PLUS = "+";
    private static final String COLON = ":";
    private static final String PERIOD = ".";
    private static final String T = "T";
    private static final String Z = "Z";
    private static final String ZERO = "0";
    private static final String GMT = "GMT";
    private static final String GMT_OFFSET = "+00:00";

    public Calendar getCalendar(String string) {
        Calendar calendar = Calendar.getInstance();
        this.init(calendar);
        try {
            this.setCalendarFields(calendar, string);
            this.validate(calendar);
            this.wrapup(calendar);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Element of dateTime is not in valid range: " + illegalArgumentException.getMessage());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not parse dateTime: " + exception);
        }
        return calendar;
    }

    protected void init(Calendar calendar) {
        calendar.clear();
        calendar.setLenient(false);
    }

    protected void validate(Calendar calendar) {
        calendar.getTime();
    }

    protected void wrapup(Calendar calendar) {
        calendar.setLenient(true);
    }

    protected void setCalendarFields(Calendar calendar, String string) {
        string = this.setEra(calendar, string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMITERS, true);
        try {
            this.setDate(calendar, stringTokenizer);
            if (!stringTokenizer.nextToken().equals(T)) {
                throw new IllegalArgumentException("Invalid date / time delimiter.");
            }
            this.setTime(calendar, stringTokenizer);
            this.setTimeZone(calendar, stringTokenizer);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException("Missing elements.");
        }
    }

    protected String setEra(Calendar calendar, String string) {
        String string2 = string;
        if (string.startsWith(MINUS)) {
            calendar.set(0, 0);
            string2 = string.substring(1);
        } else {
            calendar.set(0, 1);
        }
        return string2;
    }

    protected void setDate(Calendar calendar, StringTokenizer stringTokenizer) {
        try {
            this.setYear(calendar, stringTokenizer);
            if (!stringTokenizer.nextToken().equals(MINUS)) {
                throw new IllegalArgumentException("Invalid year / month delimiter.");
            }
            this.setMonth(calendar, stringTokenizer);
            if (!stringTokenizer.nextToken().equals(MINUS)) {
                throw new IllegalArgumentException("Invalid month / day delimiter.");
            }
            this.setDay(calendar, stringTokenizer);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException("Missing delimiter in date fields.");
        }
    }

    protected void setYear(Calendar calendar, StringTokenizer stringTokenizer) {
        try {
            String string = stringTokenizer.nextToken();
            calendar.set(1, Integer.parseInt(string));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException("Missing year.");
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Year is not an int.");
        }
    }

    protected void setMonth(Calendar calendar, StringTokenizer stringTokenizer) {
        try {
            String string = stringTokenizer.nextToken();
            if (string.length() != 2) {
                throw new IllegalArgumentException("Month has invalid length.");
            }
            calendar.set(2, Integer.parseInt(string) - 1);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException("Missing month.");
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Month is not an int.");
        }
    }

    protected void setDay(Calendar calendar, StringTokenizer stringTokenizer) {
        try {
            String string = stringTokenizer.nextToken();
            if (string.length() != 2) {
                throw new IllegalArgumentException("Day has invalid length.");
            }
            calendar.set(5, Integer.parseInt(string));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException("Missing day.");
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Day is not an int.");
        }
    }

    protected void setTime(Calendar calendar, StringTokenizer stringTokenizer) {
        try {
            String string = stringTokenizer.nextToken();
            if (string.length() != 2) {
                throw new IllegalArgumentException("Hours have invalid length.");
            }
            calendar.set(11, Integer.parseInt(string));
            if (!stringTokenizer.nextToken().equals(COLON)) {
                throw new IllegalArgumentException("Invalid hour / minute delimiter.");
            }
            string = stringTokenizer.nextToken();
            if (string.length() != 2) {
                throw new IllegalArgumentException("Minutes have invalid length.");
            }
            calendar.set(12, Integer.parseInt(string));
            if (!stringTokenizer.nextToken().equals(COLON)) {
                throw new IllegalArgumentException("Invalid minute / second delimiter.");
            }
            string = stringTokenizer.nextToken();
            int n = string.length();
            if (n == 2) {
                calendar.set(13, Integer.parseInt(string));
                calendar.set(14, 0);
            } else {
                if (string.length() < 2) {
                    throw new IllegalArgumentException("Seconds have invalid length.");
                }
                int n2 = string.indexOf(PERIOD);
                if (n2 != 2) {
                    throw new IllegalArgumentException("Seconds have invalid format.");
                }
                String string2 = string.substring(3);
                int n3 = string2.length();
                if (n3 == 0) {
                    throw new IllegalArgumentException("Seconds have invalid format.");
                }
                if (n3 > 3) {
                    string2 = string2.substring(0, 3);
                } else if (n3 == 1) {
                    string2 = string2 + ZERO + ZERO;
                } else if (n3 == 2) {
                    string2 = string2 + ZERO;
                }
                calendar.set(13, Integer.parseInt(string.substring(0, 2)));
                calendar.set(14, Integer.parseInt(string2));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException("Missing element in time fields.");
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Element in time fields not an int.");
        }
    }

    protected void setTimeZone(Calendar calendar, StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        String string = stringTokenizer.nextToken();
        if (string.equals(Z)) {
            this.setGMT(calendar);
            if (stringTokenizer.hasMoreTokens()) {
                throw new IllegalArgumentException("Invalid timezone format.");
            }
        } else if (string.equals(MINUS) || string.equals(PLUS)) {
            this.setTimeZone(calendar, stringTokenizer, string);
        } else {
            throw new IllegalArgumentException("Invalid timezone format.");
        }
    }

    protected void setTimeZone(Calendar calendar, StringTokenizer stringTokenizer, String string) {
        try {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() != 2) {
                throw new IllegalArgumentException("Hours of timezone have invalid length.");
            }
            int n = Integer.parseInt(string2);
            if (!stringTokenizer.nextToken().equals(COLON)) {
                throw new IllegalArgumentException("Invalid timezone hour / minute delimiter.");
            }
            String string3 = stringTokenizer.nextToken();
            if (string3.length() != 2) {
                throw new IllegalArgumentException("Minutes of timezone have invalid length.");
            }
            int n2 = Integer.parseInt(string3);
            if (n == 0 && n2 == 0) {
                this.setGMT(calendar);
                return;
            }
            int n3 = n * 3600000 + n2 * 60000;
            if (string.equals(MINUS)) {
                n3 *= -1;
            }
            TimeZone timeZone = TimeZone.getTimeZone(GMT + string + string2 + COLON + string3);
            calendar.setTimeZone(timeZone);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException("Missing element in timezone fields.");
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Element in timezone is not an int.");
        }
        if (stringTokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("Invalid timezone format.");
        }
    }

    protected void setGMT(Calendar calendar) {
        calendar.set(15, 0);
        calendar.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
    }
}

