/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;
import weblogic.xml.schema.types.XSDStringRestriction;

public final class XSDToken
extends XSDStringRestriction
implements XSDBuiltinType,
Comparable {
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "token");

    public static XSDToken createFromXml(String string) {
        return new XSDToken(string, false);
    }

    public static XSDToken createFromJava(String string) {
        return new XSDToken(string, true);
    }

    private XSDToken(String string, boolean bl) {
        super(string);
        XSDToken.validateXml(string, bl);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public static String convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        XSDToken.validateXml(string, false);
        return string;
    }

    public static void validateXml(String string, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        int n = string.length();
        int n2 = 48;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl && !TypeUtils.isXmlChar(c)) {
                String string2 = TypeUtils.createInvalidXmlCharMsg(c, i);
                throw new IllegalArgumentException(string2);
            }
            if (c == '\t' || c == '\n' || n2 == 32 && c == ' ' || (i == 0 || i == n - 1) && c == ' ') {
                String string3 = "invalid " + XML_TYPE_NAME + " character (" + c + ") found at index " + i;
                throw new IllegalArgumentException(string3);
            }
            n2 = c;
        }
    }

    public static String getXml(String string, boolean bl) {
        return XSDToken.getCanonicalXml(string, bl);
    }

    public static String getCanonicalXml(String string, boolean bl) {
        XSDToken.validateXml(string, bl);
        return string;
    }
}

