/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;
import weblogic.xml.schema.types.util.XSDTimeDeserializer;
import weblogic.xml.schema.types.util.XSDTimeSerializer;

public final class XSDTime
implements XSDBuiltinType,
Comparable {
    private final Calendar javaValue;
    private final String xmlValue;
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "time");
    private static final XSDTimeDeserializer deser = new XSDTimeDeserializer();
    private static final TimeZone UTC_ZONE = TimeZone.getTimeZone("UTC");
    private static final Calendar theDay = Calendar.getInstance();

    public static XSDTime createFromXml(String string) {
        return new XSDTime(string);
    }

    public static XSDTime createFromCalendar(Calendar calendar) {
        return new XSDTime(calendar);
    }

    private XSDTime(String string) {
        this.xmlValue = string;
        this.javaValue = XSDTime.convertXml(string);
    }

    private XSDTime(Calendar calendar) {
        Calendar calendar2 = (Calendar)theDay.clone();
        XSDTime.copyTime(calendar2, calendar);
        this.javaValue = calendar2;
        this.xmlValue = XSDTime.getXml(calendar2);
    }

    private static void copyTime(Calendar calendar, Calendar calendar2) {
        calendar.setTimeZone(calendar2.getTimeZone());
        calendar.set(theDay.get(1), theDay.get(2), theDay.get(5), calendar2.get(11), calendar2.get(12), calendar2.get(13));
        calendar.set(14, calendar2.get(14));
    }

    public String getXml() {
        return this.xmlValue;
    }

    public String getCanonicalXml() {
        return XSDTime.getCanonicalXml(this.javaValue);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public Object getJavaObject() {
        return this.javaValue;
    }

    public int compareTo(XSDTime xSDTime) {
        Calendar calendar = xSDTime.javaValue;
        Calendar calendar2 = this.javaValue;
        return XSDTime.normalizeAndCompareTimes(calendar2, calendar);
    }

    public int compareTo(Object object) {
        return this.compareTo((XSDTime)object);
    }

    public static Calendar convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        try {
            Calendar calendar = (Calendar)theDay.clone();
            Calendar calendar2 = deser.getCalendar(string);
            XSDTime.copyTime(calendar, calendar2);
            calendar.getTimeInMillis();
            return calendar;
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME, numberFormatException);
            throw new IllegalArgumentException(string2);
        }
    }

    public static void validateXml(String string) {
        XSDTime.convertXml(string);
    }

    public static String getXml(Calendar calendar) {
        return XSDTimeSerializer.getString(calendar);
    }

    public static String getCanonicalXml(Calendar calendar) {
        XSDTime xSDTime = XSDTime.createFromCalendar(calendar);
        Calendar calendar2 = xSDTime.javaValue;
        calendar2.setTimeZone(UTC_ZONE);
        return XSDTimeSerializer.getString(calendar2);
    }

    public String toString() {
        return this.getXml();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XSDTime) {
            Calendar calendar = ((XSDTime)object).javaValue;
            Calendar calendar2 = this.javaValue;
            return 0 == XSDTime.normalizeAndCompareTimes(calendar, calendar2);
        }
        return false;
    }

    public final int hashCode() {
        return this.javaValue.hashCode();
    }

    private static int normalizeAndCompareTimes(Calendar calendar, Calendar calendar2) {
        Calendar calendar3 = XSDTime.normalizeCalendar(calendar);
        Calendar calendar4 = XSDTime.normalizeCalendar(calendar2);
        return XSDTime.compareTimes(calendar3, calendar4);
    }

    private static int compareTimes(Calendar calendar, Calendar calendar2) {
        int n;
        int n2 = calendar.get(11);
        if (n2 < (n = calendar2.get(11))) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        n2 = calendar.get(12);
        if (n2 < (n = calendar2.get(12))) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        n2 = calendar.get(13);
        if (n2 < (n = calendar2.get(13))) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        n2 = calendar.get(14);
        if (n2 < (n = calendar2.get(14))) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        return 0;
    }

    private static Calendar normalizeCalendar(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.setTimeZone(UTC_ZONE);
        calendar2.getTimeInMillis();
        return calendar2;
    }

    static {
        theDay.setTimeZone(UTC_ZONE);
        theDay.setTimeInMillis(1000000000000L);
    }
}

