/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;

public final class XSDShort
extends Number
implements XSDBuiltinType,
Comparable {
    final short javaValue;
    final String xmlValue;
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "short");

    public static XSDShort createFromXml(String string) {
        return new XSDShort(string);
    }

    public static XSDShort createFromShort(short s) {
        return new XSDShort(s);
    }

    private XSDShort(String string) {
        this.xmlValue = string;
        this.javaValue = XSDShort.convertXml(string);
    }

    private XSDShort(short s) {
        this.javaValue = s;
        this.xmlValue = XSDShort.getXml(s);
    }

    private XSDShort(short s, String string) {
        this.javaValue = s;
        this.xmlValue = string;
    }

    public String getXml() {
        return this.xmlValue;
    }

    public String getCanonicalXml() {
        return XSDShort.getCanonicalXml(this.javaValue);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public Object getJavaObject() {
        return new Short(this.javaValue);
    }

    public int intValue() {
        return this.javaValue;
    }

    public long longValue() {
        return this.javaValue;
    }

    public float floatValue() {
        return this.javaValue;
    }

    public double doubleValue() {
        return this.javaValue;
    }

    public int compareTo(XSDShort xSDShort) {
        return this.javaValue - xSDShort.javaValue;
    }

    public int compareTo(Object object) {
        return this.compareTo((XSDShort)object);
    }

    public static short convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        try {
            return Short.parseShort(TypeUtils.trimInitialPlus(string));
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME, numberFormatException);
            throw new IllegalArgumentException(string2);
        }
    }

    public static void validateXml(String string) {
        XSDShort.convertXml(string);
    }

    public static String getXml(short s) {
        return Short.toString(s);
    }

    public static String getCanonicalXml(short s) {
        return Short.toString(s);
    }

    public String toString() {
        return this.getXml();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XSDShort) {
            return ((XSDShort)object).javaValue == this.javaValue;
        }
        return false;
    }

    public final int hashCode() {
        return this.javaValue;
    }
}

