/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;

public final class XSDNotation
implements XSDBuiltinType,
Comparable {
    final String xmlValue;
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "NOTATION");

    public static XSDNotation createFromXml(String string) {
        return new XSDNotation(string, false);
    }

    public static XSDNotation createFromJava(String string) {
        return new XSDNotation(string, true);
    }

    private XSDNotation(String string, boolean bl) {
        XSDNotation.validateXml(string, bl);
        this.xmlValue = string;
    }

    public String getXml() {
        return this.xmlValue;
    }

    public String getCanonicalXml() {
        return this.xmlValue;
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public Object getJavaObject() {
        return this.xmlValue;
    }

    public int compareTo(XSDNotation xSDNotation) {
        return this.xmlValue.compareTo(xSDNotation.xmlValue);
    }

    public int compareTo(Object object) {
        return this.compareTo((XSDNotation)object);
    }

    public static String convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        XSDNotation.validateXml(string, false);
        return string;
    }

    public static void validateXml(String string, boolean bl) {
        TypeUtils.validateXml(string, bl);
    }

    public static String getXml(String string, boolean bl) {
        return XSDNotation.getCanonicalXml(string, bl);
    }

    public static String getCanonicalXml(String string, boolean bl) {
        XSDNotation.validateXml(string, bl);
        return string;
    }

    public String toString() {
        return this.xmlValue;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XSDNotation) {
            return ((XSDNotation)object).xmlValue.equals(this.xmlValue);
        }
        return false;
    }

    public final int hashCode() {
        return this.xmlValue.hashCode();
    }
}

