/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;

public final class XSDInt
extends Number
implements XSDBuiltinType,
Comparable {
    final int javaValue;
    final String xmlValue;
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "int");

    public static XSDInt createFromXml(String string) {
        return new XSDInt(string);
    }

    public static XSDInt createFromInt(int n) {
        return new XSDInt(n);
    }

    private XSDInt(String string) {
        this.xmlValue = string;
        this.javaValue = XSDInt.convertXml(string);
    }

    private XSDInt(int n) {
        this.javaValue = n;
        this.xmlValue = XSDInt.getXml(n);
    }

    private XSDInt(int n, String string) {
        this.javaValue = n;
        this.xmlValue = string;
    }

    public String getXml() {
        return this.xmlValue;
    }

    public String getCanonicalXml() {
        return XSDInt.getCanonicalXml(this.javaValue);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public Object getJavaObject() {
        return new Integer(this.javaValue);
    }

    public int intValue() {
        return this.javaValue;
    }

    public long longValue() {
        return this.javaValue;
    }

    public float floatValue() {
        return this.javaValue;
    }

    public double doubleValue() {
        return this.javaValue;
    }

    public int compareTo(XSDInt xSDInt) {
        int n = this.javaValue;
        int n2 = xSDInt.javaValue;
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public int compareTo(Object object) {
        return this.compareTo((XSDInt)object);
    }

    public static int convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        try {
            return Integer.parseInt(TypeUtils.trimInitialPlus(string));
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME, numberFormatException);
            throw new IllegalArgumentException(string2);
        }
    }

    public static void validateXml(String string) {
        XSDInt.convertXml(string);
    }

    public static String getXml(int n) {
        return Integer.toString(n);
    }

    public static String getCanonicalXml(int n) {
        return Integer.toString(n);
    }

    public String toString() {
        return this.getXml();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XSDInt) {
            return ((XSDInt)object).javaValue == this.javaValue;
        }
        return false;
    }

    public final int hashCode() {
        return this.javaValue;
    }
}

