/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import weblogic.utils.StringUtils;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;
import weblogic.xml.schema.types.XSDIdRef;
import weblogic.xml.util.WhitespaceUtils;

public final class XSDIdRefs
implements XSDBuiltinType {
    final String[] javaValue;
    final String xmlValue;
    int hash = 0;
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "IDREFS");

    public static XSDIdRefs createFromXml(String string) {
        return new XSDIdRefs(string);
    }

    public static XSDIdRefs createFromStrings(String[] stringArray) {
        return new XSDIdRefs(stringArray);
    }

    private XSDIdRefs(String string) {
        this.xmlValue = string;
        this.javaValue = XSDIdRefs.convertXml(string);
    }

    private XSDIdRefs(String[] stringArray) {
        this.javaValue = stringArray;
        this.xmlValue = XSDIdRefs.getCanonicalXml(stringArray);
    }

    public String getXml() {
        return this.xmlValue;
    }

    public String getCanonicalXml() {
        return XSDIdRefs.getCanonicalXml(this.javaValue);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public Object getJavaObject() {
        return this.javaValue;
    }

    public String[] getStrings() {
        return this.javaValue;
    }

    public static String[] convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        List list = WhitespaceUtils.splitOnXMLWhiteSpace(string);
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        XSDIdRefs.validateIdrefs(stringArray);
        return stringArray;
    }

    private static final void validateIdrefs(String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            XSDIdRef.validateXml(stringArray[i]);
        }
    }

    public static void validateXml(String string) {
        XSDIdRefs.convertXml(string);
    }

    public static String getXml(String[] stringArray) {
        return XSDIdRefs.getCanonicalXml(stringArray);
    }

    public static String getCanonicalXml(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        XSDIdRefs.validateIdrefs(stringArray);
        return StringUtils.join(stringArray, " ");
    }

    public String toString() {
        return this.getXml();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XSDIdRefs) {
            XSDIdRefs xSDIdRefs = (XSDIdRefs)object;
            if (xSDIdRefs.hash != this.hash && xSDIdRefs.hash != 0 && this.hash != 0) {
                return false;
            }
            return Arrays.equals(xSDIdRefs.javaValue, this.javaValue);
        }
        return false;
    }

    public final int hashCode() {
        if (this.hash == 0) {
            this.hash = TypeUtils.arrayHashCode(this.javaValue);
        }
        return this.hash;
    }
}

