/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;
import weblogic.xml.schema.types.XSDStringRestriction;
import weblogic.xml.schema.types.util.NameValidator;

public final class XSDIdRef
extends XSDStringRestriction
implements XSDBuiltinType,
Comparable {
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "IDREF");

    public static XSDIdRef createFromXml(String string) {
        return new XSDIdRef(string);
    }

    public static XSDIdRef createFromJava(String string) {
        return new XSDIdRef(string);
    }

    private XSDIdRef(String string) {
        super(string);
        XSDIdRef.validateXml(string);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public static String convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        XSDIdRef.validateXml(string);
        return string;
    }

    public static void validateXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        if (!NameValidator.validNCName(string)) {
            String string2 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME);
            throw new IllegalArgumentException(string2);
        }
    }

    public static String getXml(String string) {
        return XSDIdRef.getCanonicalXml(string);
    }

    public static String getCanonicalXml(String string) {
        XSDIdRef.validateXml(string);
        return string;
    }
}

