/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;
import weblogic.xml.schema.types.util.XSDYearDeserializer;
import weblogic.xml.schema.types.util.XSDYearSerializer;

public final class XSDGYear
implements XSDBuiltinType,
Comparable {
    private final Calendar javaValue;
    private final String xmlValue;
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "gYear");
    private static final XSDYearDeserializer deser = new XSDYearDeserializer();
    private static final TimeZone utc_zone = TimeZone.getTimeZone("UTC");

    public static XSDGYear createFromXml(String string) {
        return new XSDGYear(string);
    }

    public static XSDGYear createFromCalendar(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        return new XSDGYear(calendar2);
    }

    private XSDGYear(String string) {
        this.xmlValue = string;
        this.javaValue = XSDGYear.convertXml(string);
    }

    private XSDGYear(Calendar calendar) {
        this.javaValue = calendar;
        this.xmlValue = XSDGYear.getXml(calendar);
    }

    private XSDGYear(Calendar calendar, String string) {
        this.javaValue = calendar;
        this.xmlValue = string;
    }

    public String getXml() {
        return this.xmlValue;
    }

    public String getCanonicalXml() {
        return XSDGYear.getCanonicalXml(this.javaValue);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public Object getJavaObject() {
        return this.javaValue;
    }

    public Calendar getCalendar() {
        return this.javaValue;
    }

    public int compareTo(XSDGYear xSDGYear) {
        int n;
        int n2 = this.javaValue.get(1);
        return n2 < (n = xSDGYear.javaValue.get(1)) ? -1 : (n2 == n ? 0 : 1);
    }

    public int compareTo(Object object) {
        return this.compareTo((XSDGYear)object);
    }

    public static Calendar convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        try {
            return deser.getCalendar(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME, numberFormatException);
            throw new IllegalArgumentException(string2);
        }
    }

    public static void validateXml(String string) {
        XSDGYear.convertXml(string);
    }

    public static String getXml(Calendar calendar) {
        return XSDYearSerializer.getString(calendar);
    }

    public static String getCanonicalXml(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.set(6, 10);
        calendar2.setTimeZone(utc_zone);
        return XSDGYear.getXml(calendar2);
    }

    public String toString() {
        return this.getXml();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XSDGYear) {
            XSDGYear xSDGYear = (XSDGYear)object;
            return 0 == this.compareTo(xSDGYear);
        }
        return false;
    }

    public final int hashCode() {
        return this.javaValue.hashCode();
    }
}

