/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;
import weblogic.xml.schema.types.util.XSDMonthDayDeserializer;
import weblogic.xml.schema.types.util.XSDMonthDaySerializer;

public final class XSDGMonthDay
implements XSDBuiltinType,
Comparable {
    private final Calendar javaValue;
    private final String xmlValue;
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "gMonthDay");
    private static final XSDMonthDayDeserializer deser = new XSDMonthDayDeserializer();
    private static final TimeZone UTC_ZONE = TimeZone.getTimeZone("UTC");
    private static final int BASE_YEAR = 1996;

    public static XSDGMonthDay createFromXml(String string) {
        return new XSDGMonthDay(string);
    }

    public static XSDGMonthDay createFromCalendar(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        return new XSDGMonthDay(calendar2);
    }

    private XSDGMonthDay(String string) {
        this.xmlValue = string;
        this.javaValue = XSDGMonthDay.convertXml(string);
    }

    private XSDGMonthDay(Calendar calendar) {
        this.javaValue = calendar;
        this.javaValue.set(1, 1996);
        this.xmlValue = XSDGMonthDay.getXml(calendar);
    }

    public String getXml() {
        return this.xmlValue;
    }

    public String getCanonicalXml() {
        return XSDGMonthDay.getCanonicalXml(this.javaValue);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public Object getJavaObject() {
        return this.javaValue;
    }

    public Calendar getCalendar() {
        return this.javaValue;
    }

    public int compareTo(XSDGMonthDay xSDGMonthDay) {
        int n;
        Calendar calendar = XSDGMonthDay.normalizeCalendar(this.javaValue);
        Calendar calendar2 = XSDGMonthDay.normalizeCalendar(xSDGMonthDay.javaValue);
        int n2 = calendar.get(6);
        return n2 < (n = calendar2.get(6)) ? -1 : (n2 == n ? 0 : 1);
    }

    public int compareTo(Object object) {
        return this.compareTo((XSDGMonthDay)object);
    }

    private static Calendar normalizeCalendar(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.set(1, 1996);
        calendar2.setTimeZone(UTC_ZONE);
        calendar2.getTimeInMillis();
        return calendar2;
    }

    public static Calendar convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        try {
            return deser.getCalendar(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME, numberFormatException);
            throw new IllegalArgumentException(string2);
        }
    }

    public static void validateXml(String string) {
        XSDGMonthDay.convertXml(string);
    }

    public static String getXml(Calendar calendar) {
        return XSDMonthDaySerializer.getString(calendar);
    }

    public static String getCanonicalXml(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.set(1, 1996);
        calendar2.setTimeZone(UTC_ZONE);
        return XSDMonthDaySerializer.getString(calendar2);
    }

    public String toString() {
        return this.getXml();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XSDGMonthDay) {
            XSDGMonthDay xSDGMonthDay = (XSDGMonthDay)object;
            return 0 == this.compareTo(xSDGMonthDay);
        }
        return false;
    }

    public final int hashCode() {
        return this.javaValue.hashCode();
    }
}

