/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;
import weblogic.xml.schema.types.util.XSDDayDeserializer;
import weblogic.xml.schema.types.util.XSDDaySerializer;

public final class XSDGDay
implements XSDBuiltinType,
Comparable {
    private final Calendar javaValue;
    private final String xmlValue;
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "gDay");
    private static final XSDDayDeserializer deser = new XSDDayDeserializer();
    private static final TimeZone utc_zone = TimeZone.getTimeZone("UTC");

    public static XSDGDay createFromXml(String string) {
        return new XSDGDay(string);
    }

    public static XSDGDay createFromCalendar(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        return new XSDGDay(calendar2);
    }

    private XSDGDay(String string) {
        this.xmlValue = string;
        this.javaValue = XSDGDay.convertXml(string);
    }

    private XSDGDay(Calendar calendar) {
        this.javaValue = calendar;
        this.xmlValue = XSDGDay.getXml(calendar);
    }

    private XSDGDay(Calendar calendar, String string) {
        this.javaValue = calendar;
        this.xmlValue = string;
    }

    public String getXml() {
        return this.xmlValue;
    }

    public String getCanonicalXml() {
        return XSDGDay.getCanonicalXml(this.javaValue);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public Object getJavaObject() {
        return this.javaValue;
    }

    public Calendar getCalendar() {
        return this.javaValue;
    }

    public int compareTo(XSDGDay xSDGDay) {
        int n;
        int n2 = this.javaValue.get(5);
        return n2 < (n = xSDGDay.javaValue.get(5)) ? -1 : (n2 == n ? 0 : 1);
    }

    public int compareTo(Object object) {
        return this.compareTo((XSDGDay)object);
    }

    public static Calendar convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        try {
            return deser.getCalendar(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME, numberFormatException);
            throw new IllegalArgumentException(string2);
        }
    }

    public static void validateXml(String string) {
        XSDGDay.convertXml(string);
    }

    public static String getXml(Calendar calendar) {
        return XSDDaySerializer.getString(calendar);
    }

    public static String getCanonicalXml(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.set(11, 12);
        calendar2.setTimeZone(utc_zone);
        return XSDGDay.getXml(calendar2);
    }

    public String toString() {
        return this.getXml();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XSDGDay) {
            XSDGDay xSDGDay = (XSDGDay)object;
            return 0 == this.compareTo(xSDGDay);
        }
        return false;
    }

    public final int hashCode() {
        return this.javaValue.hashCode();
    }
}

