/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import java.math.BigDecimal;
import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;

public final class XSDDecimal
extends Number
implements XSDBuiltinType,
Comparable {
    final BigDecimal javaValue;
    final String xmlValue;
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "decimal");

    public static XSDDecimal createFromXml(String string) {
        return new XSDDecimal(string);
    }

    public static XSDDecimal createFromBigDecimal(BigDecimal bigDecimal) {
        return new XSDDecimal(bigDecimal);
    }

    private XSDDecimal(String string) {
        this.xmlValue = string;
        this.javaValue = XSDDecimal.convertXml(string);
    }

    private XSDDecimal(BigDecimal bigDecimal) {
        this.javaValue = bigDecimal;
        this.xmlValue = XSDDecimal.getXml(bigDecimal);
    }

    private XSDDecimal(BigDecimal bigDecimal, String string) {
        this.javaValue = bigDecimal;
        this.xmlValue = string;
    }

    public String getXml() {
        return this.xmlValue;
    }

    public String getCanonicalXml() {
        return XSDDecimal.getCanonicalXml(this.javaValue);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public Object getJavaObject() {
        return this.javaValue;
    }

    public int intValue() {
        return this.javaValue.intValue();
    }

    public long longValue() {
        return this.javaValue.longValue();
    }

    public float floatValue() {
        return this.javaValue.floatValue();
    }

    public double doubleValue() {
        return this.javaValue.doubleValue();
    }

    public int compareTo(XSDDecimal xSDDecimal) {
        return this.javaValue.compareTo(xSDDecimal.javaValue);
    }

    public int compareTo(Object object) {
        return this.compareTo((XSDDecimal)object);
    }

    public static BigDecimal convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        try {
            return new BigDecimal(XSDDecimal.trimTrailingZeros(string));
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME, numberFormatException);
            throw new IllegalArgumentException(string2);
        }
    }

    public static void validateXml(String string) {
        XSDDecimal.convertXml(string);
    }

    private static String trimTrailingZeros(String string) {
        int n;
        int n2 = string.length() - 1;
        if (string.charAt(n2) == '0' && (n = string.lastIndexOf(46)) >= 0) {
            for (int i = n2; i > n; --i) {
                if (string.charAt(i) == '0') continue;
                return string.substring(0, i + 1);
            }
            return string.substring(0, n);
        }
        return string;
    }

    public static String getXml(BigDecimal bigDecimal) {
        return bigDecimal.toString();
    }

    public static String getCanonicalXml(BigDecimal bigDecimal) {
        String string = bigDecimal.toString();
        if (bigDecimal.scale() < 1) {
            return string + ".0";
        }
        return string;
    }

    public String toString() {
        return this.getXml();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XSDDecimal) {
            return ((XSDDecimal)object).javaValue.equals(this.javaValue);
        }
        return false;
    }

    public final int hashCode() {
        return this.javaValue.hashCode();
    }
}

