/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;
import weblogic.xml.schema.types.util.XSDDateTimeDeserializer;
import weblogic.xml.schema.types.util.XSDDateTimeSerializer;

public final class XSDDateTime
implements XSDBuiltinType,
Comparable {
    private final Calendar javaValue;
    private final String xmlValue;
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "dateTime");
    private static final XSDDateTimeDeserializer deser = new XSDDateTimeDeserializer();
    private static final TimeZone UTC_ZONE = TimeZone.getTimeZone("UTC");

    public static XSDDateTime createFromXml(String string) {
        return new XSDDateTime(string);
    }

    public static XSDDateTime createFromCalendar(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        return new XSDDateTime(calendar2);
    }

    private XSDDateTime(String string) {
        this.xmlValue = string;
        this.javaValue = XSDDateTime.convertXml(string);
    }

    private XSDDateTime(Calendar calendar) {
        this.javaValue = calendar;
        this.xmlValue = XSDDateTime.getXml(calendar);
    }

    private XSDDateTime(Calendar calendar, String string) {
        this.javaValue = calendar;
        this.xmlValue = string;
    }

    public String getXml() {
        return this.xmlValue;
    }

    public String getCanonicalXml() {
        return XSDDateTime.getCanonicalXml(this.javaValue);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public Object getJavaObject() {
        return this.javaValue;
    }

    public Calendar getCalendar() {
        return this.javaValue;
    }

    public int compareTo(XSDDateTime xSDDateTime) {
        long l;
        long l2 = this.javaValue.getTimeInMillis();
        return l2 < (l = xSDDateTime.javaValue.getTimeInMillis()) ? -1 : (l2 == l ? 0 : 1);
    }

    public int compareTo(Object object) {
        return this.compareTo((XSDDateTime)object);
    }

    public static Calendar convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        try {
            return deser.getCalendar(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME, numberFormatException);
            throw new IllegalArgumentException(string2);
        }
    }

    public static void validateXml(String string) {
        XSDDateTime.convertXml(string);
    }

    public static String getXml(Calendar calendar) {
        return XSDDateTimeSerializer.getString(calendar);
    }

    public static String getCanonicalXml(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.setTimeZone(UTC_ZONE);
        return XSDDateTimeSerializer.getString(calendar2);
    }

    public String toString() {
        return this.getXml();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XSDDateTime) {
            long l;
            long l2 = this.javaValue.getTimeInMillis();
            return l2 == (l = ((XSDDateTime)object).javaValue.getTimeInMillis());
        }
        return false;
    }

    public final int hashCode() {
        return this.javaValue.hashCode();
    }
}

