/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;

public final class XSDByte
extends Number
implements XSDBuiltinType,
Comparable {
    final byte javaValue;
    final String xmlValue;
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "byte");

    public static XSDByte createFromXml(String string) {
        return new XSDByte(string);
    }

    public static XSDByte createFromByte(byte by) {
        return new XSDByte(by);
    }

    private XSDByte(String string) {
        this.xmlValue = string;
        this.javaValue = XSDByte.convertXml(string);
    }

    private XSDByte(byte by) {
        this.javaValue = by;
        this.xmlValue = XSDByte.getXml(by);
    }

    private XSDByte(byte by, String string) {
        this.javaValue = by;
        this.xmlValue = string;
    }

    public String getXml() {
        return this.xmlValue;
    }

    public String getCanonicalXml() {
        return XSDByte.getCanonicalXml(this.javaValue);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public Object getJavaObject() {
        return new Byte(this.javaValue);
    }

    public int intValue() {
        return this.javaValue;
    }

    public long longValue() {
        return this.javaValue;
    }

    public float floatValue() {
        return this.javaValue;
    }

    public double doubleValue() {
        return this.javaValue;
    }

    public int compareTo(XSDByte xSDByte) {
        return this.javaValue - xSDByte.javaValue;
    }

    public int compareTo(Object object) {
        return this.compareTo((XSDByte)object);
    }

    public static byte convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        try {
            return Byte.parseByte(TypeUtils.trimInitialPlus(string));
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME, numberFormatException);
            throw new IllegalArgumentException(string2);
        }
    }

    public static void validateXml(String string) {
        XSDByte.convertXml(string);
    }

    public static String getXml(byte by) {
        return Byte.toString(by);
    }

    public static String getCanonicalXml(byte by) {
        return Byte.toString(by);
    }

    public String toString() {
        return this.getXml();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XSDByte) {
            return ((XSDByte)object).javaValue == this.javaValue;
        }
        return false;
    }

    public final int hashCode() {
        return this.javaValue;
    }
}

