/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import java.lang.reflect.Array;
import javax.xml.namespace.QName;
import weblogic.xml.babel.reader.XmlChars;

final class TypeUtils {
    static final String SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    static final int XML_TOO_LONG = 30;

    TypeUtils() {
    }

    static boolean isXmlChar(int n) {
        return XmlChars.isChar(n);
    }

    static String createInvalidXmlCharMsg(char c, int n) {
        String string = "invalid xml character (" + c + ") found at index " + n;
        return string;
    }

    static void validateXml(String string, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        if (!bl) {
            return;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (TypeUtils.isXmlChar(c)) continue;
            String string2 = TypeUtils.createInvalidXmlCharMsg(c, i);
            throw new IllegalArgumentException(string2);
        }
    }

    static String getTypeNamespace() {
        return SCHEMA_NS;
    }

    static String createInvalidArgMsg(String string, QName qName) {
        if (string.length() > 30) {
            string = string.substring(0, 30) + "...";
        }
        return "\"" + string + "\" is not a valid lexical " + "representation of " + qName;
    }

    static String createInvalidArgMsg(String string, QName qName, Exception exception) {
        return TypeUtils.createInvalidArgMsg(string, qName) + " - " + exception;
    }

    static String createInvalidJavaArgMsg(Object object, QName qName) {
        String string = object.toString();
        if (string.length() > 30) {
            string = string.substring(0, 30) + "...";
        }
        return "\"" + string + "\" is not a valid value " + "for type " + qName;
    }

    static String createInvalidJavaArgMsg(Object object, QName qName, Exception exception) {
        return TypeUtils.createInvalidJavaArgMsg(object, qName) + " - " + exception;
    }

    static String trimInitialPlus(String string) {
        if (string.charAt(0) == '+') {
            return string.substring(1);
        }
        return string;
    }

    static int byteArrayHashCode(byte[] byArray) {
        int n = 17;
        int n2 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            n = 37 * n + byArray[i];
        }
        return n;
    }

    static int arrayHashCode(Object[] objectArray) {
        int n = 17;
        int n2 = objectArray.length;
        for (int i = 0; i < n2; ++i) {
            n = 37 * n + objectArray[i].hashCode();
        }
        return n;
    }

    static String arrayToString(Object object) {
        if (object == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = Array.get(object, i);
            stringBuffer.append(object2 == object ? "(this array)" : String.valueOf(object2));
            if (i >= n - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

