/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import weblogic.utils.AssertionError;
import weblogic.xml.schema.model.BlockSet;
import weblogic.xml.schema.model.DerivationSet;
import weblogic.xml.schema.model.ExpName;
import weblogic.xml.schema.model.FormChoice;
import weblogic.xml.schema.model.SchemaForSchema;
import weblogic.xml.schema.model.SchemaTypes;
import weblogic.xml.schema.model.SimpleSchemaResolver;
import weblogic.xml.schema.model.XSDAnnotation;
import weblogic.xml.schema.model.XSDAnyType;
import weblogic.xml.schema.model.XSDAttribute;
import weblogic.xml.schema.model.XSDAttributeGroup;
import weblogic.xml.schema.model.XSDElement;
import weblogic.xml.schema.model.XSDException;
import weblogic.xml.schema.model.XSDImport;
import weblogic.xml.schema.model.XSDInclude;
import weblogic.xml.schema.model.XSDInclusion;
import weblogic.xml.schema.model.XSDModelGroupDefn;
import weblogic.xml.schema.model.XSDNamedObject;
import weblogic.xml.schema.model.XSDNotation;
import weblogic.xml.schema.model.XSDObject;
import weblogic.xml.schema.model.XSDObjectAttribute;
import weblogic.xml.schema.model.XSDObjectIterator;
import weblogic.xml.schema.model.XSDRedefine;
import weblogic.xml.schema.model.XSDSchema;
import weblogic.xml.schema.model.XSDValidityException;
import weblogic.xml.stream.XMLName;

public class XSDSchema
extends XSDObject
implements Cloneable {
    private String targetNamespace = null;
    private String version;
    private DerivationSet finalDefault;
    private BlockSet blockDefault;
    private FormChoice attributeFormDefault;
    private FormChoice elementFormDefault;
    private String language;
    private List inclusionList = new ArrayList();
    private List annotationList = new ArrayList();
    private Map groupMap = new HashMap();
    private Map elementMap = new HashMap();
    private Map typeMap = new HashMap();
    private Map attributeMap = new HashMap();
    private Map attributeGroupMap = new HashMap();
    private Map notationMap = new HashMap();
    private List componentList = new ArrayList();
    private Map importedSchemas = new HashMap();
    private Map includedSchemas = new HashMap();
    private boolean allResolved = false;
    private SimpleSchemaResolver schemaResolver;
    private String originUrl;
    private boolean autoResolve = true;
    private static final boolean DEBUG = false;

    public XSDSchema() throws XSDException {
        this(true);
    }

    public XSDSchema createChildSchema() throws XSDException {
        XSDSchema xSDSchema = new XSDSchema();
        xSDSchema.schemaResolver = this.getSchemaResolver();
        return xSDSchema;
    }

    XSDSchema(boolean bl) throws XSDException {
        if (bl) {
            XSDSchema xSDSchema = SchemaForSchema.getSchemaForSchemas();
            if (xSDSchema == null) {
                throw new AssertionError("internal error");
            }
            this.importedSchemas.put(xSDSchema.getTargetNamespace(), xSDSchema);
        }
    }

    public void addAll(XSDSchema xSDSchema) throws XSDException {
        this.addAll(xSDSchema, false);
    }

    public void addAll(XSDSchema xSDSchema, boolean bl) throws XSDException {
        Object object;
        if (!ExpName.compareStrings(xSDSchema.getTargetNamespace(), this.targetNamespace)) {
            String string = "targetNamespace " + xSDSchema.getTargetNamespace() + " did not match expected " + this.targetNamespace;
            throw new IllegalArgumentException(string);
        }
        Map map = xSDSchema.getNamespaceMap();
        Iterator<Object> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (this.getNamespaceMap().get(object) != null) continue;
            String string = (String)map.get(object);
            this.addNamespace((String)object, string);
        }
        iterator = xSDSchema.getComponenets().iterator();
        block13: while (iterator.hasNext()) {
            object = (XSDObject)iterator.next();
            int n = ((XSDObject)object).getTypeCode();
            switch (n) {
                case 2: {
                    XSDNamedObject xSDNamedObject = (XSDElement)object;
                    XSDNamedObject xSDNamedObject2 = this.getElement(xSDNamedObject.getXMLName());
                    if (bl) {
                        if (xSDNamedObject2 != null) {
                            this.removeElement((XSDElement)xSDNamedObject2);
                        }
                        this.addElement((XSDElement)xSDNamedObject);
                        continue block13;
                    }
                    if (xSDNamedObject2 != null) continue block13;
                    this.addElement((XSDElement)xSDNamedObject);
                    continue block13;
                }
                case 3: {
                    XSDNamedObject xSDNamedObject = (XSDAttribute)object;
                    XSDNamedObject xSDNamedObject2 = this.getAttribute(xSDNamedObject.getXMLName());
                    if (bl) {
                        if (xSDNamedObject2 != null) {
                            this.removeAttribute((XSDAttribute)xSDNamedObject2);
                        }
                        this.addAttribute((XSDAttribute)xSDNamedObject);
                        continue block13;
                    }
                    if (xSDNamedObject2 != null) continue block13;
                    this.addAttribute((XSDAttribute)xSDNamedObject);
                    continue block13;
                }
                case 4: 
                case 7: {
                    XSDNamedObject xSDNamedObject = (XSDAnyType)object;
                    XSDNamedObject xSDNamedObject2 = this.getType(xSDNamedObject.getXMLName());
                    if (bl) {
                        if (xSDNamedObject2 != null) {
                            this.removeType((XSDAnyType)xSDNamedObject2);
                        }
                        this.addType((XSDAnyType)xSDNamedObject);
                        continue block13;
                    }
                    if (xSDNamedObject2 != null) continue block13;
                    this.addType((XSDAnyType)xSDNamedObject);
                    continue block13;
                }
                case 6: {
                    XSDNamedObject xSDNamedObject = (XSDModelGroupDefn)object;
                    XSDNamedObject xSDNamedObject2 = this.getModelGroupDefn(xSDNamedObject.getXMLName());
                    if (bl) {
                        if (xSDNamedObject2 != null) {
                            this.removeModelGroupDefn((XSDModelGroupDefn)xSDNamedObject2);
                        }
                        this.addModelGroupDefn((XSDModelGroupDefn)xSDNamedObject);
                        continue block13;
                    }
                    if (xSDNamedObject2 != null) continue block13;
                    this.addModelGroupDefn((XSDModelGroupDefn)xSDNamedObject);
                    continue block13;
                }
                case 17: {
                    XSDNamedObject xSDNamedObject = (XSDAttributeGroup)object;
                    XSDNamedObject xSDNamedObject2 = this.getAttributeGroup(xSDNamedObject.getXMLName());
                    if (bl) {
                        if (xSDNamedObject2 != null) {
                            this.removeAttributeGroup((XSDAttributeGroup)xSDNamedObject2);
                        }
                        this.addAttributeGroup((XSDAttributeGroup)xSDNamedObject);
                        continue block13;
                    }
                    if (xSDNamedObject2 != null) continue block13;
                    this.addAttributeGroup((XSDAttributeGroup)xSDNamedObject);
                    continue block13;
                }
                case 31: {
                    XSDNamedObject xSDNamedObject = (XSDNotation)object;
                    XSDNamedObject xSDNamedObject2 = this.getNotation(xSDNamedObject.getXMLName());
                    if (bl) {
                        if (xSDNamedObject2 != null) {
                            this.removeNotation((XSDNotation)xSDNamedObject2);
                        }
                        this.addNotation((XSDNotation)xSDNamedObject);
                        continue block13;
                    }
                    if (xSDNamedObject2 != null) continue block13;
                    this.addNotation((XSDNotation)xSDNamedObject);
                    continue block13;
                }
                case 32: {
                    XSDNamedObject xSDNamedObject = (XSDInclude)object;
                    XSDNamedObject xSDNamedObject2 = this.findInclude(xSDNamedObject.getSchemaLocation());
                    if (bl) {
                        if (xSDNamedObject2 != null) {
                            this.removeInclusion((XSDInclusion)xSDNamedObject2);
                        }
                        this.addInclusion((XSDInclusion)xSDNamedObject);
                        continue block13;
                    }
                    if (xSDNamedObject2 != null) continue block13;
                    this.addInclusion((XSDInclusion)xSDNamedObject);
                    continue block13;
                }
                case 33: {
                    XSDNamedObject xSDNamedObject = (XSDImport)object;
                    XSDNamedObject xSDNamedObject2 = this.findImport(xSDNamedObject.getNamespace());
                    if (bl) {
                        if (xSDNamedObject2 != null) {
                            this.removeInclusion((XSDInclusion)xSDNamedObject2);
                        }
                        this.addInclusion((XSDInclusion)xSDNamedObject);
                        continue block13;
                    }
                    if (xSDNamedObject2 != null) continue block13;
                    this.addInclusion((XSDInclusion)xSDNamedObject);
                    continue block13;
                }
                case 34: {
                    XSDNamedObject xSDNamedObject = (XSDRedefine)object;
                    this.addInclusion((XSDInclusion)xSDNamedObject);
                    continue block13;
                }
                case 12: {
                    XSDNamedObject xSDNamedObject = (XSDAnnotation)object;
                    this.addAnnotation((XSDAnnotation)xSDNamedObject);
                    continue block13;
                }
            }
            throw new AssertionError("unknown component type " + object);
        }
    }

    public boolean isAutoResolve() {
        return this.autoResolve;
    }

    public void setAutoResolve(boolean bl) {
        this.autoResolve = bl;
    }

    public SimpleSchemaResolver getSchemaResolver() {
        if (this.schemaResolver == null) {
            this.schemaResolver = new SimpleSchemaResolver();
        }
        return this.schemaResolver;
    }

    public void setSchemaResolver(SimpleSchemaResolver simpleSchemaResolver) {
        this.schemaResolver = simpleSchemaResolver;
    }

    public String getOriginUrl() {
        return this.originUrl;
    }

    public void setOriginUrl(String string) {
        this.originUrl = string;
        if (string != null) {
            this.getSchemaResolver().defineSchema(string, this);
        }
    }

    public int getTypeCode() {
        return 1;
    }

    protected XMLName getXSDTypeName() {
        return SchemaTypes.SCHEMA_ENAME;
    }

    public void addAnnotation(XSDAnnotation xSDAnnotation) {
        this.annotationList.add(xSDAnnotation);
        this.componentList.add(xSDAnnotation);
        xSDAnnotation.setParent((XSDObject)this);
    }

    public void removeAnnotation(XSDAnnotation xSDAnnotation) {
        this.annotationList.remove(xSDAnnotation);
        this.componentList.remove(xSDAnnotation);
    }

    public void addInclusion(XSDInclusion xSDInclusion) throws XSDException {
        this.addInclusion(xSDInclusion, true);
    }

    public void addInclusion(XSDInclusion xSDInclusion, boolean bl) throws XSDException {
        this.inclusionList.add(xSDInclusion);
        xSDInclusion.setParent((XSDObject)this);
        if (xSDInclusion.getTypeCode() == 32) {
            this.resolveInclude((XSDInclude)xSDInclusion);
        } else {
            this.allResolved = false;
        }
        if (bl) {
            int n = this.componentList.size();
            boolean bl2 = false;
            for (int i = 0; i < n; ++i) {
                if (XSDSchema.isInclusionOrAnnotation((XSDObject)this.componentList.get(i))) continue;
                this.componentList.add(i, xSDInclusion);
                bl2 = true;
                break;
            }
            if (!bl2) {
                this.componentList.add(xSDInclusion);
            }
        } else {
            this.componentList.add(xSDInclusion);
        }
    }

    private static boolean isInclusionOrAnnotation(XSDObject xSDObject) {
        switch (xSDObject.getTypeCode()) {
            case 12: 
            case 32: 
            case 33: 
            case 34: {
                return true;
            }
        }
        return false;
    }

    public XSDImport findImport(String string) {
        ListIterator listIterator = this.inclusionList.listIterator(this.inclusionList.size());
        while (listIterator.hasPrevious()) {
            XSDInclusion xSDInclusion = (XSDInclusion)listIterator.previous();
            if (xSDInclusion.getTypeCode() != 33) continue;
            XSDImport xSDImport = (XSDImport)xSDInclusion;
            String string2 = xSDImport.getNamespace();
            if (!(string == null ? string2 == null : string.equals(string2))) continue;
            return xSDImport;
        }
        return null;
    }

    public XSDInclude findInclude(String string) {
        ListIterator listIterator = this.inclusionList.listIterator(this.inclusionList.size());
        while (listIterator.hasPrevious()) {
            XSDInclude xSDInclude;
            String string2;
            XSDInclusion xSDInclusion = (XSDInclusion)listIterator.previous();
            if (xSDInclusion.getTypeCode() != 32 || !string.equals(string2 = (xSDInclude = (XSDInclude)xSDInclusion).getSchemaLocation())) continue;
            return xSDInclude;
        }
        return null;
    }

    public void resolveInclusions() throws XSDException {
        if (this.allResolved) {
            return;
        }
        Iterator iterator = this.inclusionList.iterator();
        block5: while (iterator.hasNext()) {
            XSDInclusion xSDInclusion = (XSDInclusion)iterator.next();
            switch (xSDInclusion.getTypeCode()) {
                case 33: {
                    this.resolveImport((XSDImport)xSDInclusion);
                    continue block5;
                }
                case 32: {
                    this.resolveInclude((XSDInclude)xSDInclusion);
                    continue block5;
                }
                case 34: {
                    System.err.println("WARNING: redefine unsupported");
                    continue block5;
                }
            }
            throw new AssertionError("unknown inclusion type: " + xSDInclusion);
        }
        this.allResolved = true;
    }

    private void resolveImport(XSDImport xSDImport) throws XSDException {
        String string = xSDImport.getNamespace();
        if ("http://www.w3.org/2001/XMLSchema".equals(string) || "http://www.w3.org/2001/XMLSchema-instance".equals(string)) {
            return;
        }
        XSDSchema xSDSchema = this.resolveInclusion((XSDInclusion)xSDImport);
        String string2 = xSDSchema.getTargetNamespace();
        if (!ExpName.compareStrings(string2, string)) {
            String string3 = "targetNamespace in imported schema: \"" + string + "\" does not match namespace from import tag: \"" + string2 + "\"";
            throw new XSDValidityException(string3);
        }
        this.importedSchemas.put(string2, xSDSchema);
    }

    private void resolveInclude(XSDInclude xSDInclude) throws XSDException {
        String string = xSDInclude.getSchemaLocation();
        if (this.includedSchemas.containsKey(string)) {
            return;
        }
        XSDSchema xSDSchema = this.resolveInclusion((XSDInclusion)xSDInclude);
        String string2 = xSDSchema.getTargetNamespace();
        String string3 = this.getTargetNamespace();
        if (string2 == null) {
            xSDSchema.setTargetNamespace(string3);
        } else if (!string2.equals(string3)) {
            String string4 = "Error processing include " + string + " -- included schemas must have the same targetNamespace " + " as their parent schema, or else have no targetNamespace";
            throw new XSDValidityException(string4);
        }
        xSDSchema.setParent(this);
        this.includedSchemas.put(string, xSDSchema);
    }

    private XSDSchema resolveInclusion(XSDInclusion xSDInclusion) throws XSDException {
        Object var2_2 = null;
        String string = xSDInclusion.getSchemaLocation();
        if (string == null) {
            if (xSDInclusion instanceof XSDImport) {
                string = ((XSDImport)xSDInclusion).getNamespace();
            } else {
                throw new XSDException("Failed to resolve " + xSDInclusion.getXSDTypeName() + " due to lack of schemaLocation.");
            }
        }
        return this.resolveInclusion(string);
    }

    private XSDSchema resolveInclusion(String string) throws XSDException {
        try {
            String string2 = XSDSchema.getFullUrl(this.originUrl, string);
            return this.getSchemaResolver().resolveSchemaLocation(this, string2);
        }
        catch (Exception exception) {
            throw new XSDException("Failed to resolve " + string, exception);
        }
    }

    private static String getFullUrl(String string, String string2) throws MalformedURLException {
        if (string != null) {
            URL uRL = new URL(string);
            URL uRL2 = new URL(uRL, string2);
            return uRL2.toString();
        }
        return string2;
    }

    public void setImportedSchema(XSDSchema xSDSchema) {
        if (ExpName.compareStrings(xSDSchema.getTargetNamespace(), this.targetNamespace)) {
            String string = "targetNamespace " + xSDSchema.getTargetNamespace() + " must not match current value " + this.targetNamespace;
            throw new IllegalArgumentException(string);
        }
        this.importedSchemas.put(xSDSchema.getTargetNamespace(), xSDSchema);
    }

    public void removeInclusion(XSDInclusion xSDInclusion) {
        this.inclusionList.remove(xSDInclusion);
        this.componentList.remove(xSDInclusion);
        if (xSDInclusion.getTypeCode() == 33) {
            XSDImport xSDImport = (XSDImport)xSDInclusion;
            this.importedSchemas.remove(xSDImport.getNamespace());
        }
    }

    public void sortTypes() {
        XSDAnyType xSDAnyType;
        int n;
        Collection collection = this.typeMap.values();
        ArrayList arrayList = new ArrayList(collection.size());
        arrayList.addAll(collection);
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            xSDAnyType = (XSDAnyType)arrayList.get(n);
            this.removeType(xSDAnyType);
        }
        Collections.sort(arrayList, new NamedObjComparator(null));
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            xSDAnyType = (XSDAnyType)arrayList.get(n);
            this.addType(xSDAnyType);
        }
    }

    public void sortElements() {
        XSDElement xSDElement;
        int n;
        Collection collection = this.elementMap.values();
        ArrayList arrayList = new ArrayList(collection.size());
        arrayList.addAll(collection);
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            xSDElement = (XSDElement)arrayList.get(n);
            this.removeElement(xSDElement);
        }
        Collections.sort(arrayList, new NamedObjComparator(null));
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            xSDElement = (XSDElement)arrayList.get(n);
            this.addElement(xSDElement);
        }
    }

    public void addElement(XSDElement xSDElement) {
        xSDElement.setUri(this.targetNamespace);
        this.elementMap.put(xSDElement.getXMLName(), xSDElement);
        this.componentList.add(xSDElement);
        xSDElement.setParent(this);
    }

    public void removeElement(XSDElement xSDElement) {
        this.elementMap.remove(xSDElement.getXMLName());
        this.componentList.remove(xSDElement);
    }

    public void addType(XSDAnyType xSDAnyType) {
        xSDAnyType.setUri(this.targetNamespace);
        this.typeMap.put(xSDAnyType.getXMLName(), xSDAnyType);
        this.componentList.add(xSDAnyType);
        xSDAnyType.setParent(this);
    }

    public void removeType(XSDAnyType xSDAnyType) {
        this.typeMap.remove(xSDAnyType);
        this.componentList.remove(xSDAnyType);
    }

    public void addAttribute(XSDAttribute xSDAttribute) {
        xSDAttribute.setUri(this.targetNamespace);
        this.attributeMap.put(xSDAttribute.getXMLName(), xSDAttribute);
        this.componentList.add(xSDAttribute);
        xSDAttribute.setParent(this);
    }

    public void removeAttribute(XSDAttribute xSDAttribute) {
        this.attributeMap.remove(xSDAttribute);
        this.componentList.remove(xSDAttribute);
    }

    public void addAttributeGroup(XSDAttributeGroup xSDAttributeGroup) {
        xSDAttributeGroup.setUri(this.targetNamespace);
        this.attributeGroupMap.put(xSDAttributeGroup.getXMLName(), xSDAttributeGroup);
        this.componentList.add(xSDAttributeGroup);
        xSDAttributeGroup.setParent((XSDObject)this);
    }

    public void removeAttributeGroup(XSDAttributeGroup xSDAttributeGroup) {
        this.attributeGroupMap.remove(xSDAttributeGroup);
        this.componentList.remove(xSDAttributeGroup);
    }

    public void addModelGroupDefn(XSDModelGroupDefn xSDModelGroupDefn) {
        xSDModelGroupDefn.setUri(this.targetNamespace);
        this.groupMap.put(xSDModelGroupDefn.getXMLName(), xSDModelGroupDefn);
        this.componentList.add(xSDModelGroupDefn);
        xSDModelGroupDefn.setParent((XSDObject)this);
    }

    public void removeModelGroupDefn(XSDModelGroupDefn xSDModelGroupDefn) {
        this.groupMap.remove(xSDModelGroupDefn);
        this.componentList.remove(xSDModelGroupDefn);
    }

    public void addNotation(XSDNotation xSDNotation) {
        xSDNotation.setUri(this.targetNamespace);
        this.notationMap.put(xSDNotation.getXMLName(), xSDNotation);
        this.componentList.add(xSDNotation);
        xSDNotation.setParent((XSDObject)this);
    }

    public void removeNotation(XSDNotation xSDNotation) {
        this.notationMap.remove(xSDNotation);
        this.componentList.remove(xSDNotation);
    }

    public boolean isAttributeFormDefaultQualified() {
        if (this.attributeFormDefault == null) {
            return false;
        }
        return this.attributeFormDefault == FormChoice.QUALIFIED;
    }

    public boolean isElementFormDefaultQualified() {
        if (this.elementFormDefault == null) {
            return false;
        }
        return this.elementFormDefault == FormChoice.QUALIFIED;
    }

    public void setAttributeFormDefaultQualified(boolean bl) {
        this.attributeFormDefault = bl ? FormChoice.QUALIFIED : FormChoice.UNQUALIFIED;
    }

    public void setElementFormDefaultQualified(boolean bl) {
        this.elementFormDefault = bl ? FormChoice.QUALIFIED : FormChoice.UNQUALIFIED;
    }

    public FormChoice getAttributeFormDefault() {
        return this.attributeFormDefault;
    }

    public void setAttributeFormDefault(FormChoice formChoice) {
        this.attributeFormDefault = formChoice;
    }

    public FormChoice getElementFormDefault() {
        return this.elementFormDefault;
    }

    public void setElementFormDefault(FormChoice formChoice) {
        this.elementFormDefault = formChoice;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public BlockSet getBlockDefault() {
        return this.blockDefault;
    }

    public void setBlockDefault(BlockSet blockSet) {
        this.blockDefault = blockSet;
    }

    public static final XSDSchema getSchema(XSDObject xSDObject) {
        XSDObject xSDObject2 = xSDObject;
        while (xSDObject2 != null) {
            XSDObject xSDObject3 = xSDObject2;
            if (!((xSDObject2 = xSDObject2.getParent()) instanceof XSDSchema)) continue;
            return (XSDSchema)xSDObject2;
        }
        return null;
    }

    private static void checkForNullName(XMLName xMLName) {
        if (xMLName == null) {
            String string = "XMLName argument cannot be null";
            throw new NullPointerException(string);
        }
    }

    public Map getIncludedSchemasMap() {
        return Collections.unmodifiableMap(this.includedSchemas);
    }

    private Iterator getIncludedSchemas() {
        return this.includedSchemas.values().iterator();
    }

    public XSDAnyType lookupType(XMLName xMLName) throws XSDException {
        XSDSchema.checkForNullName(xMLName);
        return this.lookupTypeImpl(xMLName, new IdentityHashMap());
    }

    private XSDAnyType lookupTypeImpl(XMLName xMLName, IdentityHashMap identityHashMap) throws XSDException {
        return (XSDAnyType)this.lookupTopLevelObjectImpl(xMLName, identityHashMap, 4);
    }

    private XSDObject lookupTopLevelObjectImpl(XMLName xMLName, IdentityHashMap identityHashMap, int n) throws XSDException {
        if (identityHashMap.containsKey(this)) {
            return null;
        }
        identityHashMap.put(this, null);
        XSDSchema xSDSchema = this.getSchemaForName(xMLName);
        XSDObject xSDObject = this.getTopLevelObject(xMLName, xSDSchema, n);
        if (xSDObject != null) {
            return xSDObject;
        }
        xSDObject = xSDSchema.lookupTopLevelObjectImpl(xMLName, identityHashMap, n);
        if (xSDObject != null) {
            return xSDObject;
        }
        Object object = this.getIncludedSchemas();
        while (object.hasNext()) {
            XSDSchema xSDSchema2 = (XSDSchema)object.next();
            xSDObject = xSDSchema2.lookupTopLevelObjectImpl(xMLName, identityHashMap, n);
            if (xSDObject == null) continue;
            return xSDObject;
        }
        object = (XSDSchema)this.getParent();
        if (object != null) {
            xSDObject = super.lookupTopLevelObjectImpl(xMLName, identityHashMap, n);
        }
        return xSDObject;
    }

    private XSDObject getTopLevelObject(XMLName xMLName, XSDSchema xSDSchema, int n) {
        XSDNamedObject xSDNamedObject;
        switch (n) {
            case 4: 
            case 7: {
                xSDNamedObject = xSDSchema.getType(xMLName);
                break;
            }
            case 2: {
                xSDNamedObject = xSDSchema.getElement(xMLName);
                break;
            }
            case 3: {
                xSDNamedObject = xSDSchema.getAttribute(xMLName);
                break;
            }
            case 17: {
                xSDNamedObject = xSDSchema.getAttributeGroup(xMLName);
                break;
            }
            case 6: {
                xSDNamedObject = xSDSchema.getModelGroupDefn(xMLName);
                break;
            }
            case 31: {
                xSDNamedObject = xSDSchema.getNotation(xMLName);
                break;
            }
            default: {
                throw new AssertionError("unknown type: " + n);
            }
        }
        return xSDNamedObject;
    }

    public XSDElement lookupElement(XMLName xMLName) throws XSDException {
        XSDSchema.checkForNullName(xMLName);
        return this.lookupElementImpl(xMLName, new IdentityHashMap());
    }

    private XSDElement lookupElementImpl(XMLName xMLName, IdentityHashMap identityHashMap) throws XSDException {
        return (XSDElement)this.lookupTopLevelObjectImpl(xMLName, identityHashMap, 2);
    }

    public XSDAttribute lookupAttribute(XMLName xMLName) throws XSDException {
        XSDSchema.checkForNullName(xMLName);
        return this.lookupAttributeImpl(xMLName, new IdentityHashMap());
    }

    private XSDAttribute lookupAttributeImpl(XMLName xMLName, IdentityHashMap identityHashMap) throws XSDException {
        return (XSDAttribute)this.lookupTopLevelObjectImpl(xMLName, identityHashMap, 3);
    }

    public XSDAttributeGroup lookupAttributeGroup(XMLName xMLName) throws XSDException {
        XSDSchema.checkForNullName(xMLName);
        return this.lookupAttributeGroupImpl(xMLName, new IdentityHashMap());
    }

    private XSDAttributeGroup lookupAttributeGroupImpl(XMLName xMLName, IdentityHashMap identityHashMap) throws XSDException {
        return (XSDAttributeGroup)this.lookupTopLevelObjectImpl(xMLName, identityHashMap, 17);
    }

    public XSDModelGroupDefn lookupModelGroupDefn(XMLName xMLName) throws XSDException {
        XSDSchema.checkForNullName(xMLName);
        return this.lookupModelGroupDefnImpl(xMLName, new IdentityHashMap());
    }

    private XSDModelGroupDefn lookupModelGroupDefnImpl(XMLName xMLName, IdentityHashMap identityHashMap) throws XSDException {
        return (XSDModelGroupDefn)this.lookupTopLevelObjectImpl(xMLName, identityHashMap, 6);
    }

    public XSDNotation lookupNotation(XMLName xMLName) throws XSDException {
        XSDSchema.checkForNullName(xMLName);
        return this.lookupNotationImpl(xMLName, new IdentityHashMap());
    }

    private XSDNotation lookupNotationImpl(XMLName xMLName, IdentityHashMap identityHashMap) throws XSDException {
        return (XSDNotation)this.lookupTopLevelObjectImpl(xMLName, identityHashMap, 31);
    }

    public XSDSchema getSchemaForName(XMLName xMLName) throws XSDException {
        String string = xMLName.getNamespaceUri();
        if (ExpName.compareStrings(string, this.targetNamespace)) {
            return this;
        }
        XSDSchema xSDSchema = (XSDSchema)this.importedSchemas.get(string);
        if (xSDSchema != null) {
            return xSDSchema;
        }
        if (!this.allResolved && !this.autoResolve) {
            String string2 = "call resolveInclusions before attempting to use types in other schemas";
            throw new XSDException(string2);
        }
        if (this.autoResolve) {
            XSDImport xSDImport = this.findImport(string);
            if (xSDImport == null) {
                String string3 = "Unable to resolve definition for " + xMLName;
                if (string != null) {
                    string3 = string3 + " perhaps due to the lack of an import statement for namespace " + string;
                }
                throw new XSDException(string3);
            }
            xSDSchema = this.resolveInclusion((XSDInclusion)xSDImport);
            if (xSDSchema != null) {
                this.importedSchemas.put(string, xSDSchema);
                return xSDSchema;
            }
        }
        throw new XSDException("Failed to locate a schema for " + xMLName);
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public DerivationSet getFinalDefault() {
        return this.finalDefault;
    }

    public void setFinalDefault(DerivationSet derivationSet) {
        this.finalDefault = derivationSet;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String string) {
        this.targetNamespace = string;
    }

    public List getComponenets() {
        return Collections.unmodifiableList(this.componentList);
    }

    public XSDElement getElement(XMLName xMLName) {
        return (XSDElement)this.elementMap.get(xMLName);
    }

    public Map getElements() {
        return Collections.unmodifiableMap(this.elementMap);
    }

    public XSDModelGroupDefn getModelGroupDefn(XMLName xMLName) {
        return (XSDModelGroupDefn)this.groupMap.get(xMLName);
    }

    public Map getModelGroupDefns() {
        return Collections.unmodifiableMap(this.groupMap);
    }

    public XSDAnyType getType(XMLName xMLName) {
        XSDAnyType xSDAnyType = (XSDAnyType)this.typeMap.get(xMLName);
        return xSDAnyType;
    }

    public Map getTypes() {
        return Collections.unmodifiableMap(this.typeMap);
    }

    public Map getAllTypes() throws XSDException {
        HashMap hashMap = new HashMap();
        this.getAllTypesImpl(hashMap, new IdentityHashMap());
        return hashMap;
    }

    private void getAllTypesImpl(Map map, IdentityHashMap identityHashMap) throws XSDException {
        XSDSchema xSDSchema;
        if (identityHashMap.containsKey(this)) {
            return;
        }
        identityHashMap.put(this, null);
        map.putAll(this.typeMap);
        Iterator iterator = this.getIncludedSchemas();
        while (iterator.hasNext()) {
            xSDSchema = (XSDSchema)iterator.next();
            xSDSchema.getAllTypesImpl(map, identityHashMap);
        }
        iterator = this.importedSchemas.values().iterator();
        while (iterator.hasNext()) {
            xSDSchema = (XSDSchema)iterator.next();
            if ("http://www.w3.org/2001/XMLSchema".equals(xSDSchema.getTargetNamespace())) continue;
            identityHashMap.put(xSDSchema, null);
        }
    }

    public XSDAttribute getAttribute(XMLName xMLName) {
        return (XSDAttribute)this.attributeMap.get(xMLName);
    }

    public XSDAttributeGroup getAttributeGroup(XMLName xMLName) {
        return (XSDAttributeGroup)this.attributeGroupMap.get(xMLName);
    }

    public Map getAttributes() {
        return Collections.unmodifiableMap(this.attributeMap);
    }

    public Map getAttributeGroups() {
        return Collections.unmodifiableMap(this.attributeGroupMap);
    }

    public XSDNotation getNotation(XMLName xMLName) {
        return (XSDNotation)this.notationMap.get(xMLName);
    }

    public Map getNotations() {
        return Collections.unmodifiableMap(this.notationMap);
    }

    protected void getSubAttributes(List list, boolean bl) {
        super.getSubAttributes(list, bl);
        if (this.attributeFormDefault != null) {
            list.add(new XSDObjectAttribute("attributeFormDefault", this.attributeFormDefault.toString()));
        }
        if (this.blockDefault != null) {
            list.add(new XSDObjectAttribute("blockDefault", this.blockDefault.toXMLString()));
        }
        if (this.elementFormDefault != null) {
            list.add(new XSDObjectAttribute("elementFormDefault", this.elementFormDefault.toString()));
        }
        if (this.finalDefault != null) {
            list.add(new XSDObjectAttribute("finalDefault", this.finalDefault.toXMLString()));
        }
        if (this.targetNamespace != null) {
            list.add(new XSDObjectAttribute("targetNamespace", this.targetNamespace));
        }
        if (this.version != null) {
            list.add(new XSDObjectAttribute("version", this.version));
        }
        if (this.language != null) {
            String string = this.getXMLNameAsXML(SchemaTypes.XML_LANG, true);
            list.add(new XSDObjectAttribute(string, this.language));
        }
    }

    public XSDObjectIterator getChildren() {
        return new ChildItrFromList(this.componentList);
    }

    public Object clone() {
        XSDSchema xSDSchema = (XSDSchema)super.clone();
        xSDSchema.targetNamespace = this.targetNamespace;
        xSDSchema.version = this.version;
        xSDSchema.finalDefault = this.finalDefault;
        xSDSchema.blockDefault = this.blockDefault;
        xSDSchema.attributeFormDefault = this.attributeFormDefault;
        xSDSchema.elementFormDefault = this.elementFormDefault;
        xSDSchema.language = this.language;
        xSDSchema.groupMap = (Map)((HashMap)this.groupMap).clone();
        xSDSchema.groupMap.clear();
        xSDSchema.elementMap = (Map)((HashMap)this.elementMap).clone();
        xSDSchema.elementMap.clear();
        xSDSchema.typeMap = (Map)((HashMap)this.typeMap).clone();
        xSDSchema.typeMap.clear();
        xSDSchema.attributeMap = (Map)((HashMap)this.attributeMap).clone();
        xSDSchema.attributeMap.clear();
        xSDSchema.attributeGroupMap = (Map)((HashMap)this.attributeGroupMap).clone();
        xSDSchema.attributeGroupMap.clear();
        xSDSchema.annotationList = new ArrayList(this.annotationList.size());
        xSDSchema.inclusionList = new ArrayList(this.inclusionList.size());
        xSDSchema.componentList = new ArrayList(this.componentList.size());
        Iterator iterator = this.componentList.iterator();
        while (iterator.hasNext()) {
            Object object;
            XSDObject xSDObject = (XSDObject)iterator.next();
            if (xSDObject instanceof XSDAnnotation) {
                object = (XSDAnnotation)((XSDAnnotation)xSDObject).clone();
                xSDSchema.addAnnotation((XSDAnnotation)object);
                continue;
            }
            if (xSDObject instanceof XSDInclusion) {
                object = (XSDInclusion)((XSDInclusion)xSDObject).clone();
                try {
                    xSDSchema.addInclusion((XSDInclusion)object);
                    continue;
                }
                catch (XSDException xSDException) {
                    throw new AssertionError("internal error", xSDException);
                }
            }
            if (xSDObject instanceof XSDElement) {
                object = (XSDElement)((XSDElement)xSDObject).clone();
                xSDSchema.addElement((XSDElement)object);
                continue;
            }
            if (xSDObject instanceof XSDAnyType) {
                object = (XSDAnyType)((XSDAnyType)xSDObject).clone();
                xSDSchema.addType((XSDAnyType)object);
                continue;
            }
            if (xSDObject instanceof XSDAttribute) {
                object = (XSDAttribute)((XSDAttribute)xSDObject).clone();
                xSDSchema.addAttribute((XSDAttribute)object);
                continue;
            }
            if (xSDObject instanceof XSDAttributeGroup) {
                object = (XSDAttributeGroup)((XSDAttributeGroup)xSDObject).clone();
                xSDSchema.addAttributeGroup((XSDAttributeGroup)object);
                continue;
            }
            if (xSDObject instanceof XSDNotation) {
                object = (XSDNotation)((XSDNotation)xSDObject).clone();
                xSDSchema.addNotation((XSDNotation)object);
                continue;
            }
            if (xSDObject instanceof XSDModelGroupDefn) {
                object = (XSDModelGroupDefn)((XSDModelGroupDefn)xSDObject).clone();
                xSDSchema.addModelGroupDefn((XSDModelGroupDefn)object);
                continue;
            }
            throw new AssertionError("unknown type: " + xSDObject);
        }
        return xSDSchema;
    }
}

