/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.model;

import java.util.List;
import weblogic.utils.AssertionError;
import weblogic.xml.schema.model.ExpName;
import weblogic.xml.schema.model.XSDException;
import weblogic.xml.schema.model.XSDObject;
import weblogic.xml.schema.model.XSDObjectAttribute;
import weblogic.xml.schema.model.XSDValidityException;
import weblogic.xml.stream.XMLName;

public abstract class XSDNamedObject
extends XSDObject
implements Cloneable {
    private ExpName expName;
    private String targetNamespace = null;
    private static final boolean DEBUG = true;

    protected XSDNamedObject(XMLName xMLName) {
        this.setXMLName(xMLName);
    }

    public String getName() {
        return this.getLocalName();
    }

    public XMLName getXMLName() {
        return this.expName;
    }

    public void setXMLName(XMLName xMLName) {
        if (this.expName == null) {
            this.expName = new ExpName(xMLName);
        } else {
            this.setUri(xMLName.getNamespaceUri());
            this.setLocalName(xMLName.getLocalName());
            this.setPrefix(xMLName.getPrefix());
        }
    }

    public void setXMLNameFromNCName(String string) {
        if (this.expName == null) {
            this.expName = new ExpName(null, null, null);
        }
        if (string.indexOf(58) > -1) {
            throw new AssertionError("name attribute must be NCName, not " + string);
        }
        this.setLocalName(string);
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String string) {
        this.targetNamespace = string;
    }

    public String getUri() {
        return this.expName.getUri();
    }

    public void setUri(String string) {
        this.expName.setUri(string);
    }

    public String getLocalName() {
        return this.expName.getLocalName();
    }

    public void setLocalName(String string) {
        this.expName.setLocalName(string);
    }

    public String getPrefix() {
        return this.expName.getPrefix();
    }

    public void setPrefix(String string) {
        this.expName.setPrefix(string);
    }

    protected XSDException createInvalidRefException(XMLName xMLName) {
        String string = this.getXMLElementName().getLocalName();
        String string2 = "unable to resolve " + string + " ref: \"" + xMLName.getQualifiedName() + "\"";
        String string3 = this.getXMLName().getQualifiedName();
        if (string3 != null) {
            string2 = string2 + " in " + string + " \"" + string3 + "\"";
        }
        return new XSDValidityException(string2);
    }

    protected void getSubAttributes(List list, boolean bl) {
        String string;
        super.getSubAttributes(list, bl);
        if (this.expName != null && (string = this.expName.getLocalName()) != null) {
            list.add(new XSDObjectAttribute("name", string));
        }
    }

    public Object clone() {
        XSDNamedObject xSDNamedObject = (XSDNamedObject)super.clone();
        if (this.expName != null) {
            xSDNamedObject.expName = (ExpName)this.expName.clone();
        } else {
            this.expName = null;
        }
        xSDNamedObject.targetNamespace = this.targetNamespace;
        return xSDNamedObject;
    }
}

