/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.model;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import weblogic.xml.schema.model.BlockSet;
import weblogic.xml.schema.model.DerivationSet;
import weblogic.xml.schema.model.ExpName;
import weblogic.xml.schema.model.FormChoice;
import weblogic.xml.schema.model.ParticleImpl;
import weblogic.xml.schema.model.SchemaTypes;
import weblogic.xml.schema.model.ValueConstraint;
import weblogic.xml.schema.model.XSDAnyType;
import weblogic.xml.schema.model.XSDElement;
import weblogic.xml.schema.model.XSDException;
import weblogic.xml.schema.model.XSDIdentityConstraint;
import weblogic.xml.schema.model.XSDNamedObject;
import weblogic.xml.schema.model.XSDObject;
import weblogic.xml.schema.model.XSDObjectAttribute;
import weblogic.xml.schema.model.XSDObjectIterator;
import weblogic.xml.schema.model.XSDParticle;
import weblogic.xml.schema.model.XSDSchema;
import weblogic.xml.schema.model.XSDValidityException;
import weblogic.xml.stream.XMLName;

public class XSDElement
extends XSDNamedObject
implements XSDParticle,
Cloneable {
    private ParticleImpl particleInfo = new ParticleImpl(1L, 1L);
    private XMLName ref;
    private XMLName type;
    private XSDAnyType anonymousType;
    private List identityConstraints;
    private BlockSet block;
    private Boolean abstract_att;
    private Boolean nillable;
    private DerivationSet final_att;
    private FormChoice form;
    private ValueConstraint valueConstraint;
    private String substitutionGroup;
    private boolean qualified = false;

    public XSDElement(XMLName xMLName) {
        super(xMLName);
    }

    public XSDElement(String string, String string2, String string3) {
        super(new ExpName(string, string2, string3));
    }

    public XSDElement() {
        this(null, null, null);
    }

    public int getTypeCode() {
        return 2;
    }

    protected XMLName getXSDTypeName() {
        return SchemaTypes.ELEMENT_ENAME;
    }

    public XMLName getType() {
        return this.type;
    }

    public XSDAnyType getTypeObject() throws XSDException {
        if (this.anonymousType != null) {
            return this.anonymousType;
        }
        if (this.type != null) {
            XSDAnyType xSDAnyType = this.lookupType(this.type);
            if (xSDAnyType == null) {
                throw new XSDValidityException("unable to resolve type name " + this.type);
            }
            return xSDAnyType;
        }
        if (this.ref != null) {
            XSDElement xSDElement = this.getRefObject();
            if (xSDElement != null) {
                return xSDElement.getTypeObject();
            }
            throw this.createInvalidRefException(this.ref);
        }
        return this.lookupType(SchemaTypes.XSD_ANY_TYPE_ENAME);
    }

    public void setType(XMLName xMLName) {
        this.type = xMLName;
    }

    public XMLName getRef() {
        return this.ref;
    }

    public XSDElement getRefObject() throws XSDException {
        if (this.ref == null) {
            throw new XSDException("ref attribute is unset");
        }
        XSDElement xSDElement = this.lookupElement(this.ref);
        if (xSDElement == null) {
            throw this.createInvalidRefException(this.ref);
        }
        return xSDElement;
    }

    public void setRef(XMLName xMLName) {
        this.ref = xMLName;
    }

    public ValueConstraint getValueConstraint() {
        return this.valueConstraint;
    }

    public void setValueConstraint(ValueConstraint valueConstraint) {
        this.valueConstraint = valueConstraint;
    }

    public boolean isFixed() {
        return this.valueConstraint.getType() == ValueConstraint.Type.FIXED;
    }

    public boolean hasDefault() {
        return this.valueConstraint.getType() == ValueConstraint.Type.DEFAULT;
    }

    public String getValueConstraintValue() {
        return this.valueConstraint.getValue();
    }

    public String getSubstitutionGroup() {
        return this.substitutionGroup;
    }

    public void setSubstitutionGroup(String string) {
        this.substitutionGroup = string;
    }

    public DerivationSet getFinal() {
        return this.final_att;
    }

    public void setFinal(DerivationSet derivationSet) {
        this.final_att = derivationSet;
    }

    public BlockSet getBlock() {
        return this.block;
    }

    public void setBlock(BlockSet blockSet) {
        this.block = blockSet;
    }

    public XSDAnyType getAnonymousType() {
        return this.anonymousType;
    }

    public void setAnonymousType(XSDAnyType xSDAnyType) {
        this.anonymousType = xSDAnyType;
        this.anonymousType.setParent(this);
    }

    public void addIdentityConstraint(XSDIdentityConstraint xSDIdentityConstraint) {
        if (this.identityConstraints == null) {
            this.identityConstraints = new ArrayList();
        }
        this.identityConstraints.add(xSDIdentityConstraint);
        xSDIdentityConstraint.setParent((XSDObject)this);
    }

    public List getIdentityConstraints() {
        return Collections.unmodifiableList(this.identityConstraints);
    }

    public void removeIdentityConstraint(XSDIdentityConstraint xSDIdentityConstraint) {
        if (this.identityConstraints == null) {
            return;
        }
        this.identityConstraints.remove(xSDIdentityConstraint);
    }

    public BigInteger getMaxOccurs() {
        return this.particleInfo.getMaxOccurs();
    }

    public void setMaxOccurs(BigInteger bigInteger) {
        this.particleInfo.setMaxOccurs(bigInteger);
    }

    public BigInteger getMinOccurs() {
        return this.particleInfo.getMinOccurs();
    }

    public void setMinOccurs(BigInteger bigInteger) {
        this.particleInfo.setMinOccurs(bigInteger);
    }

    public boolean isMinSet() {
        return this.particleInfo.isMinSet();
    }

    public boolean isMaxSet() {
        return this.particleInfo.isMaxSet();
    }

    public boolean isMaxUnbounded() {
        return this.particleInfo.isMaxUnbounded();
    }

    public void setMaxUnbounded(boolean bl) {
        this.particleInfo.setMaxUnbounded(bl);
    }

    public FormChoice getForm() {
        return this.form;
    }

    public void setForm(FormChoice formChoice) {
        this.form = formChoice;
    }

    public Boolean isNillable() {
        return this.nillable;
    }

    public void setNillable(boolean bl) {
        this.nillable = XSDElement.makeBoolean(bl);
    }

    public boolean isNillableDefaulted() {
        if (this.nillable == null) {
            return false;
        }
        return this.nillable;
    }

    public Boolean isAbstract() {
        return this.abstract_att;
    }

    public void setAbstract(boolean bl) {
        this.abstract_att = XSDElement.makeBoolean(bl);
    }

    public void setQualifed(boolean bl) {
        this.qualified = bl;
    }

    public boolean isFormQualifiedResolved() {
        if (this.qualified) {
            return true;
        }
        if (this.form != null) {
            return this.form == FormChoice.QUALIFIED;
        }
        XSDSchema xSDSchema = XSDSchema.getSchema(this);
        if (xSDSchema != null) {
            return xSDSchema.isElementFormDefaultQualified();
        }
        return false;
    }

    protected void getSubAttributes(List list, boolean bl) {
        String string;
        super.getSubAttributes(list, bl);
        if (this.ref != null) {
            list.add(new XSDObjectAttribute("ref", this.ref.getQualifiedName()));
        }
        if (this.type != null) {
            string = this.getXMLNameAsXML(this.type, bl);
            list.add(new XSDObjectAttribute("type", string));
        }
        if (this.form != null) {
            list.add(new XSDObjectAttribute("form", this.form.toString()));
        }
        if (this.nillable != null) {
            string = XSDElement.booleanAttribute(this.nillable);
            list.add(new XSDObjectAttribute("nillable", string));
        }
        if (this.abstract_att != null) {
            string = XSDElement.booleanAttribute(this.abstract_att);
            list.add(new XSDObjectAttribute("abstract", string));
        }
        if (this.final_att != null) {
            list.add(new XSDObjectAttribute("final", this.final_att.toXMLString()));
        }
        if (this.block != null) {
            list.add(new XSDObjectAttribute("block", this.block.toXMLString()));
        }
        if (this.substitutionGroup != null) {
            list.add(new XSDObjectAttribute("substitutionGroup", this.substitutionGroup));
        }
        if (this.valueConstraint != null) {
            string = this.valueConstraint.getType().toXMLString();
            String string2 = this.valueConstraint.getValue();
            list.add(new XSDObjectAttribute(string, string2));
        }
        XSDElement.addParticleAttributues(list, this);
    }

    public XSDObjectIterator getChildren() {
        return new ChildItr(this);
    }

    public Object clone() {
        XSDElement xSDElement = (XSDElement)super.clone();
        xSDElement.particleInfo = (ParticleImpl)this.particleInfo.clone();
        if (this.ref != null) {
            xSDElement.ref = new ExpName(this.ref);
        }
        if (this.type != null) {
            xSDElement.type = new ExpName(this.type);
        }
        if (this.anonymousType != null) {
            xSDElement.anonymousType = (XSDAnyType)this.anonymousType.clone();
        }
        xSDElement.valueConstraint = this.valueConstraint;
        xSDElement.form = this.form;
        xSDElement.nillable = this.nillable != null ? new Boolean(this.nillable) : null;
        return xSDElement;
    }

    static /* synthetic */ XSDAnyType access$000(XSDElement xSDElement) {
        return xSDElement.anonymousType;
    }

    static /* synthetic */ List access$100(XSDElement xSDElement) {
        return xSDElement.identityConstraints;
    }
}

