/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.xml.schema.model.ContentType;
import weblogic.xml.schema.model.DerivationSet;
import weblogic.xml.schema.model.ExpName;
import weblogic.xml.schema.model.SchemaTypes;
import weblogic.xml.schema.model.XSDAll;
import weblogic.xml.schema.model.XSDAnyAttribute;
import weblogic.xml.schema.model.XSDAnyType;
import weblogic.xml.schema.model.XSDAttribute;
import weblogic.xml.schema.model.XSDAttributeBase;
import weblogic.xml.schema.model.XSDAttributeGroup;
import weblogic.xml.schema.model.XSDChoice;
import weblogic.xml.schema.model.XSDComplexContent;
import weblogic.xml.schema.model.XSDComplexContentDerivation;
import weblogic.xml.schema.model.XSDComplexType;
import weblogic.xml.schema.model.XSDException;
import weblogic.xml.schema.model.XSDFacet;
import weblogic.xml.schema.model.XSDModelGroup;
import weblogic.xml.schema.model.XSDObject;
import weblogic.xml.schema.model.XSDObjectAttribute;
import weblogic.xml.schema.model.XSDObjectIterator;
import weblogic.xml.schema.model.XSDParticle;
import weblogic.xml.schema.model.XSDSequence;
import weblogic.xml.schema.model.XSDSimpleContent;
import weblogic.xml.schema.model.XSDSimpleContentRestriction;
import weblogic.xml.schema.model.XSDValidityException;
import weblogic.xml.stream.XMLName;

public class XSDComplexType
extends XSDAnyType
implements Cloneable {
    private XSDSimpleContent simpleContent;
    private XSDComplexContent complexContent;
    private XSDParticle contentModel;
    private List attributeList = new ArrayList();
    private XSDAnyAttribute anyAttribute = null;
    private DerivationSet final_att;
    private DerivationSet block;
    private Boolean mixed;
    private Boolean abstract_att;
    private static final boolean DEBUG = true;

    public XSDComplexType() {
        super(new ExpName(null, null));
    }

    public XSDComplexType(XMLName xMLName) {
        super(xMLName);
    }

    public XSDComplexType(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public int getTypeCode() {
        return 4;
    }

    protected XMLName getXSDTypeName() {
        return SchemaTypes.COMPLEX_TYPE_ENAME;
    }

    public XMLName getBaseType() throws XSDValidityException {
        if (this.simpleContent != null) {
            return this.simpleContent.getBaseType();
        }
        if (this.complexContent != null) {
            return this.complexContent.getBaseType();
        }
        return SchemaTypes.XSD_ANY_TYPE_ENAME;
    }

    public boolean isBuiltin() {
        return false;
    }

    public ContentType getContentType() throws XSDValidityException {
        if (this.isMixedDefaulted()) {
            return ContentType.MIXED;
        }
        if (this.simpleContent != null) {
            return ContentType.SIMPLE;
        }
        if (this.contentModel != null) {
            return ContentType.ELEMENT_ONLY;
        }
        if (this.complexContent != null) {
            if (this.complexContent.isRestriction()) {
                XSDChoice xSDChoice;
                XSDParticle xSDParticle = this.complexContent.getDerivation().getContentModel();
                if (xSDParticle == null) {
                    return ContentType.EMPTY;
                }
                if (xSDParticle instanceof XSDChoice ? (xSDChoice = (XSDChoice)xSDParticle).getContentModel().isEmpty() && xSDChoice.isMinOccursZero() : (xSDParticle instanceof XSDAll || xSDParticle instanceof XSDSequence) && ((XSDModelGroup)xSDParticle).getContentModel().isEmpty()) {
                    return ContentType.EMPTY;
                }
            }
            if (this.complexContent.isMixedDefaulted()) {
                return ContentType.MIXED;
            }
            return ContentType.ELEMENT_ONLY;
        }
        return ContentType.EMPTY;
    }

    public ArrayList getResolvedFacets() throws XSDException {
        ArrayList arrayList;
        Cloneable cloneable;
        LinkedList<ArrayList> linkedList = new LinkedList<ArrayList>();
        ArrayList arrayList2 = this.getFacets();
        XSDAnyType xSDAnyType = this;
        Debug.assertion(xSDAnyType != null);
        while (xSDAnyType != null && xSDAnyType instanceof XSDAnyType && !((XSDAnyType)xSDAnyType).isBuiltin()) {
            cloneable = xSDAnyType;
            arrayList = ((XSDAnyType)cloneable).getFacets();
            linkedList.add(arrayList);
            Debug.assertion(!linkedList.isEmpty());
            xSDAnyType = xSDAnyType.getBaseTypeObject();
        }
        Debug.assertion(!linkedList.isEmpty());
        cloneable = (ArrayList)linkedList.removeFirst();
        while (!linkedList.isEmpty()) {
            arrayList = (ArrayList)linkedList.removeFirst();
            cloneable = this.mergeFacets((ArrayList)cloneable, arrayList);
        }
        return cloneable;
    }

    public ArrayList getFacets() throws XSDValidityException {
        ArrayList arrayList = XSDComplexType.createEmptyFacets();
        if (this.simpleContent == null) {
            return arrayList;
        }
        if (this.simpleContent.isExtension()) {
            return arrayList;
        }
        XSDSimpleContentRestriction xSDSimpleContentRestriction = (XSDSimpleContentRestriction)this.simpleContent.getDerivation();
        List list = xSDSimpleContentRestriction.getFacets();
        if (list == null || list.isEmpty()) {
            return arrayList;
        }
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            XSDFacet xSDFacet = (XSDFacet)iterator.next();
            if (xSDFacet.isEnumeration()) {
                hashSet.add(xSDFacet.getValue());
                continue;
            }
            if (xSDFacet.isPattern()) {
                hashSet2.add(xSDFacet.getValue());
                continue;
            }
            int n = xSDFacet.getFacetType();
            if (arrayList.get(n) != null) {
                String string = "Duplicate facets of type " + xSDFacet.getFacetTypeString() + " not allowed";
                throw new XSDValidityException(string);
            }
            arrayList.set(n, xSDFacet);
        }
        if (!hashSet.isEmpty()) {
            arrayList.set(5, hashSet);
        }
        if (!hashSet2.isEmpty()) {
            arrayList.set(4, hashSet2);
        }
        return arrayList;
    }

    public boolean isExtension() throws XSDValidityException {
        return !this.isRestriction();
    }

    public boolean isRestriction() throws XSDValidityException {
        if (this.contentModel != null) {
            return true;
        }
        if (this.simpleContent != null) {
            return this.simpleContent.isRestriction();
        }
        if (this.complexContent != null) {
            return this.complexContent.isRestriction();
        }
        Debug.assertion(this.getContentType() == ContentType.EMPTY);
        return true;
    }

    public Boolean isMixed() {
        return this.mixed;
    }

    public boolean isMixedDefaulted() {
        if (this.mixed == null) {
            return false;
        }
        return this.mixed;
    }

    public void setMixed(boolean bl) {
        this.mixed = XSDComplexType.makeBoolean(bl);
    }

    public Boolean isAbstract() {
        return this.abstract_att;
    }

    public boolean isAbstractDefaulted() {
        if (this.abstract_att == null) {
            return false;
        }
        return this.abstract_att;
    }

    public void setAbstract(boolean bl) {
        this.abstract_att = XSDComplexType.makeBoolean(bl);
    }

    public DerivationSet getBlock() {
        return this.block;
    }

    public void setBlock(DerivationSet derivationSet) {
        this.block = derivationSet;
    }

    public DerivationSet getFinal() {
        return this.final_att;
    }

    public void setFinal(DerivationSet derivationSet) {
        this.final_att = derivationSet;
    }

    public XSDSimpleContent getSimpleContent() {
        return this.simpleContent;
    }

    public void setSimpleContent(XSDSimpleContent xSDSimpleContent) {
        this.simpleContent = xSDSimpleContent;
    }

    public XSDComplexContent getComplexContent() {
        return this.complexContent;
    }

    public void setComplexContent(XSDComplexContent xSDComplexContent) {
        this.complexContent = xSDComplexContent;
    }

    public XSDParticle getContentModel() {
        return this.contentModel;
    }

    public void setContentModel(XSDParticle xSDParticle) {
        this.contentModel = xSDParticle;
        ((XSDObject)((Object)xSDParticle)).setParent(this);
    }

    public XSDParticle getResolvedContentModel() throws XSDValidityException {
        if (this.contentModel != null && this.complexContent != null) {
            String string = "only one of complexContent and  contentModel may be non-null";
            throw new XSDValidityException(string);
        }
        if (this.contentModel != null) {
            return this.contentModel;
        }
        if (this.complexContent == null) {
            return null;
        }
        XSDComplexContentDerivation xSDComplexContentDerivation = this.complexContent.getDerivation();
        if (xSDComplexContentDerivation == null) {
            return null;
        }
        return xSDComplexContentDerivation.getContentModel();
    }

    public void addAttribute(XSDAttributeBase xSDAttributeBase) {
        this.attributeList.add(xSDAttributeBase);
        xSDAttributeBase.setParent(this);
    }

    public List getAttributes() {
        return Collections.unmodifiableList(this.attributeList);
    }

    public XSDAttribute[] getAttributesExpanded() throws XSDException {
        Object object;
        XSDAttribute[] xSDAttributeArray;
        if (this.complexContent != null) {
            return this.complexContent.getDerivation().getAttributesExpanded();
        }
        if (this.simpleContent != null) {
            return this.simpleContent.getDerivation().getAttributesExpanded();
        }
        int n = (int)(1.25 * (double)this.attributeList.size());
        ArrayList<XSDAttributeGroup> arrayList = new ArrayList<XSDAttributeGroup>(n);
        Iterator iterator = this.attributeList.iterator();
        while (iterator.hasNext()) {
            xSDAttributeArray = (XSDAttribute[])iterator.next();
            if (xSDAttributeArray instanceof XSDAttributeGroup) {
                object = (XSDAttributeGroup)xSDAttributeArray;
                List list = object.getResolvedAttributes();
                arrayList.addAll(list);
                continue;
            }
            if (xSDAttributeArray instanceof XSDAttribute) {
                object = (XSDAttribute)xSDAttributeArray;
                arrayList.add((XSDAttributeGroup)object);
                continue;
            }
            throw new AssertionError("unknown type");
        }
        xSDAttributeArray = new XSDAttribute[arrayList.size()];
        object = arrayList.toArray(xSDAttributeArray);
        return (XSDAttribute[])object;
    }

    public XSDAttributeBase[] getAttributesAsArray() {
        int n = this.attributeList.size();
        XSDAttributeBase[] xSDAttributeBaseArray = new XSDAttributeBase[n];
        XSDAttributeBase[] xSDAttributeBaseArray2 = this.attributeList.toArray(xSDAttributeBaseArray);
        return xSDAttributeBaseArray2;
    }

    public void removeAttribute(XSDAttributeBase xSDAttributeBase) {
        this.attributeList.remove(xSDAttributeBase);
    }

    public XSDAnyAttribute getAnyAttribute() {
        return this.anyAttribute;
    }

    public void setAnyAttribute(XSDAnyAttribute xSDAnyAttribute) {
        this.anyAttribute = xSDAnyAttribute;
    }

    protected void getSubAttributes(List list, boolean bl) {
        String string;
        super.getSubAttributes(list, bl);
        if (this.mixed != null) {
            string = XSDComplexType.booleanAttribute(this.mixed);
            list.add(new XSDObjectAttribute("mixed", string));
        }
        if (this.block != null) {
            list.add(new XSDObjectAttribute("block", this.block.toXMLString()));
        }
        if (this.final_att != null) {
            list.add(new XSDObjectAttribute("final", this.final_att.toXMLString()));
        }
        if (this.abstract_att != null) {
            string = XSDComplexType.booleanAttribute(this.abstract_att);
            list.add(new XSDObjectAttribute("abstract", string));
        }
    }

    public XSDObjectIterator getChildren() {
        return new ChildItr(this);
    }

    public Object clone() {
        XSDComplexType xSDComplexType = (XSDComplexType)super.clone();
        xSDComplexType.contentModel = this.contentModel != null ? (XSDParticle)this.contentModel.clone() : null;
        xSDComplexType.simpleContent = this.simpleContent != null ? (XSDSimpleContent)this.simpleContent.clone() : null;
        xSDComplexType.complexContent = this.complexContent != null ? (XSDComplexContent)this.complexContent.clone() : null;
        if (this.attributeList == null) {
            xSDComplexType.attributeList = null;
        } else {
            xSDComplexType.attributeList = new ArrayList(this.attributeList.size());
            Iterator iterator = this.attributeList.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof XSDAttributeBase)) continue;
                XSDAttributeBase xSDAttributeBase = (XSDAttributeBase)e;
                XSDAttributeBase xSDAttributeBase2 = (XSDAttributeBase)xSDAttributeBase.clone();
                xSDComplexType.addAttribute(xSDAttributeBase2);
            }
        }
        return xSDComplexType;
    }

    static /* synthetic */ XSDParticle access$000(XSDComplexType xSDComplexType) {
        return xSDComplexType.contentModel;
    }

    static /* synthetic */ XSDSimpleContent access$100(XSDComplexType xSDComplexType) {
        return xSDComplexType.simpleContent;
    }

    static /* synthetic */ XSDComplexContent access$200(XSDComplexType xSDComplexType) {
        return xSDComplexType.complexContent;
    }

    static /* synthetic */ List access$300(XSDComplexType xSDComplexType) {
        return xSDComplexType.attributeList;
    }

    static /* synthetic */ XSDAnyAttribute access$400(XSDComplexType xSDComplexType) {
        return xSDComplexType.anyAttribute;
    }
}

