/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import weblogic.utils.AssertionError;
import weblogic.xml.schema.model.SchemaTypes;
import weblogic.xml.schema.model.XSDAnyAttribute;
import weblogic.xml.schema.model.XSDAttribute;
import weblogic.xml.schema.model.XSDAttributeBase;
import weblogic.xml.schema.model.XSDAttributeGroup;
import weblogic.xml.schema.model.XSDComplexContentDerivation;
import weblogic.xml.schema.model.XSDObject;
import weblogic.xml.schema.model.XSDObjectAttribute;
import weblogic.xml.schema.model.XSDObjectIterator;
import weblogic.xml.schema.model.XSDParticle;
import weblogic.xml.stream.XMLName;

public abstract class XSDComplexContentDerivation
extends XSDObject
implements Cloneable {
    private static final boolean DEBUG = false;
    private XMLName base = SchemaTypes.XSD_ANY_TYPE_ENAME;
    private XSDParticle contentModel;
    private List attributes = new ArrayList();
    private List attributeGroups = new ArrayList();
    private XSDAnyAttribute anyAttribute;

    public XMLName getBase() {
        return this.base;
    }

    public void setBase(XMLName xMLName) {
        this.base = xMLName;
    }

    public XSDParticle getContentModel() {
        return this.contentModel;
    }

    public void setContentModel(XSDParticle xSDParticle) {
        this.contentModel = xSDParticle;
        ((XSDObject)((Object)xSDParticle)).setParent(this);
    }

    public void addAttribute(XSDAttribute xSDAttribute) {
        this.attributes.add(xSDAttribute);
    }

    public void removeAttribute(XSDAttribute xSDAttribute) {
        this.attributes.remove(xSDAttribute);
    }

    public void addAttributeGroup(XSDAttributeGroup xSDAttributeGroup) {
        if (this.attributeGroups == null) {
            this.attributeGroups = new ArrayList();
        }
        this.attributeGroups.add(xSDAttributeGroup);
    }

    public void removeAttributeGroup(XSDAttributeGroup xSDAttributeGroup) {
        this.attributeGroups.remove(xSDAttributeGroup);
    }

    public List getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    public XSDAttribute[] getAttributesExpanded() {
        Object object;
        XSDAttribute[] xSDAttributeArray;
        int n = this.attributes.size() * 4 / 3 + 1;
        ArrayList<XSDAttributeGroup> arrayList = new ArrayList<XSDAttributeGroup>(n);
        Iterator iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            xSDAttributeArray = (XSDAttribute[])iterator.next();
            if (xSDAttributeArray instanceof XSDAttributeGroup) {
                object = (XSDAttributeGroup)xSDAttributeArray;
                List list = object.getAttributes();
                arrayList.addAll(list);
                continue;
            }
            if (xSDAttributeArray instanceof XSDAttribute) {
                object = (XSDAttribute)xSDAttributeArray;
                arrayList.add((XSDAttributeGroup)object);
                continue;
            }
            throw new AssertionError("unknown type");
        }
        xSDAttributeArray = new XSDAttribute[arrayList.size()];
        object = arrayList.toArray(xSDAttributeArray);
        return (XSDAttribute[])object;
    }

    public XSDAttributeBase[] getAttributesAsArray() {
        int n = this.attributes.size();
        XSDAttributeBase[] xSDAttributeBaseArray = new XSDAttributeBase[n];
        XSDAttributeBase[] xSDAttributeBaseArray2 = this.attributes.toArray(xSDAttributeBaseArray);
        return xSDAttributeBaseArray2;
    }

    public XSDAnyAttribute getAnyAttribute() {
        return this.anyAttribute;
    }

    public void setAnyAttribute(XSDAnyAttribute xSDAnyAttribute) {
        this.anyAttribute = xSDAnyAttribute;
    }

    public XSDObjectIterator getChildren() {
        return new ChildItr(this);
    }

    protected void getSubAttributes(List list, boolean bl) {
        super.getSubAttributes(list, bl);
        if (this.base != null) {
            String string = this.getXMLNameAsXML(this.base, bl);
            XSDObjectAttribute xSDObjectAttribute = new XSDObjectAttribute("base", string);
            list.add(xSDObjectAttribute);
        }
    }

    public Object clone() {
        throw new AssertionError("UNIMP");
    }

    static /* synthetic */ XSDParticle access$000(XSDComplexContentDerivation xSDComplexContentDerivation) {
        return xSDComplexContentDerivation.contentModel;
    }

    static /* synthetic */ List access$100(XSDComplexContentDerivation xSDComplexContentDerivation) {
        return xSDComplexContentDerivation.attributes;
    }

    static /* synthetic */ List access$200(XSDComplexContentDerivation xSDComplexContentDerivation) {
        return xSDComplexContentDerivation.attributeGroups;
    }

    static /* synthetic */ XSDAnyAttribute access$300(XSDComplexContentDerivation xSDComplexContentDerivation) {
        return xSDComplexContentDerivation.anyAttribute;
    }
}

