/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.model;

import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.xml.schema.model.SchemaTypes;
import weblogic.xml.schema.model.SimpleTypeVariety;
import weblogic.xml.schema.model.XSDAnyType;
import weblogic.xml.schema.model.XSDException;
import weblogic.xml.schema.model.XSDFacet;
import weblogic.xml.schema.model.XSDList;
import weblogic.xml.stream.XMLName;

public abstract class XSDBaseSimpleType
extends XSDAnyType
implements Cloneable {
    private static final boolean DEBUG = true;
    private static final boolean[] legalListFacets = XSDBaseSimpleType.buildLegalListFacets();

    public XSDBaseSimpleType() {
    }

    public XSDBaseSimpleType(XMLName xMLName) {
        super(xMLName);
    }

    public XSDBaseSimpleType(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    protected XMLName getXSDTypeName() {
        return SchemaTypes.SIMPLE_TYPE_ENAME;
    }

    public abstract XSDBaseSimpleType getBasePrimitiveTypeObject() throws XSDException;

    public boolean isLegalFacet(int n) throws XSDException {
        Debug.assertion(n <= XSDFacet.getMaxFacetType());
        SimpleTypeVariety simpleTypeVariety = this.getVariety();
        if (simpleTypeVariety == SimpleTypeVariety.ATOMIC) {
            return this.isLegalFacetAtomic(n);
        }
        if (simpleTypeVariety == SimpleTypeVariety.LIST) {
            return legalListFacets[n];
        }
        if (simpleTypeVariety == SimpleTypeVariety.UNION) {
            return n == 4 || n == 5;
        }
        throw new AssertionError("impossible variety type: " + simpleTypeVariety);
    }

    public abstract boolean isPrimitive();

    protected abstract boolean isLegalFacetAtomic(int var1) throws XSDException;

    public abstract SimpleTypeVariety getVariety() throws XSDException;

    public String getVarietyString() throws XSDException {
        return this.getVariety().toString();
    }

    public int getTypeCode() {
        return 7;
    }

    private static boolean[] buildLegalListFacets() {
        boolean[] blArray = new boolean[1 + XSDFacet.getMaxFacetType()];
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        return blArray;
    }

    public Object clone() {
        XSDBaseSimpleType xSDBaseSimpleType = (XSDBaseSimpleType)super.clone();
        return xSDBaseSimpleType;
    }

    public abstract XSDList getListResolved() throws XSDException;
}

