/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.model;

import java.util.List;
import weblogic.xml.schema.model.AttributeUses;
import weblogic.xml.schema.model.ExpName;
import weblogic.xml.schema.model.FormChoice;
import weblogic.xml.schema.model.SchemaTypes;
import weblogic.xml.schema.model.ValueConstraint;
import weblogic.xml.schema.model.XSDAnyType;
import weblogic.xml.schema.model.XSDAttribute;
import weblogic.xml.schema.model.XSDAttributeBase;
import weblogic.xml.schema.model.XSDBaseSimpleType;
import weblogic.xml.schema.model.XSDException;
import weblogic.xml.schema.model.XSDObjectAttribute;
import weblogic.xml.schema.model.XSDObjectIterator;
import weblogic.xml.schema.model.XSDValidityException;
import weblogic.xml.stream.XMLName;

public class XSDAttribute
extends XSDAttributeBase
implements Cloneable {
    private XMLName type;
    private XSDBaseSimpleType anonymousType;
    private ValueConstraint valueConstraint;
    private AttributeUses use;
    private FormChoice form;

    public XSDAttribute(XMLName xMLName) {
        super(xMLName);
    }

    public XSDAttribute(String string, String string2, String string3) {
        super(new ExpName(string, string2, string3));
    }

    public XSDAttribute() {
        this(null, null, null);
    }

    public int getTypeCode() {
        return 3;
    }

    protected XMLName getXSDTypeName() {
        return SchemaTypes.ATTRIBUTE_ENAME;
    }

    public XMLName getType() {
        return this.type;
    }

    public XSDAnyType getTypeObject() throws XSDException {
        if (this.anonymousType != null) {
            return this.anonymousType;
        }
        if (this.type != null) {
            XSDAnyType xSDAnyType = this.lookupType(this.type);
            if (xSDAnyType == null) {
                throw new XSDValidityException("unable to resolve type name " + this.type);
            }
            return xSDAnyType;
        }
        return this.lookupType(SchemaTypes.XSD_ANY_SIMPLE_TYPE_ENAME);
    }

    public void setType(XMLName xMLName) {
        this.type = xMLName;
    }

    public XSDAttribute getRefObject() throws XSDException {
        XMLName xMLName = this.getRef();
        if (xMLName == null) {
            throw new XSDException("ref attribute is unset");
        }
        XSDAttribute xSDAttribute = this.lookupAttribute(xMLName);
        if (xSDAttribute == null) {
            throw this.createInvalidRefException(xMLName);
        }
        return xSDAttribute;
    }

    public AttributeUses getUse() {
        return this.use;
    }

    public void setUse(AttributeUses attributeUses) {
        this.use = attributeUses;
    }

    public FormChoice getForm() {
        return this.form;
    }

    public void setForm(FormChoice formChoice) {
        this.form = formChoice;
    }

    public ValueConstraint getValueConstraint() {
        return this.valueConstraint;
    }

    public void setValueConstraint(ValueConstraint valueConstraint) {
        this.valueConstraint = valueConstraint;
    }

    public boolean isFixed() {
        if (this.valueConstraint == null) {
            return false;
        }
        return this.valueConstraint.getType() == ValueConstraint.Type.FIXED;
    }

    public boolean hasDefault() {
        if (this.valueConstraint == null) {
            return false;
        }
        return this.valueConstraint.getType() == ValueConstraint.Type.DEFAULT;
    }

    public String getValueConstraintValue() {
        if (this.valueConstraint != null) {
            return this.valueConstraint.getValue();
        }
        return null;
    }

    public XSDBaseSimpleType getAnonymousType() {
        return this.anonymousType;
    }

    public void setAnonymousType(XSDBaseSimpleType xSDBaseSimpleType) {
        this.anonymousType = xSDBaseSimpleType;
        this.anonymousType.setParent(this);
    }

    protected void getSubAttributes(List list, boolean bl) {
        String string;
        super.getSubAttributes(list, bl);
        if (this.type != null) {
            string = this.getXMLNameAsXML(this.type, bl);
            list.add(new XSDObjectAttribute("type", string));
        }
        if (this.valueConstraint != null) {
            string = this.valueConstraint.getType().toXMLString();
            String string2 = this.valueConstraint.getValue();
            list.add(new XSDObjectAttribute(string, string2));
        }
        if (this.use != null) {
            string = this.use.toXMLString();
            list.add(new XSDObjectAttribute("use", string));
        }
        if (this.form != null) {
            list.add(new XSDObjectAttribute("form", this.form.toString()));
        }
    }

    public XSDObjectIterator getChildren() {
        return new ChildItr(this, null);
    }

    public Object clone() {
        XSDAttribute xSDAttribute = (XSDAttribute)super.clone();
        if (this.type != null) {
            xSDAttribute.type = new ExpName(this.type);
        }
        if (this.anonymousType != null) {
            xSDAttribute.anonymousType = (XSDBaseSimpleType)this.anonymousType.clone();
        }
        xSDAttribute.valueConstraint = this.valueConstraint;
        xSDAttribute.form = this.form;
        return xSDAttribute;
    }

    static /* synthetic */ XSDBaseSimpleType access$100(XSDAttribute xSDAttribute) {
        return xSDAttribute.anonymousType;
    }
}

