/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.model;

import java.util.ArrayList;
import java.util.Iterator;
import weblogic.xml.schema.model.ExpName;
import weblogic.xml.schema.model.XSDException;
import weblogic.xml.schema.model.XSDFacet;
import weblogic.xml.schema.model.XSDNamedObject;
import weblogic.xml.schema.model.XSDValidityException;
import weblogic.xml.stream.XMLName;

public abstract class XSDAnyType
extends XSDNamedObject
implements Cloneable {
    private XMLName baseType;
    protected static final ArrayList EMPTY_FACETS = XSDAnyType.createEmptyFacets();

    public XSDAnyType() {
        super(new ExpName(null, null));
    }

    public XSDAnyType(XMLName xMLName) {
        super(xMLName);
    }

    public XSDAnyType(String string, String string2, String string3) {
        super(new ExpName(string, string2, string3));
    }

    public abstract XMLName getBaseType() throws XSDException;

    public XSDAnyType getBaseTypeObject() throws XSDException {
        XMLName xMLName = this.getBaseType();
        if (xMLName == null) {
            XMLName xMLName2 = this.getXMLName();
            String string = xMLName2 != null ? xMLName2.getQualifiedName() : "<anonymous>";
            throw new XSDValidityException("no base type found for " + string);
        }
        XSDAnyType xSDAnyType = this.lookupType(xMLName);
        if (xSDAnyType == null) {
            throw new XSDValidityException("unable to resolve type " + xMLName);
        }
        return xSDAnyType;
    }

    public ArrayList getResolvedFacets() throws XSDException {
        return EMPTY_FACETS;
    }

    public ArrayList getFacets() throws XSDValidityException {
        return EMPTY_FACETS;
    }

    public static boolean containsFacets(ArrayList arrayList) {
        if (arrayList == null) {
            return false;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() == null) continue;
            return true;
        }
        return false;
    }

    protected ArrayList mergeFacets(ArrayList arrayList, ArrayList arrayList2) {
        int n = XSDFacet.getMaxFacetType();
        for (int i = 1; i <= n; ++i) {
            Object e = arrayList.get(i);
            Object e2 = arrayList2.get(i);
            if (e == null) continue;
            arrayList2.set(i, e);
        }
        return arrayList2;
    }

    protected static ArrayList createEmptyFacets() {
        int n = XSDFacet.getMaxFacetType();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i <= n; ++i) {
            arrayList.add(null);
        }
        return arrayList;
    }

    public abstract boolean isBuiltin();

    public Object clone() {
        XSDAnyType xSDAnyType = (XSDAnyType)super.clone();
        xSDAnyType.baseType = this.baseType != null ? new ExpName(this.baseType) : null;
        return xSDAnyType;
    }
}

