/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.util.runtime;

import weblogic.utils.Debug;
import weblogic.xml.schema.binding.util.runtime.Accumulator;

public final class StringList
implements Accumulator {
    private static final boolean DEBUG = false;
    private static final boolean ASSERT = false;
    private String[] store;
    private int size = 0;

    public StringList() {
        this(16);
    }

    public StringList(int n) {
        this.store = new String[n];
    }

    public String[] getStore() {
        return this.store;
    }

    public Object getFinalArray() {
        return this.getMinSizedArray();
    }

    public String[] getMinSizedArray() {
        String[] stringArray = new String[this.size];
        System.arraycopy(this.store, 0, stringArray, 0, this.size);
        return stringArray;
    }

    public int getCapacity() {
        return this.store.length;
    }

    public int getSize() {
        return this.size;
    }

    public void append(Object object) {
        this.add((String)object);
    }

    public void add(String string) {
        this.ensureCapacity(this.size + 1);
        this.store[this.size++] = string;
    }

    public String get(int n) {
        return this.store[n];
    }

    public void ensureCapacity(int n) {
        int n2 = this.store.length;
        if (n > n2) {
            String[] stringArray = this.store;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.store = new String[n3];
            System.arraycopy(stringArray, 0, this.store, 0, this.size);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        StringList stringList = new StringList();
        for (n = 0; n < 10000; ++n) {
            stringList.add("" + n);
        }
        for (n = 0; n < 10000; ++n) {
            String string = stringList.get(n);
            Debug.assertion(string.equals("" + n));
        }
        String[] stringArray2 = stringList.getStore();
        for (int i = 0; i < 10000; ++i) {
            String string = stringList.get(i);
            String string2 = stringArray2[i];
            Debug.assertion(string.equals(string2));
            Debug.assertion(string.equals("" + i));
        }
        Debug.say("good");
    }
}

