/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.util.runtime;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.collections.IdentityHashMap;
import weblogic.xml.schema.binding.Serializer;
import weblogic.xml.stream.XMLName;

public final class ObjectRefTable {
    private static final boolean ASSERT = false;
    private IdentityHashMap table = new IdentityHashMap();
    private Object firstObject = null;
    private int xmlIdCount = 0;
    private static final String ID_PREFIX = "ID_";

    public void put(Object object, Entry entry) {
        if (entry == null) {
            String string = "entry cannot be null";
            throw new IllegalArgumentException(string);
        }
        this.table.put(object, entry);
        entry.setXmlId(++this.xmlIdCount);
    }

    public Entry get(Object object) {
        return (Entry)this.table.get(object);
    }

    public Entry remove(Object object) {
        return (Entry)this.table.remove(object);
    }

    public boolean containsKey(Object object) {
        return this.table.containsKey(object);
    }

    public void clear() {
        this.table.clear();
    }

    public int size() {
        return this.table.size();
    }

    public Iterator getMultiRefObjects() {
        return new MultiRefIterator();
    }

    public void dump(PrintStream printStream) {
        printStream.println("ObjectRefTable size=" + this.size());
        Iterator iterator = this.table.keySet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Debug.assertion(this.containsKey(e));
            Entry entry = this.get(e);
            Debug.assertion(entry != null, "ENTRY is null for " + e);
            int n = entry.getRefCnt();
            printStream.println("REF_CNT=" + n + " IDHC=" + System.identityHashCode(e) + "\tKEY=" + e);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Integer n = new Integer(5);
        String string = n.toString();
        String string2 = n.toString();
        ObjectRefTable objectRefTable = new ObjectRefTable();
        objectRefTable.put(string, null);
        Debug.assertion(objectRefTable.containsKey(string));
        objectRefTable.put(string2, null);
        Debug.assertion(objectRefTable.containsKey(string2));
        Debug.assertion(objectRefTable.size() == 2);
        System.out.println("SIZE=" + objectRefTable.size());
        objectRefTable.remove(string);
        Debug.assertion(!objectRefTable.containsKey(string));
        Debug.assertion(objectRefTable.size() == 1);
        objectRefTable.clear();
        Debug.assertion(objectRefTable.size() == 0);
    }

    public static class Entry {
        private int refCnt = 0;
        private Serializer serializer = null;
        private List children = new ArrayList(8);
        private int xmlId;
        private XMLName name;

        public int getXmlId() {
            return this.xmlId;
        }

        public String getXmlIdString() {
            return ObjectRefTable.ID_PREFIX + this.xmlId;
        }

        private void setXmlId(int n) {
            this.xmlId = n;
        }

        public void incrementRefCnt() {
            ++this.refCnt;
        }

        public void zeroRefCnt() {
            this.refCnt = 0;
        }

        public void decrementRefCnt() {
            --this.refCnt;
        }

        public int getRefCnt() {
            return this.refCnt;
        }

        public void addChild(Object object) {
            this.children.add(object);
        }

        public Serializer getSerializer() {
            return this.serializer;
        }

        public void setSerializer(Serializer serializer) {
            this.serializer = serializer;
        }

        public List getChildren() {
            return this.children;
        }

        public Object getChild(int n) {
            return this.children.get(n);
        }

        public XMLName getName() {
            return this.name;
        }

        public void setName(XMLName xMLName) {
            this.name = xMLName;
        }
    }

    class MultiRefIterator
    implements Iterator {
        private Iterator base_itr;
        private Object nextObj;

        MultiRefIterator() {
            this.base_itr = ObjectRefTable.this.table.entrySet().iterator();
            this.nextObj = null;
            this.updateNext();
        }

        public boolean hasNext() {
            return this.nextObj != null;
        }

        public Object next() {
            Object object = this.nextObj;
            this.updateNext();
            return object;
        }

        public void remove() {
            throw new AssertionError("remove not supported");
        }

        private void updateNext() {
            while (this.base_itr.hasNext()) {
                Map.Entry entry = (Map.Entry)this.base_itr.next();
                Entry entry2 = (Entry)entry.getValue();
                if (entry2.getRefCnt() <= 1) continue;
                this.nextObj = entry.getKey();
                return;
            }
            this.nextObj = null;
        }
    }
}

