/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.util.runtime;

import weblogic.utils.Debug;
import weblogic.xml.schema.binding.util.runtime.Accumulator;

public final class FloatList
implements Accumulator {
    private static final boolean DEBUG = false;
    private static final boolean ASSERT = false;
    private float[] store;
    private int size = 0;

    public FloatList() {
        this(16);
    }

    public FloatList(int n) {
        this.store = new float[n];
    }

    public float[] getStore() {
        return this.store;
    }

    public Object getFinalArray() {
        return this.getMinSizedArray();
    }

    public float[] getMinSizedArray() {
        float[] fArray = new float[this.size];
        System.arraycopy(this.store, 0, fArray, 0, this.size);
        return fArray;
    }

    public int getCapacity() {
        return this.store.length;
    }

    public int getSize() {
        return this.size;
    }

    public void append(Object object) {
        this.add(((Number)object).floatValue());
    }

    public void add(float f) {
        this.ensureCapacity(this.size + 1);
        this.store[this.size++] = f;
    }

    public float get(int n) {
        return this.store[n];
    }

    public void ensureCapacity(int n) {
        int n2 = this.store.length;
        if (n > n2) {
            float[] fArray = this.store;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.store = new float[n3];
            System.arraycopy(fArray, 0, this.store, 0, this.size);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        FloatList floatList = new FloatList();
        for (n = 0; n < 10000; ++n) {
            floatList.add(n);
        }
        for (n = 0; n < 10000; ++n) {
            float f = floatList.get(n);
            Debug.assertion(f == (float)n);
        }
        float[] fArray = floatList.getStore();
        for (int i = 0; i < 10000; ++i) {
            float f;
            float f2 = floatList.get(i);
            Debug.assertion(f2 == (f = fArray[i]));
            Debug.assertion(f2 == (float)i);
        }
        Debug.say("good");
    }
}

