/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.util.runtime;

import weblogic.utils.Debug;
import weblogic.xml.schema.binding.util.runtime.Accumulator;

public final class DoubleList
implements Accumulator {
    private static final boolean DEBUG = false;
    private static final boolean ASSERT = false;
    private double[] store;
    private int size = 0;

    public DoubleList() {
        this(16);
    }

    public DoubleList(int n) {
        this.store = new double[n];
    }

    public double[] getStore() {
        return this.store;
    }

    public Object getFinalArray() {
        return this.getMinSizedArray();
    }

    public double[] getMinSizedArray() {
        double[] dArray = new double[this.size];
        System.arraycopy(this.store, 0, dArray, 0, this.size);
        return dArray;
    }

    public int getCapacity() {
        return this.store.length;
    }

    public int getSize() {
        return this.size;
    }

    public void append(Object object) {
        this.add(((Number)object).doubleValue());
    }

    public void add(double d) {
        this.ensureCapacity(this.size + 1);
        this.store[this.size++] = d;
    }

    public double get(int n) {
        return this.store[n];
    }

    public void ensureCapacity(int n) {
        int n2 = this.store.length;
        if (n > n2) {
            double[] dArray = this.store;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.store = new double[n3];
            System.arraycopy(dArray, 0, this.store, 0, this.size);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        DoubleList doubleList = new DoubleList();
        for (n = 0; n < 10000; ++n) {
            doubleList.add(n);
        }
        for (n = 0; n < 10000; ++n) {
            double d = doubleList.get(n);
            Debug.assertion(d == (double)n);
        }
        double[] dArray = doubleList.getStore();
        for (int i = 0; i < 10000; ++i) {
            double d;
            double d2 = doubleList.get(i);
            Debug.assertion(d2 == (d = dArray[i]));
            Debug.assertion(d2 == (double)i);
        }
        Debug.say("good");
    }
}

