/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.util.runtime;

import weblogic.utils.Debug;
import weblogic.xml.schema.binding.util.runtime.Accumulator;

public final class CharList
implements Accumulator {
    private static final boolean DEBUG = false;
    private static final boolean ASSERT = false;
    private char[] store;
    private int size = 0;

    public CharList() {
        this(16);
    }

    public CharList(int n) {
        this.store = new char[n];
    }

    public char[] getStore() {
        return this.store;
    }

    public Object getFinalArray() {
        return this.getMinSizedArray();
    }

    public char[] getMinSizedArray() {
        char[] cArray = new char[this.size];
        System.arraycopy(this.store, 0, cArray, 0, this.size);
        return cArray;
    }

    public int getCapacity() {
        return this.store.length;
    }

    public int getSize() {
        return this.size;
    }

    public void append(Object object) {
        this.add(((Character)object).charValue());
    }

    public void add(char c) {
        this.ensureCapacity(this.size + 1);
        this.store[this.size++] = c;
    }

    public char get(int n) {
        return this.store[n];
    }

    public void ensureCapacity(int n) {
        int n2 = this.store.length;
        if (n > n2) {
            char[] cArray = this.store;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.store = new char[n3];
            System.arraycopy(cArray, 0, this.store, 0, this.size);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        int n2;
        CharList charList = new CharList();
        for (n2 = 0; n2 < 10000; n2 = (char)(n2 + '\u0001')) {
            charList.add((char)n2);
        }
        for (n2 = 0; n2 < 10000; ++n2) {
            n = charList.get(n2);
            Debug.assertion(n == n2);
        }
        char[] cArray = charList.getStore();
        for (n = 0; n < 10000; ++n) {
            char c;
            char c2 = charList.get(n);
            Debug.assertion(c2 == (c = cArray[n]));
            Debug.assertion(c2 == n);
        }
        Debug.say("good");
    }
}

