/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.internal.codegen;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.xml.schema.binding.BindingConfiguration;
import weblogic.xml.schema.binding.BindingException;
import weblogic.xml.schema.binding.ClassContext;
import weblogic.xml.schema.binding.ClassContextFactory;
import weblogic.xml.schema.binding.SerializationException;
import weblogic.xml.schema.binding.TypeMapping;
import weblogic.xml.schema.binding.TypeMappingEntry;
import weblogic.xml.schema.binding.internal.NameUtil;
import weblogic.xml.schema.binding.internal.ServerTypeMapping;
import weblogic.xml.schema.binding.internal.XSDMappingDefaults;
import weblogic.xml.schema.binding.internal.builtin.XSDSimpleTypeSerializer;
import weblogic.xml.schema.binding.internal.codegen.ArrayUtils;
import weblogic.xml.schema.binding.internal.codegen.BeanDescriptor;
import weblogic.xml.schema.binding.internal.codegen.BeanProperty;
import weblogic.xml.schema.binding.internal.codegen.JavaInspector;
import weblogic.xml.schema.binding.internal.codegen.Utils;
import weblogic.xml.schema.model.ExpName;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.XMLName;

final class JavaInspector {
    private final TypeMapping typeMapping;
    private final BindingConfiguration bindingConfig;
    private final DescriptorMap descriptors = new DescriptorMap(null);
    private final Set classesInspected = new HashSet();
    private final boolean trace;
    private static final boolean DEBUG = false;
    private static final boolean ASSERT = true;
    private static final XMLName UNUSED = ElementFactory.createXMLName("unused");
    private int currentDepth = 0;
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final String CLASS_MSG = "All classes that will be serialized or deserialized must be non-interface, non-abstract classes that provide a public default constructor";
    private static final Class[] STRING_ARG = new Class[]{class$java$lang$String == null ? (class$java$lang$String = JavaInspector.class$("java.lang.String")) : class$java$lang$String};
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$xml$rpc$holders$Holder;

    JavaInspector(TypeMapping typeMapping, BindingConfiguration bindingConfiguration) {
        this.typeMapping = typeMapping;
        this.bindingConfig = bindingConfiguration;
        this.trace = bindingConfiguration.isVerbose();
    }

    Set getClassesInspected() {
        return Collections.unmodifiableSet(this.classesInspected);
    }

    List getDescriptors() {
        return Utils.getListFromMapValues((Map)this.descriptors.getMap());
    }

    void clearDescriptors() {
        this.descriptors.clear();
    }

    BeanDescriptor createDescriptorForClass(Class clazz) throws BindingException {
        BeanDescriptor beanDescriptor = this.getDescriptor(clazz);
        return beanDescriptor;
    }

    private BeanDescriptor getDescriptor(Class clazz) throws BindingException {
        BeanDescriptor beanDescriptor = this.descriptors.get(clazz.getName());
        if (beanDescriptor != null) {
            return beanDescriptor;
        }
        if (this.trace) {
            ++this.currentDepth;
            int n = this.currentDepth;
            for (int i = 0; i < n; ++i) {
                System.out.print("-");
            }
            System.out.println("inspecting: " + JavaInspector.pretty_class(clazz));
        }
        beanDescriptor = null;
        TypeMappingEntry typeMappingEntry = this.getTypeFromMap(clazz);
        if (typeMappingEntry != null) {
            beanDescriptor = Utils.buildDescriptor((TypeMappingEntry)typeMappingEntry);
            this.descriptors.put(beanDescriptor);
        } else {
            beanDescriptor = new BeanDescriptor();
            beanDescriptor.setJavaName(clazz.getName());
            this.descriptors.put(beanDescriptor);
            this.fillDescriptor(beanDescriptor, clazz);
        }
        Debug.assertion(clazz.getName().equals(beanDescriptor.getJavaName()));
        if (this.trace) {
            int n = this.currentDepth;
            for (int i = 0; i < n; ++i) {
                System.out.print("-");
            }
            System.out.println("mapped:     " + JavaInspector.pretty_class(clazz) + " => " + beanDescriptor.getXmlName());
            --this.currentDepth;
        }
        return beanDescriptor;
    }

    private static String pretty_class(Class clazz) {
        if (clazz.isArray()) {
            return ArrayUtils.getArrayDeclString(clazz.getName());
        }
        return clazz.getName();
    }

    private void fillDescriptor(BeanDescriptor beanDescriptor, Class clazz) throws BindingException {
        Object object;
        if (!this.fillCollectionDescriptor(beanDescriptor, clazz) && !this.fillExceptionDescriptor(beanDescriptor, clazz)) {
            this.ensureValidClass(clazz);
            object = this.getDescriptorXMLTypeName(clazz);
            boolean bl = clazz.isArray();
            beanDescriptor.setUserJavaType(true);
            this.setDescriptorXmlName(beanDescriptor, (XMLName)object);
            beanDescriptor.setJavaName(clazz.getName());
            beanDescriptor.setImplName(clazz.getName());
            beanDescriptor.setArray(clazz.isArray());
            if (bl) {
                if (this.bindingConfig.isUseSoapStyleArrays()) {
                    this.addPropertiesToSoapArray(beanDescriptor, clazz);
                } else {
                    this.addPropertiesToArray(beanDescriptor, clazz);
                }
                beanDescriptor.setGeneratedFilenameBase(beanDescriptor.getXmlName().getLocalName());
            } else if (JavaInspector.isCharType(clazz)) {
                this.fixCharType(beanDescriptor, clazz);
            } else if (JavaInspector.isJaxRpcEnum(clazz)) {
                this.fixEnumType(beanDescriptor, clazz);
            } else {
                BeanDescriptor beanDescriptor2;
                if (this.doInheritance() && (beanDescriptor2 = this.getSuperType(clazz)) != null) {
                    beanDescriptor.setSuperType(beanDescriptor2);
                    beanDescriptor2.setParentType(true);
                }
                beanDescriptor.setCompositor(Utils.getDefaultModelGroupType());
                this.addPropertiesToScalar(beanDescriptor, clazz);
                if (JavaInspector.isAbstractClass(clazz)) {
                    beanDescriptor.setAbstract(true);
                }
            }
        }
        Debug.assertion(beanDescriptor != null);
        object = beanDescriptor.getXmlName().getNamespaceUri();
        Debug.assertion(object != null, "BD=" + beanDescriptor);
        this.classesInspected.add(clazz);
    }

    private boolean fillExceptionDescriptor(BeanDescriptor beanDescriptor, Class clazz) throws BindingException {
        BeanDescriptor beanDescriptor2;
        if (!(class$java$lang$Exception == null ? (class$java$lang$Exception = JavaInspector.class$("java.lang.Exception")) : class$java$lang$Exception).isAssignableFrom(clazz)) {
            return false;
        }
        beanDescriptor.setException(true);
        XMLName xMLName = this.getDescriptorXMLTypeName(clazz);
        beanDescriptor.setUserJavaType(true);
        this.setDescriptorXmlName(beanDescriptor, xMLName);
        beanDescriptor.setJavaName(clazz.getName());
        beanDescriptor.setImplName(clazz.getName());
        if (this.doInheritance() && (beanDescriptor2 = this.getExceptionSuperType(clazz)) != null) {
            beanDescriptor.setSuperType(beanDescriptor2);
            beanDescriptor2.setParentType(true);
        }
        beanDescriptor.setCompositor(Utils.getDefaultModelGroupType());
        this.addPropertiesToException(beanDescriptor, clazz);
        if (JavaInspector.isAbstractClass(clazz)) {
            beanDescriptor.setAbstract(true);
        }
        return true;
    }

    private void addPropertiesToException(BeanDescriptor beanDescriptor, Class clazz) throws BindingException {
        BeanProperty beanProperty;
        PropertyDescriptor[] propertyDescriptorArray;
        PropertyDescriptor[] propertyDescriptorArray2 = this.getExceptionProperties(clazz, true);
        Constructor[] constructorArray = this.getSortedConstructors(clazz);
        Constructor constructor = null;
        int[] nArray = null;
        HashMap<String, PropertyDescriptor> hashMap = null;
        block0: for (int i = constructorArray.length - 1; i >= 0; --i) {
            Class<?>[] classArray = constructorArray[i].getParameterTypes();
            if (classArray.length > propertyDescriptorArray2.length) continue;
            nArray = new int[classArray.length];
            hashMap = new HashMap<String, PropertyDescriptor>();
            propertyDescriptorArray = (PropertyDescriptor[])propertyDescriptorArray2.clone();
            for (int j = 0; j < classArray.length; ++j) {
                int n;
                if ((class$java$lang$Throwable == null ? JavaInspector.class$("java.lang.Throwable") : class$java$lang$Throwable).isAssignableFrom((Class<?>)(beanProperty = classArray[j])) || (n = this.findFirstMatchingType(propertyDescriptorArray, (Class)beanProperty)) == -1) continue block0;
                nArray[j] = n;
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray2[n];
                hashMap.put(propertyDescriptor.getName(), propertyDescriptor);
            }
            constructor = constructorArray[i];
            break;
        }
        if (constructor == null) {
            throw new BindingException("unable to determine valid constructor for exception " + clazz);
        }
        PropertyDescriptor[] propertyDescriptorArray3 = this.getExceptionProperties(clazz, false);
        for (int i = 0; i < propertyDescriptorArray3.length; ++i) {
            propertyDescriptorArray = propertyDescriptorArray3[i];
            if (hashMap.containsKey(propertyDescriptorArray.getName()) || !propertyDescriptorArray.getPropertyType().equals(class$java$lang$Exception == null ? JavaInspector.class$("java.lang.Exception") : class$java$lang$Exception) && !propertyDescriptorArray.getPropertyType().equals(class$java$lang$Throwable == null ? JavaInspector.class$("java.lang.Throwable") : class$java$lang$Throwable) && JavaInspector.isValidProperty((PropertyDescriptor)propertyDescriptorArray, clazz)) continue;
            propertyDescriptorArray3[i] = null;
        }
        String string = beanDescriptor.getXmlName().getNamespaceUri();
        for (int i = 0; i < propertyDescriptorArray3.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray3[i];
            if (propertyDescriptor == null) continue;
            beanProperty = this.createBeanProperty(propertyDescriptor, string);
            beanDescriptor.addProperty(beanProperty);
        }
        beanDescriptor.setConstructorPropertyList(nArray);
    }

    private int findFirstMatchingType(PropertyDescriptor[] propertyDescriptorArray, Class clazz) {
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            if (propertyDescriptor == null || !clazz.equals(propertyDescriptor.getPropertyType())) continue;
            propertyDescriptorArray[i] = null;
            return i;
        }
        return -1;
    }

    private PropertyDescriptor[] getExceptionProperties(Class clazz, boolean bl) throws BindingException {
        try {
            Object object;
            PropertyDescriptor[] propertyDescriptorArray;
            if (bl) {
                propertyDescriptorArray = this.getInheritedExceptionProperties(clazz);
            } else {
                object = this.doInheritance() ? Introspector.getBeanInfo(clazz, clazz.getSuperclass()) : Introspector.getBeanInfo(clazz);
                propertyDescriptorArray = object.getPropertyDescriptors();
            }
            object = new ArrayList();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                String string = propertyDescriptor.getName();
                Class<?> clazz2 = propertyDescriptor.getPropertyType();
                if (clazz2 == null || "class".equals(string) && clazz2 == (class$java$lang$Class == null ? JavaInspector.class$("java.lang.Class") : class$java$lang$Class) || !JavaInspector.isValidExceptionProperty(propertyDescriptor, clazz)) continue;
                ((ArrayList)object).add(propertyDescriptor);
            }
            PropertyDescriptor[] propertyDescriptorArray2 = new PropertyDescriptor[((ArrayList)object).size()];
            ((ArrayList)object).toArray(propertyDescriptorArray2);
            return propertyDescriptorArray2;
        }
        catch (IntrospectionException introspectionException) {
            throw new BindingException(introspectionException.getMessage(), introspectionException);
        }
        catch (SecurityException securityException) {
            throw new BindingException("security error introspecting " + clazz, securityException);
        }
    }

    private PropertyDescriptor[] getInheritedExceptionProperties(Class clazz) throws IntrospectionException {
        PropertyDescriptor[] propertyDescriptorArray;
        ArrayList<PropertyDescriptor[]> arrayList = new ArrayList<PropertyDescriptor[]>();
        Serializable serializable = clazz;
        while (!(class$java$lang$Exception == null ? JavaInspector.class$("java.lang.Exception") : class$java$lang$Exception).equals(serializable)) {
            Class clazz2 = ((Class)serializable).getSuperclass();
            propertyDescriptorArray = Introspector.getBeanInfo(serializable, clazz2);
            PropertyDescriptor[] propertyDescriptorArray2 = propertyDescriptorArray.getPropertyDescriptors();
            arrayList.add(propertyDescriptorArray2);
            serializable = clazz2;
        }
        Collections.reverse(arrayList);
        serializable = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            propertyDescriptorArray = (PropertyDescriptor[])arrayList.get(i);
            serializable.addAll(Arrays.asList(propertyDescriptorArray));
        }
        PropertyDescriptor[] propertyDescriptorArray3 = new PropertyDescriptor[serializable.size()];
        serializable.toArray(propertyDescriptorArray3);
        return propertyDescriptorArray3;
    }

    private Constructor[] getSortedConstructors(Class clazz) {
        Constructor[] constructorArray = clazz.getConstructors();
        Arrays.sort(constructorArray, new CtorComparator(null));
        return constructorArray;
    }

    private static boolean isValidExceptionProperty(PropertyDescriptor propertyDescriptor, Class clazz) {
        Method method = propertyDescriptor.getReadMethod();
        if (method == null) {
            JavaInspector.warn("ignoring bean property \"" + propertyDescriptor.getName() + "\" in " + clazz + ": no get method found.");
            return false;
        }
        return true;
    }

    private static boolean isAbstractClass(Class clazz) {
        int n = clazz.getModifiers();
        return Modifier.isAbstract(n);
    }

    private BeanDescriptor getSuperType(Class clazz) throws BindingException {
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 == null) {
            return null;
        }
        if (clazz2.equals(class$java$lang$Object == null ? (class$java$lang$Object = JavaInspector.class$("java.lang.Object")) : class$java$lang$Object)) {
            return null;
        }
        return this.getDescriptor(clazz2);
    }

    private BeanDescriptor getExceptionSuperType(Class clazz) throws BindingException {
        Class clazz2 = JavaInspector.getExceptionSuperClass(clazz);
        if (clazz2 == null) {
            return null;
        }
        return this.getDescriptor(clazz2);
    }

    private static Class getExceptionSuperClass(Class clazz) {
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 == null) {
            return null;
        }
        if (clazz2.equals(class$java$lang$Exception == null ? (class$java$lang$Exception = JavaInspector.class$("java.lang.Exception")) : class$java$lang$Exception)) {
            return null;
        }
        if (clazz2.equals(class$java$lang$Object == null ? (class$java$lang$Object = JavaInspector.class$("java.lang.Object")) : class$java$lang$Object)) {
            return null;
        }
        return clazz2;
    }

    private boolean fillCollectionDescriptor(BeanDescriptor beanDescriptor, Class clazz) throws BindingException {
        if ((class$java$util$Collection == null ? (class$java$util$Collection = JavaInspector.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz)) {
            if (!Utils.isSupportedListType((String)clazz.getName())) {
                return false;
            }
        } else {
            if ((class$java$util$Map == null ? (class$java$util$Map = JavaInspector.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(clazz)) {
                beanDescriptor.setArray(false);
                return false;
            }
            return false;
        }
        beanDescriptor.setArray(true);
        beanDescriptor.setCollection(true);
        XMLName xMLName = this.getDescriptorXMLTypeName(clazz);
        xMLName = ElementFactory.createXMLName("java:language_builtins.util", xMLName.getLocalName());
        beanDescriptor.setUserJavaType(true);
        this.setDescriptorXmlName(beanDescriptor, xMLName);
        beanDescriptor.setJavaName(clazz.getName());
        beanDescriptor.setImplName(clazz.getName());
        if (beanDescriptor.isArray()) {
            if (this.bindingConfig.isUseSoapStyleArrays()) {
                this.addPropertiesToSoapArray(beanDescriptor, array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = JavaInspector.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object);
            } else {
                this.addPropertiesToArray(beanDescriptor, array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = JavaInspector.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object);
            }
        } else {
            this.addPropertiesToScalar(beanDescriptor, clazz);
        }
        return true;
    }

    private static boolean isCharType(Class clazz) {
        return Character.TYPE.equals(clazz) || (class$java$lang$Character == null ? (class$java$lang$Character = JavaInspector.class$("java.lang.Character")) : class$java$lang$Character).equals(clazz);
    }

    private void setDescriptorXmlName(BeanDescriptor beanDescriptor, XMLName xMLName) {
        this.descriptors.remove(beanDescriptor);
        beanDescriptor.setXmlName(xMLName);
        this.descriptors.put(beanDescriptor);
    }

    private void fixCharType(BeanDescriptor beanDescriptor, Class clazz) throws BindingException {
        beanDescriptor.setSimpleContent(true);
        beanDescriptor.setPrimitive(clazz.isPrimitive());
        beanDescriptor.setUserJavaType(false);
        beanDescriptor.setImplName(clazz.getName());
        beanDescriptor.setInMap(false);
        BeanDescriptor beanDescriptor2 = this.getDescriptor(class$java$lang$String == null ? (class$java$lang$String = JavaInspector.class$("java.lang.String")) : class$java$lang$String);
        BeanProperty beanProperty = this.newBeanProperty();
        beanProperty.setType(beanDescriptor2);
    }

    private void fixEnumType(BeanDescriptor beanDescriptor, Class clazz) throws BindingException {
        Object object;
        beanDescriptor.setSimpleContent(true);
        beanDescriptor.setUserJavaType(false);
        beanDescriptor.setInMap(false);
        beanDescriptor.setImplName(clazz.getName());
        Class<?> clazz2 = null;
        Method method = null;
        try {
            method = clazz.getMethod("getValue", null);
            clazz2 = method.getReturnType();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError("internal error: " + noSuchMethodException, noSuchMethodException);
        }
        Debug.assertion(clazz2 != null);
        TypeMappingEntry typeMappingEntry = this.getTypeFromMap(clazz2);
        XSDSimpleTypeSerializer xSDSimpleTypeSerializer = null;
        if (typeMappingEntry != null && (object = typeMappingEntry.getSerializer()) instanceof XSDSimpleTypeSerializer) {
            xSDSimpleTypeSerializer = (XSDSimpleTypeSerializer)object;
        }
        if (xSDSimpleTypeSerializer == null) {
            object = "failed to find appropriate serializer for " + clazz2;
            throw new BindingException((String)object);
        }
        object = JavaInspector.getEnumValues(clazz, method);
        Utils.removeDuplicatesOrdered((List)object);
        Debug.assertion(!object.isEmpty());
        String[] stringArray = JavaInspector.serializeEnumValues((List)object, xSDSimpleTypeSerializer);
        Debug.assertion(stringArray.length > 0);
        beanDescriptor.setEnumValues(stringArray);
        beanDescriptor.setPrimitive(false);
        BeanDescriptor beanDescriptor2 = this.getDescriptor(clazz2);
        BeanProperty beanProperty = this.newBeanProperty();
        beanProperty.setXmlName(UNUSED);
        beanProperty.setType(beanDescriptor2);
        beanDescriptor.addProperty(beanProperty);
        Debug.assertion(beanDescriptor.getElementCount() == 1);
    }

    private static String[] serializeEnumValues(List list, XSDSimpleTypeSerializer xSDSimpleTypeSerializer) throws BindingException {
        int n = list.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof QName) {
                stringArray[n2] = e.toString();
            } else {
                try {
                    stringArray[n2] = xSDSimpleTypeSerializer.basicSerialize(e);
                }
                catch (SerializationException serializationException) {
                    throw new BindingException("unable to serialize " + e, serializationException);
                }
            }
            ++n2;
        }
        return stringArray;
    }

    private static List getEnumValues(Class clazz, Method method) throws BindingException {
        Debug.assertion(method != null);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            int n;
            Field field = fieldArray[i];
            if (!field.getType().equals(clazz) || !Modifier.isPublic(n = field.getModifiers()) || !Modifier.isFinal(n) || !Modifier.isStatic(n)) continue;
            try {
                Object object = field.get(null);
                Object object2 = method.invoke(object, EMPTY_ARGS);
                arrayList.add(object2);
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new BindingException("unable to invoke " + method + " on " + field, invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new BindingException("unable to access field " + field, illegalAccessException);
            }
        }
        return arrayList;
    }

    private void addPropertiesToArray(BeanDescriptor beanDescriptor, Class clazz) throws BindingException {
        Debug.assertion(clazz.isArray());
        Class<?> clazz2 = clazz.getComponentType();
        BeanDescriptor beanDescriptor2 = this.getDescriptor(clazz2);
        XMLName xMLName = beanDescriptor2.getXmlName();
        BeanProperty beanProperty = this.newBeanProperty();
        beanProperty.setMaxOccurs(Integer.MAX_VALUE);
        beanProperty.setName(xMLName.getLocalName());
        beanProperty.setXmlAttribute(false);
        XMLName xMLName2 = ElementFactory.createXMLName(beanDescriptor.getXmlName().getNamespaceUri(), xMLName.getLocalName());
        beanProperty.setXmlName(xMLName2);
        beanProperty.setType(beanDescriptor2);
        String string = NameUtil.upcaseFirstLetter(beanProperty.getName());
        beanProperty.setGetter("get" + string);
        beanProperty.setSetter("set" + string);
        beanDescriptor.addProperty(beanProperty);
    }

    private void addPropertiesToSoapArray(BeanDescriptor beanDescriptor, Class beanDescriptor2) throws BindingException {
        BeanDescriptor beanDescriptor3;
        BeanDescriptor beanDescriptor4;
        Debug.assertion(beanDescriptor2.isArray());
        int n = 0;
        if (this.bindingConfig.isUseMultiDimensionalSoapArrays()) {
            beanDescriptor4 = beanDescriptor2;
            while (beanDescriptor4.isArray()) {
                ++n;
                beanDescriptor4 = beanDescriptor4.getComponentType();
            }
            beanDescriptor3 = beanDescriptor4;
        } else {
            beanDescriptor3 = beanDescriptor2.getComponentType();
            n = 1;
        }
        Debug.assertion(n > 0);
        beanDescriptor4 = this.getDescriptor((Class)beanDescriptor3);
        XMLName xMLName = beanDescriptor4.getXmlName();
        beanDescriptor.setSoapArrayDimension(n);
        BeanProperty beanProperty = this.newBeanProperty();
        beanProperty.setMaxOccurs(Integer.MAX_VALUE);
        beanProperty.setName(xMLName.getLocalName());
        beanProperty.setXmlAttribute(false);
        beanProperty.setXmlName(xMLName);
        beanProperty.setType(beanDescriptor4);
        String string = NameUtil.upcaseFirstLetter(beanProperty.getName());
        beanProperty.setGetter("get" + string);
        beanProperty.setSetter("set" + string);
        beanDescriptor.addProperty(beanProperty);
    }

    private void addPropertiesToScalar(BeanDescriptor beanDescriptor, Class clazz) throws BindingException {
        PropertyDescriptor propertyDescriptor;
        Object object;
        String string = beanDescriptor.getXmlName().getNamespaceUri();
        try {
            object = this.doInheritance() ? Introspector.getBeanInfo(clazz, clazz.getSuperclass()) : Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] propertyDescriptorArray = object.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                propertyDescriptor = propertyDescriptorArray[i];
                String string2 = propertyDescriptor.getName();
                Class<?> clazz2 = propertyDescriptor.getPropertyType();
                if (clazz2 == null || "class".equals(string2) && clazz2 == (class$java$lang$Class == null ? JavaInspector.class$("java.lang.Class") : class$java$lang$Class) || !JavaInspector.isValidProperty(propertyDescriptor, clazz)) continue;
                JavaInspector.checkFieldConflict(string2, clazz);
                BeanProperty beanProperty = this.createBeanProperty(propertyDescriptor, string);
                beanDescriptor.addProperty(beanProperty);
            }
        }
        catch (IntrospectionException introspectionException) {
            throw new BindingException(introspectionException.getMessage(), introspectionException);
        }
        catch (SecurityException securityException) {
            throw new BindingException("security error introspecting " + clazz, securityException);
        }
        try {
            object = clazz.getDeclaredFields();
            for (int i = 0; i < ((Field[])object).length; ++i) {
                Field field = object[i];
                if (!JavaInspector.isValidField(field)) continue;
                propertyDescriptor = this.createBeanProperty(field, string);
                beanDescriptor.addProperty((BeanProperty)propertyDescriptor);
            }
        }
        catch (SecurityException securityException) {
            throw new BindingException("security error introspecting " + clazz, securityException);
        }
    }

    private static void checkFieldConflict(String string, Class clazz) throws BindingException {
        Field field = null;
        try {
            field = clazz.getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            field = null;
        }
        if (field != null && JavaInspector.isValidField(field)) {
            String string2 = "Error: bean property and public field found with the same name: " + string;
            throw new BindingException(string2);
        }
    }

    private static boolean isValidField(Field field) {
        int n = field.getModifiers();
        return Modifier.isPublic(n) && !Modifier.isTransient(n) && !Modifier.isFinal(n) && !Modifier.isStatic(n);
    }

    private static boolean isValidProperty(PropertyDescriptor propertyDescriptor, Class clazz) {
        Method method = propertyDescriptor.getReadMethod();
        Method method2 = propertyDescriptor.getWriteMethod();
        if (method == null || method2 == null) {
            JavaInspector.warn("ignoring bean property \"" + propertyDescriptor.getName() + "\" in " + clazz + ": no " + (method == null ? "get" : "set") + " method found.");
            return false;
        }
        return true;
    }

    private BeanProperty createBeanProperty(PropertyDescriptor propertyDescriptor, String string) throws BindingException {
        String string2 = propertyDescriptor.getName();
        Class<?> clazz = propertyDescriptor.getPropertyType();
        BeanProperty beanProperty = this.createBeanProperty(string2, string, clazz);
        Method method = propertyDescriptor.getReadMethod();
        Debug.assertion(method != null);
        beanProperty.setGetter(method.getName());
        beanProperty.setCheckedExceptionsForGetter((Class[])method.getExceptionTypes());
        Method method2 = propertyDescriptor.getWriteMethod();
        if (method2 != null) {
            beanProperty.setSetter(method2.getName());
            beanProperty.setCheckedExceptionsForSetter((Class[])method2.getExceptionTypes());
        }
        return beanProperty;
    }

    private BeanProperty createBeanProperty(String string, String string2, Class clazz) throws BindingException {
        BeanProperty beanProperty = this.newBeanProperty();
        beanProperty.setName(string);
        BeanDescriptor beanDescriptor = this.getDescriptor(clazz);
        beanProperty.setType(beanDescriptor);
        beanProperty.setXmlName(ElementFactory.createXMLName(string2, string));
        beanProperty.setXmlAttribute(false);
        return beanProperty;
    }

    private BeanProperty createBeanProperty(Field field, String string) throws BindingException {
        BeanProperty beanProperty = this.createBeanProperty(field.getName(), string, field.getType());
        beanProperty.setField(true);
        return beanProperty;
    }

    private XMLName getDescriptorXMLTypeName(Class clazz) {
        int n = 0;
        while (clazz.isArray()) {
            ++n;
            clazz = clazz.getComponentType();
        }
        ExpName expName = new ExpName(NameUtil.getXMLNameFromClass(clazz, this.bindingConfig));
        if (n > 0) {
            String string = Utils.getArrayName((String)expName.getLocalName(), (int)n);
            expName.setLocalName(string);
        }
        int n2 = 2;
        while (this.descriptors.getFromXmlType((XMLName)expName) != null) {
            expName.setLocalName(expName.getLocalName() + n2);
            ++n2;
        }
        return expName;
    }

    private TypeMappingEntry getTypeFromMap(Class clazz) {
        Object object;
        TypeMappingEntry typeMappingEntry = this.getTypeFromServerMap(clazz);
        if (typeMappingEntry != null) {
            return typeMappingEntry;
        }
        String string = clazz.getName();
        XMLName xMLName = (XMLName)XSDMappingDefaults.JavaToXSDMap.get(string);
        if (xMLName == null) {
            xMLName = this.typeMapping.getXMLNameFromClass(clazz);
        }
        if (xMLName == null) {
            object = NameUtil.getNamespaceFromPackage(clazz, this.bindingConfig);
            String string2 = NameUtil.getRootClassNameFromClass(string);
            xMLName = new ExpName((String)object, string2);
        }
        object = ClassContextFactory.newInstance().createClassContext(xMLName);
        typeMappingEntry = this.typeMapping.get(clazz, (ClassContext)object);
        return typeMappingEntry;
    }

    private TypeMappingEntry getTypeFromServerMap(Class clazz) {
        TypeMapping typeMapping = ServerTypeMapping.getServerMapping();
        XMLName xMLName = typeMapping.getXMLNameFromClass(clazz);
        if (xMLName == null) {
            return null;
        }
        ClassContext classContext = ClassContextFactory.newInstance().createClassContext(xMLName);
        TypeMappingEntry typeMappingEntry = typeMapping.get(clazz, classContext);
        if (typeMappingEntry != null) {
            this.typeMapping.add(typeMappingEntry);
            return typeMappingEntry;
        }
        return null;
    }

    private void ensureValidClass(Class clazz) throws BindingException {
        if (clazz.isPrimitive()) {
            return;
        }
        if ((class$javax$xml$rpc$holders$Holder == null ? (class$javax$xml$rpc$holders$Holder = JavaInspector.class$("javax.xml.rpc.holders.Holder")) : class$javax$xml$rpc$holders$Holder).isAssignableFrom(clazz)) {
            String string = "JAX-RPC Holder classes as class members are not supported.  Holder class is " + clazz.getName();
            throw new BindingException(string);
        }
        if (XSDMappingDefaults.JavaToXSDMap.containsKey(clazz.getName())) {
            return;
        }
        if (this.getTypeFromServerMap(clazz) != null) {
            return;
        }
        if (clazz.isInterface()) {
            throw new BindingException(JavaInspector.noInterfaceAllowedMsg(clazz));
        }
        if (clazz.isArray()) {
            this.ensureValidClass(clazz.getComponentType());
            return;
        }
        if (JavaInspector.isJaxRpcEnum(clazz)) {
            return;
        }
        try {
            Constructor constructor = clazz.getConstructor(EMPTY_CLASS_ARRAY);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new BindingException(JavaInspector.noDefaultConstructorMsg(clazz), noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new BindingException(JavaInspector.noDefaultConstructorMsg(clazz), securityException);
        }
    }

    private static String noInterfaceAllowedMsg(Class clazz) {
        return "Invalid class received: " + clazz + " loaded from " + JavaInspector.whereFrom(clazz) + ".  " + CLASS_MSG;
    }

    private static String noDefaultConstructorMsg(Class clazz) {
        return "No default constructor was found for " + clazz + " loaded from " + JavaInspector.whereFrom(clazz) + ".  " + CLASS_MSG;
    }

    private static boolean isJaxRpcEnum(Class clazz) {
        Field[] fieldArray;
        Constructor<?>[] constructorArray = clazz.getConstructors();
        if (constructorArray.length > 0) {
            return false;
        }
        try {
            fieldArray = clazz.getMethod("getValue", null);
            Method method = clazz.getMethod("fromString", STRING_ARG);
            if (!clazz.equals(method.getReturnType())) {
                return false;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            int n;
            Field field = fieldArray[i];
            if (!field.getType().equals(clazz) || !Modifier.isPublic(n = field.getModifiers()) || !Modifier.isFinal(n) || !Modifier.isStatic(n)) continue;
            return true;
        }
        return false;
    }

    private static String whereFrom(Class clazz) {
        String string = clazz.getName();
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        string = string.replace('.', '/');
        string = string + ".class";
        URL uRL = clazz.getResource(string);
        return uRL.getFile();
    }

    private BeanProperty newBeanProperty() {
        BeanProperty beanProperty = new BeanProperty();
        beanProperty.setFormQualified(this.bindingConfig.isSchemaElementFormQualified());
        return beanProperty;
    }

    private static void warn(String string) {
        System.err.println("WARNING: " + string);
    }

    private boolean doInheritance() {
        return this.bindingConfig.isMapJavaInheritance();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

