/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.internal.builtin;

import weblogic.xml.schema.binding.CodecBase;
import weblogic.xml.schema.binding.SerializationContext;
import weblogic.xml.schema.binding.SerializationContextFactory;
import weblogic.xml.schema.binding.SerializationException;
import weblogic.xml.schema.binding.util.runtime.ObjectRefTable;
import weblogic.xml.schema.binding.util.runtime.PropertyInfo;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public abstract class XSDSimpleTypeSerializer
extends CodecBase {
    private static final boolean ASSERT = false;

    public int getPropertyCount() {
        return 0;
    }

    public PropertyInfo getPropertyInfo(int n) {
        throw new IndexOutOfBoundsException("invalid index " + n);
    }

    protected abstract String getContentFromObject(Object var1, SerializationContext var2) throws SerializationException;

    public String basicSerialize(Object object) throws SerializationException {
        SerializationContext serializationContext = SerializationContextFactory.newInstance().createSerializationContext();
        return this.getContentFromObject(object, serializationContext);
    }

    protected String getContentFromNullObject() throws SerializationException {
        return "";
    }

    public void serialize(Object object, XMLName xMLName, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException {
        if (serializationContext.isInAttribute()) {
            if (object == null) {
                return;
            }
            String string = this.getContentFromObject(object, serializationContext);
            Attribute attribute = ElementFactory.createAttribute(xMLName, string);
            try {
                xMLOutputStream.add(attribute);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new SerializationException("stream error", xMLStreamException);
            }
        } else {
            super.serialize(object, xMLName, xMLOutputStream, serializationContext);
        }
    }

    protected void gatherContents(Object object, ObjectRefTable.Entry entry, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException {
    }

    protected void writeContents(Object object, ObjectRefTable.Entry entry, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException, XMLStreamException {
        this.writeContentToStream(object, xMLOutputStream, serializationContext);
    }

    public void writeContentToStream(Object object, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException, XMLStreamException {
        String string = this.getContentFromObject(object, serializationContext);
        xMLOutputStream.add(ElementFactory.createCharacterData(string));
    }

    protected String createInvalidInputMsg(String string, Object object) {
        return this.getClass().getName() + " can only serialize objects of type " + string + ".  " + "Received object of type " + object.getClass();
    }
}

