/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.internal.builtin;

import java.math.BigDecimal;
import weblogic.utils.AssertionError;
import weblogic.xml.schema.binding.CodecBase;
import weblogic.xml.schema.binding.DeserializationContext;
import weblogic.xml.schema.binding.DeserializationException;
import weblogic.xml.schema.binding.FacetUtils;
import weblogic.xml.schema.binding.RuntimeUtils;
import weblogic.xml.schema.binding.SerializationContext;
import weblogic.xml.schema.binding.SerializationException;
import weblogic.xml.schema.binding.internal.SchemaUtil;
import weblogic.xml.schema.binding.util.runtime.ObjectRefTable;
import weblogic.xml.schema.binding.util.runtime.PropertyInfo;
import weblogic.xml.schema.model.WhitespaceFacetType;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.CharacterData;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public abstract class XSDSimpleTypeDeserializer
extends CodecBase {
    private static final boolean ASSERT = false;
    private static final boolean VERBOSE = false;

    public int getPropertyCount() {
        return 0;
    }

    public PropertyInfo getPropertyInfo(int n) {
        throw new IndexOutOfBoundsException("invalid index " + n);
    }

    protected abstract Object getObjectFromContent(String var1, DeserializationContext var2) throws DeserializationException;

    protected Object getObjectFromNoContent() throws DeserializationException {
        return null;
    }

    protected WhitespaceFacetType getWhitespaceBehavior() {
        return WhitespaceFacetType.COLLAPSE;
    }

    protected XMLName getXmlType() {
        throw new AssertionError("not used");
    }

    public Object deserialize(XMLName xMLName, XMLInputStream xMLInputStream, DeserializationContext deserializationContext) throws DeserializationException {
        try {
            if (xMLInputStream.skip(2)) {
                StartElement startElement = (StartElement)xMLInputStream.peek();
                String string = XSDSimpleTypeDeserializer.checkForRef(startElement);
                if (string != null) {
                    return XSDSimpleTypeDeserializer.deserializeReferredObject(string, this, xMLName, xMLInputStream, deserializationContext);
                }
                if (RuntimeUtils.checkForXsiNil(startElement)) {
                    xMLInputStream.skipElement();
                    return null;
                }
                startElement = (StartElement)xMLInputStream.next();
                if (deserializationContext.isValidateNames()) {
                    this.validateNames(xMLName, startElement.getName(), deserializationContext);
                }
                return this.processContent(xMLInputStream, deserializationContext);
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DeserializationException(xMLStreamException.getMessage(), xMLStreamException);
        }
        throw new DeserializationException("failed to find start element");
    }

    protected void validateNames(XMLName xMLName, XMLName xMLName2, DeserializationContext deserializationContext) throws DeserializationException {
        if (deserializationContext.isValidateLocalNameOnly()) {
            String string;
            String string2 = xMLName.getLocalName();
            if (!string2.equals(string = xMLName2.getLocalName())) {
                throw new DeserializationException("unexpected name \"" + string + "\" expecting \"" + string2 + "\"");
            }
        } else if (!xMLName.equals(xMLName2)) {
            throw new DeserializationException("unexpected name \"" + xMLName2 + "\" expecting \"" + xMLName + "\"");
        }
    }

    public Object deserialize(XMLName xMLName, Attribute attribute, DeserializationContext deserializationContext) throws DeserializationException {
        if (deserializationContext.isValidateNames()) {
            this.validateNames(xMLName, attribute.getName(), deserializationContext);
        }
        String string = this.normalizeWhitespace(attribute.getValue());
        return this.getObjectFromContent(string, deserializationContext);
    }

    private String normalizeWhitespace(String string) {
        WhitespaceFacetType whitespaceFacetType = this.getWhitespaceBehavior();
        if (WhitespaceFacetType.COLLAPSE == whitespaceFacetType) {
            string = SchemaUtil.collapse(string);
        } else if (WhitespaceFacetType.REPLACE == whitespaceFacetType) {
            string = SchemaUtil.replace(string);
        }
        return string;
    }

    public Object processContent(XMLInputStream xMLInputStream, DeserializationContext deserializationContext) throws DeserializationException, XMLStreamException {
        return this.processContent(XSDSimpleTypeDeserializer.getCharacterData(xMLInputStream), deserializationContext);
    }

    private Object processContent(CharacterData characterData, DeserializationContext deserializationContext) throws DeserializationException {
        if (characterData == null || !characterData.hasContent()) {
            return this.getObjectFromNoContent();
        }
        String string = this.normalizeWhitespace(characterData.getContent());
        return this.getObjectFromContent(string, deserializationContext);
    }

    private static CharacterData getCharacterData(XMLInputStream xMLInputStream) throws XMLStreamException {
        XMLEvent xMLEvent;
        if (xMLInputStream.skip(84) && ((xMLEvent = xMLInputStream.next()).isCharacterData() || xMLEvent.isSpace())) {
            CharacterData characterData = (CharacterData)xMLEvent;
            if (xMLInputStream.skip(84)) {
                XMLEvent xMLEvent2 = xMLInputStream.next();
                if (xMLEvent2.isEndElement()) {
                    return characterData;
                }
                CharacterData characterData2 = (CharacterData)xMLEvent2;
                StringBuffer stringBuffer = new StringBuffer();
                if (characterData.hasContent()) {
                    stringBuffer.append(characterData.getContent());
                }
                if (characterData2.hasContent()) {
                    stringBuffer.append(characterData2.getContent());
                }
                while (xMLInputStream.skip(84)) {
                    XMLEvent xMLEvent3 = xMLInputStream.next();
                    if (xMLEvent3.isEndElement()) {
                        if (stringBuffer.length() == 0) {
                            return null;
                        }
                        return ElementFactory.createCharacterData(stringBuffer.toString());
                    }
                    CharacterData characterData3 = (CharacterData)xMLEvent3;
                    if (!characterData3.hasContent()) continue;
                    stringBuffer.append(characterData3.getContent());
                }
            }
        }
        return null;
    }

    protected void gatherContents(Object object, ObjectRefTable.Entry entry, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException {
        throw new AssertionError("not used");
    }

    protected void writeContents(Object object, ObjectRefTable.Entry entry, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException, XMLStreamException {
        throw new AssertionError("not used");
    }

    protected static void checkTotalDigitsFacet(Number number, long l) throws DeserializationException {
        FacetUtils.checkTotalDigitsFacet(number, l);
    }

    protected static void checkFractionDigitsFacet(BigDecimal bigDecimal, long l) throws DeserializationException {
        FacetUtils.checkFractionDigitsFacet(bigDecimal, l);
    }

    protected static void checkLengthFacet(String string, long l) throws DeserializationException {
        FacetUtils.checkLengthFacet(string, l);
    }

    protected static void checkMinLengthFacet(String string, long l) throws DeserializationException {
        FacetUtils.checkMinLengthFacet(string, l);
    }

    protected static void checkMaxLengthFacet(String string, long l) throws DeserializationException {
        FacetUtils.checkMaxLengthFacet(string, l);
    }

    protected static void checkMaxInclusiveFacet(Number number, Number number2) throws DeserializationException {
        FacetUtils.checkMaxInclusiveFacet(number, number2);
    }

    protected static void checkMaxInclusiveFacet(long l, long l2) throws DeserializationException {
        FacetUtils.checkMaxInclusiveFacet(l, l2);
    }

    protected static void checkMaxInclusiveFacet(double d, double d2) throws DeserializationException {
        FacetUtils.checkMaxInclusiveFacet(d, d2);
    }

    protected static void checkMaxExclusiveFacet(Number number, Number number2) throws DeserializationException {
        FacetUtils.checkMaxExclusiveFacet(number, number2);
    }

    protected static void checkMaxExclusiveFacet(long l, long l2) throws DeserializationException {
        FacetUtils.checkMaxExclusiveFacet(l, l2);
    }

    protected static void checkMaxExclusiveFacet(double d, double d2) throws DeserializationException {
        FacetUtils.checkMaxExclusiveFacet(d, d2);
    }

    protected static void checkMinInclusiveFacet(Number number, Number number2) throws DeserializationException {
        FacetUtils.checkMinInclusiveFacet(number, number2);
    }

    protected static void checkMinInclusiveFacet(long l, long l2) throws DeserializationException {
        FacetUtils.checkMinInclusiveFacet(l, l2);
    }

    protected static void checkMinInclusiveFacet(double d, double d2) throws DeserializationException {
        FacetUtils.checkMinInclusiveFacet(d, d2);
    }

    protected static void checkMinExclusiveFacet(Number number, Number number2) throws DeserializationException {
        FacetUtils.checkMinExclusiveFacet(number, number2);
    }

    protected static void checkMinExclusiveFacet(long l, long l2) throws DeserializationException {
        FacetUtils.checkMinExclusiveFacet(l, l2);
    }

    protected static void checkMinExclusiveFacet(double d, double d2) throws DeserializationException {
        FacetUtils.checkMinExclusiveFacet(d, d2);
    }
}

