/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.internal.builtin;

import javax.xml.namespace.QName;
import weblogic.utils.AssertionError;
import weblogic.xml.schema.binding.SerializationContext;
import weblogic.xml.schema.binding.SerializationException;
import weblogic.xml.schema.binding.internal.builtin.XSDSimpleTypeSerializer;
import weblogic.xml.schema.binding.util.runtime.ObjectRefTable;
import weblogic.xml.schema.model.ExpName;
import weblogic.xml.schema.model.SchemaTypes;
import weblogic.xml.schema.types.XSDQName;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class XSDQNameSerializer
extends XSDSimpleTypeSerializer {
    static /* synthetic */ Class class$javax$xml$namespace$QName;

    protected XMLName getXmlType() {
        return SchemaTypes.XSD_QNAME_ENAME;
    }

    public void serialize(Object object, XMLName xMLName, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException {
        if (!serializationContext.isInAttribute()) {
            super.serialize(object, xMLName, xMLOutputStream, serializationContext);
            return;
        }
        if (object == null) {
            return;
        }
        ExpName expName = new ExpName(xMLName);
        String string = null;
        try {
            string = XSDQNameSerializer.fillPrefixDeclareNamespace(expName, xMLOutputStream, serializationContext);
            String string2 = XSDQName.getXml(expName.getNamespaceUri(), expName.getLocalName(), expName.getPrefix());
            Attribute attribute = ElementFactory.createAttribute(xMLName, string2);
            xMLOutputStream.add(attribute);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SerializationException("stream error", xMLStreamException);
        }
        finally {
            XSDQNameSerializer.removePrefixFromMap(string, serializationContext);
        }
    }

    protected void writeContents(Object object, ObjectRefTable.Entry entry, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException, XMLStreamException {
        Object object2;
        if (!(object instanceof QName)) {
            String string = "expected object of type " + (class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = XSDQNameSerializer.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName).getName() + " not " + object.getClass().getName();
            throw new SerializationException(string);
        }
        QName qName = (QName)object;
        String string = qName.getNamespaceURI();
        String string2 = null;
        if (string != null && string.length() > 0 && (string2 = serializationContext.getPrefixForUri(string)) == null) {
            string2 = serializationContext.getNextRandomPrefix();
            object2 = ElementFactory.createNamespaceAttribute(string2, string);
            xMLOutputStream.add((Attribute)object2);
        }
        object2 = XSDQName.getXml(qName, string2);
        xMLOutputStream.add(ElementFactory.createCharacterData((String)object2));
    }

    protected String getContentFromObject(Object object, SerializationContext serializationContext) throws SerializationException {
        throw new AssertionError("not used");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

