/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.internal.builtin;

import java.util.Map;
import javax.xml.namespace.QName;
import weblogic.utils.AssertionError;
import weblogic.xml.schema.binding.DeserializationContext;
import weblogic.xml.schema.binding.DeserializationException;
import weblogic.xml.schema.binding.internal.builtin.XSDSimpleTypeDeserializer;
import weblogic.xml.schema.types.XSDQName;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.CharacterData;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLStreamException;

public class XSDQNameDeserializer
extends XSDSimpleTypeDeserializer {
    private static final boolean DEBUG = false;
    private static final boolean VERBOSE = false;

    protected Object getObjectFromContent(String string, DeserializationContext deserializationContext) throws DeserializationException {
        throw new AssertionError("not used");
    }

    public Object deserialize(XMLName xMLName, XMLInputStream xMLInputStream, DeserializationContext deserializationContext) throws DeserializationException {
        try {
            if (xMLInputStream.skip(2)) {
                QName qName = null;
                StartElement startElement = (StartElement)xMLInputStream.next();
                String string = XSDQNameDeserializer.checkForRef(startElement);
                if (string != null) {
                    return XSDQNameDeserializer.deserializeReferredObject(string, this, xMLName, xMLInputStream, deserializationContext);
                }
                if (deserializationContext.isValidateNames()) {
                    this.validateNames(xMLName, startElement.getName(), deserializationContext);
                }
                if (xMLInputStream.skip(20)) {
                    XMLEvent xMLEvent = xMLInputStream.next();
                    if (xMLEvent.isCharacterData()) {
                        QName qName2;
                        Object object;
                        CharacterData characterData = (CharacterData)xMLEvent;
                        String string2 = characterData.getContent();
                        Map map = startElement.getNamespaceMap();
                        if (map == null) {
                            object = XSDQName.getPrefixFromQName(string2);
                            String string3 = startElement.getNamespaceUri((String)object);
                            qName2 = XSDQName.convertXml(string2, string3, true);
                        } else {
                            qName2 = XSDQName.convertXml(string2, map, true);
                        }
                        qName = qName2;
                        if (xMLInputStream.skip(4)) {
                            object = xMLInputStream.next();
                        }
                    } else {
                        return this.getObjectFromNoContent();
                    }
                }
                return qName;
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DeserializationException(xMLStreamException.getMessage(), xMLStreamException);
        }
        throw new DeserializationException("failed to find start element");
    }

    public Object deserialize(XMLName xMLName, Attribute attribute, DeserializationContext deserializationContext) throws DeserializationException {
        return XSDQName.convertXml(attribute.getValue(), deserializationContext.getCurrentPrefixToNamespaceMap());
    }
}

