/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.internal.builtin;

import weblogic.utils.AssertionError;
import weblogic.xml.schema.binding.CodecBase;
import weblogic.xml.schema.binding.DeserializationContext;
import weblogic.xml.schema.binding.DeserializationException;
import weblogic.xml.schema.binding.Deserializer;
import weblogic.xml.schema.binding.RuntimeUtils;
import weblogic.xml.schema.binding.SchemaContext;
import weblogic.xml.schema.binding.SchemaContextFactory;
import weblogic.xml.schema.binding.SerializationContext;
import weblogic.xml.schema.binding.SerializationException;
import weblogic.xml.schema.binding.Serializer;
import weblogic.xml.schema.binding.SoapArrayCodecBase;
import weblogic.xml.schema.binding.internal.SoapTypes;
import weblogic.xml.schema.binding.util.runtime.ObjectRefTable;
import weblogic.xml.schema.binding.util.runtime.PropertyInfo;
import weblogic.xml.schema.model.SchemaTypes;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public final class XSDAnyCodec
extends CodecBase {
    private static final SchemaContext SOAP_ELEM_CTX = SchemaContextFactory.newInstance().createSchemaContext((class$javax$xml$soap$SOAPElement == null ? (class$javax$xml$soap$SOAPElement = XSDAnyCodec.class$("javax.xml.soap.SOAPElement")) : class$javax$xml$soap$SOAPElement).getName());
    private static final Deserializer genericSoapArrayDeser = new SoapArrayCodecBase();
    static /* synthetic */ Class class$javax$xml$soap$SOAPElement;
    static /* synthetic */ Class class$java$lang$Object;

    public int getPropertyCount() {
        return 0;
    }

    public PropertyInfo getPropertyInfo(int n) {
        throw new IndexOutOfBoundsException("invalid index " + n);
    }

    protected XMLName getXmlType() {
        return SchemaTypes.XSD_ANY_TYPE_ENAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(Object object, XMLName xMLName, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException {
        if (object == null) {
            super.serialize(null, xMLName, xMLOutputStream, serializationContext);
            return;
        }
        if ((class$java$lang$Object == null ? (class$java$lang$Object = XSDAnyCodec.class$("java.lang.Object")) : class$java$lang$Object).equals(object.getClass())) {
            object = object.toString();
        }
        Serializer serializer = RuntimeUtils.lookup_serializer(object.getClass(), serializationContext);
        boolean bl = serializationContext.isIncludeXsiType();
        try {
            serializationContext.setIncludeXsiType(true);
            serializer.serialize(object, xMLName, xMLOutputStream, serializationContext);
        }
        finally {
            serializationContext.setIncludeXsiType(bl);
        }
    }

    public Object deserialize(XMLName xMLName, XMLInputStream xMLInputStream, DeserializationContext deserializationContext) throws DeserializationException {
        try {
            if (xMLInputStream.skip(2)) {
                Deserializer deserializer;
                StartElement startElement = (StartElement)xMLInputStream.peek();
                String string = XSDAnyCodec.checkForRef(startElement);
                if (string != null) {
                    return XSDAnyCodec.deserializeReferredObject(string, this, xMLName, xMLInputStream, deserializationContext);
                }
                boolean bl = RuntimeUtils.checkForXsiNil(startElement);
                if (bl) {
                    xMLInputStream.skipElement();
                    return null;
                }
                XMLName xMLName2 = RuntimeUtils.getXsiType(startElement);
                if (xMLName2 != null) {
                    deserializer = RuntimeUtils.lookup_deserializer(xMLName2, deserializationContext);
                } else {
                    if (XSDAnyCodec.hasSoapArrayType(startElement)) {
                        return genericSoapArrayDeser.deserialize(xMLName, xMLInputStream, deserializationContext);
                    }
                    deserializer = RuntimeUtils.lookup_deserializer(SchemaTypes.XSD_ANY_TYPE_ENAME, SOAP_ELEM_CTX, deserializationContext);
                }
                return deserializer.deserialize(xMLName, xMLInputStream, deserializationContext);
            }
            throw new DeserializationException("unexpected end of xml stream");
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DeserializationException("stream error", xMLStreamException);
        }
    }

    private static boolean hasSoapArrayType(StartElement startElement) {
        Attribute attribute = startElement.getAttributeByName(SoapTypes.SoapArrayType);
        if (attribute == null) {
            return false;
        }
        String string = attribute.getValue();
        if (string == null) {
            return false;
        }
        return string.length() > 0;
    }

    public Object deserialize(XMLName xMLName, Attribute attribute, DeserializationContext deserializationContext) throws DeserializationException {
        throw new AssertionError("UNIMP");
    }

    protected void gatherContents(Object object, ObjectRefTable.Entry entry, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException {
        throw new AssertionError("not used");
    }

    protected void writeContents(Object object, ObjectRefTable.Entry entry, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException, XMLStreamException {
        throw new AssertionError("not used");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

