/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.internal.builtin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import weblogic.xml.schema.binding.DeserializationContext;
import weblogic.xml.schema.binding.DeserializationException;
import weblogic.xml.schema.binding.Deserializer;
import weblogic.xml.schema.binding.SerializationContext;
import weblogic.xml.schema.binding.SerializationException;
import weblogic.xml.schema.binding.Serializer;
import weblogic.xml.schema.binding.SoapArrayCodecBase;
import weblogic.xml.schema.binding.internal.SoapArrayDescriptor;
import weblogic.xml.schema.binding.internal.builtin.XSDAnyCodec;
import weblogic.xml.schema.model.SchemaTypes;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class JavaUtilCollectionCodec
extends SoapArrayCodecBase {
    private static final boolean DEBUG = false;
    private static final XMLName ITEM = SchemaTypes.XSD_ANY_TYPE_ENAME;
    private static final XSDAnyCodec anyCodec = new XSDAnyCodec();
    private static final XMLName XML_TYPE = ElementFactory.createXMLName("java:language_builtins.util", "Collection");
    private static final int[] ranks = new int[0];

    protected XMLName getXmlType() {
        return XML_TYPE;
    }

    protected Serializer getComponentSerializer(Object object, SerializationContext serializationContext) throws SerializationException {
        return anyCodec;
    }

    protected Deserializer getComponentDeserializer(SoapArrayDescriptor soapArrayDescriptor, DeserializationContext deserializationContext) throws DeserializationException {
        return anyCodec;
    }

    protected SoapArrayDescriptor createArrayDescriptor(Object object, SerializationContext serializationContext) throws SerializationException {
        Collection collection = (Collection)object;
        int n = collection.size();
        int[] nArray = new int[]{n};
        return new SoapArrayDescriptor(anyCodec.getXmlType(), ranks, nArray);
    }

    protected void serializeOneDimArray(Object object, Serializer serializer, XMLName xMLName, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException {
        Collection collection = (Collection)object;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            serializer.serialize(iterator.next(), xMLName, xMLOutputStream, serializationContext);
        }
    }

    protected XMLName getComponentXMLName(Object object, SerializationContext serializationContext) throws SerializationException {
        return ITEM;
    }

    protected boolean isMultiDimensionalSoapArray() {
        return false;
    }

    protected Object createAndPopulateArray(SoapArrayCodecBase.EntryIterator entryIterator, SoapArrayDescriptor soapArrayDescriptor, String string, DeserializationContext deserializationContext) throws XMLStreamException, DeserializationException {
        Object object;
        int n = 8;
        if (soapArrayDescriptor != null && (object = soapArrayDescriptor.getArraySizes()) != null) {
            n = object[0];
        }
        object = this.createCollectionObject(n);
        if (string != null) {
            deserializationContext.storeObjectWithReference(string, object);
        }
        while (entryIterator.hasNext()) {
            Object object2 = entryIterator.next();
            object.add(object2);
        }
        return object;
    }

    protected Collection createCollectionObject(int n) {
        return new ArrayList(n);
    }
}

