/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.internal.builtin;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import weblogic.xml.jaxp.WebLogicDocumentBuilderFactory;
import weblogic.xml.schema.binding.DeserializationContext;
import weblogic.xml.schema.binding.DeserializationException;
import weblogic.xml.schema.binding.EncodingStyle;
import weblogic.xml.schema.binding.JAXRPCCodecBase;
import weblogic.xml.schema.binding.RuntimeUtils;
import weblogic.xml.schema.binding.SerializationContext;
import weblogic.xml.schema.binding.SerializationException;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLOutputStreamFactory;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.util.XMLSubStreamBase;

public class DocumentCodec
extends JAXRPCCodecBase {
    public void serialize(Object object, XMLName xMLName, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException {
        try {
            EncodingStyle encodingStyle;
            XMLEvent xMLEvent;
            if (object == null) {
                RuntimeUtils.serializeNullElement(xMLName, xMLOutputStream, serializationContext);
                return;
            }
            XMLInputStream xMLInputStream = XMLInputStreamFactory.newInstance().newInputStream((Node)object);
            while ((xMLEvent = xMLInputStream.peek()).isStartDocument() || xMLEvent.isProcessingInstruction()) {
                xMLInputStream.skip();
            }
            boolean bl = false;
            if (serializationContext != null && (encodingStyle = serializationContext.getEncodingStyle()) != null && "literal".equals(encodingStyle.getEncodingName())) {
                bl = true;
            }
            if (!bl) {
                xMLOutputStream.add(ElementFactory.createStartElement(xMLName));
            }
            xMLOutputStream.add(xMLInputStream);
            if (!bl) {
                xMLOutputStream.add(ElementFactory.createEndElement(xMLName));
            }
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
            throw new SerializationException("Failed to serialize Document due to the following error " + xMLStreamException);
        }
    }

    public Object deserialize(XMLName xMLName, XMLInputStream xMLInputStream, DeserializationContext deserializationContext) throws DeserializationException {
        Document document;
        try {
            document = this.getDocument();
            XMLOutputStream xMLOutputStream = XMLOutputStreamFactory.newInstance().newOutputStream(document);
            xMLInputStream.skip(2);
            this.process(null, (XMLInputStream)new XMLSubStreamBase(xMLInputStream), xMLOutputStream);
            xMLInputStream.skip(4);
            xMLInputStream.next();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DeserializationException("Failed to deserialize Document.");
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DeserializationException("Failed to deserialize Document.");
        }
        return document;
    }

    public Object deserialize(XMLName xMLName, Attribute attribute, DeserializationContext deserializationContext) throws DeserializationException {
        throw new DeserializationException("Not supported.");
    }

    protected Document getDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = this.isServer() ? new WebLogicDocumentBuilderFactory() : DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        return documentBuilderFactory.newDocumentBuilder().newDocument();
    }

    protected boolean isServer() {
        boolean bl = false;
        try {
            Class<?> clazz = Class.forName("weblogic.kernel.Kernel");
            Method method = clazz.getMethod("isServer", new Class[0]);
            bl = (Boolean)method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return bl;
    }

    protected void process(XMLName xMLName, XMLInputStream xMLInputStream, XMLOutputStream xMLOutputStream) throws XMLStreamException, ParserConfigurationException {
        XMLName xMLName2 = xMLName;
        int n = 0;
        while (xMLInputStream.hasNext()) {
            XMLEvent xMLEvent = xMLInputStream.next();
            if (xMLName2 == null) {
                xMLName2 = xMLEvent.getName();
            }
            XMLName xMLName3 = xMLEvent.getName();
            if ((xMLEvent.isStartElement() || xMLEvent.isEndElement()) && xMLName3.getLocalName().equals(xMLName2.getLocalName())) {
                String string = xMLName2.getNamespaceUri();
                String string2 = xMLName3.getNamespaceUri();
                if ((string != null || string2 != null) && (string == null || !string.equals(string2))) continue;
                if (xMLEvent.isStartElement()) {
                    xMLOutputStream.add(xMLEvent);
                    ++n;
                    continue;
                }
                if (n == 1) {
                    xMLOutputStream.add(xMLEvent);
                    break;
                }
                xMLOutputStream.add(xMLEvent);
                --n;
                continue;
            }
            xMLOutputStream.add(xMLEvent);
        }
        xMLOutputStream.flush();
    }
}

