/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.internal;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weblogic.utils.AssertionError;
import weblogic.xml.schema.binding.BindingException;
import weblogic.xml.schema.binding.SchemaContext;
import weblogic.xml.schema.binding.TypeDescriptor;
import weblogic.xml.schema.binding.TypeMapping;
import weblogic.xml.schema.binding.internal.TypeMappingBase;
import weblogic.xml.schema.binding.internal.TypeMappingBuilderBase;
import weblogic.xml.schema.binding.internal.XSDTypeMapping;
import weblogic.xml.schema.binding.internal.codegen.Compiler;
import weblogic.xml.schema.model.ExpName;
import weblogic.xml.schema.model.SchemaTypes;
import weblogic.xml.schema.model.XSDException;
import weblogic.xml.schema.model.XSDSchema;
import weblogic.xml.schema.model.util.SchemaMap;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;

public class XSDTypeMappingBuilder
extends TypeMappingBuilderBase {
    public static final Map builtinTypes = Collections.unmodifiableMap(XSDTypeMappingBuilder.createBuiltinTypesMap());
    private Set classesInspected = new HashSet();

    protected TypeMapping initTypeMapping() {
        try {
            TypeMappingBase typeMappingBase = new TypeMappingBase();
            typeMappingBase.setParent(XSDTypeMapping.createXSDMapping());
            return typeMappingBase;
        }
        catch (BindingException bindingException) {
            throw new AssertionError("INTERNAL ERROR", bindingException);
        }
    }

    XSDTypeMappingBuilder(XMLInputStream xMLInputStream) throws IOException {
        super(xMLInputStream);
    }

    public XSDTypeMappingBuilder() {
    }

    protected void mapClass(SchemaMap schemaMap, Class[] classArray, XMLName[] xMLNameArray, List list, boolean bl) throws BindingException {
        Compiler compiler = new Compiler(this.getOpts(), this.getTypeMapping(), this.getBindingConfiguration());
        compiler.compile(schemaMap, classArray, xMLNameArray, bl);
        this.classesInspected.addAll(compiler.getClassesInspected());
    }

    protected void mapClass(SchemaMap schemaMap, Class[] classArray, List list, boolean bl) throws BindingException {
        this.mapClass(schemaMap, classArray, null, list, bl);
    }

    protected void mapSchemaType(XMLName xMLName, XSDSchema xSDSchema, SchemaContext schemaContext, boolean bl) throws BindingException {
        try {
            xSDSchema.resolveInclusions();
        }
        catch (XSDException xSDException) {
            throw new BindingException("schema error", xSDException);
        }
        Compiler compiler = new Compiler(this.getOpts(), this.getTypeMapping(), this.getBindingConfiguration());
        compiler.compile(xMLName, xSDSchema, bl);
    }

    protected void addAllTypesInSchemas(SchemaMap schemaMap) throws BindingException {
        Compiler compiler = new Compiler(this.getOpts(), this.getTypeMapping(), this.getBindingConfiguration());
        compiler.compile(schemaMap, true);
    }

    protected void addTypesInSchemas(SchemaMap schemaMap, TypeDescriptor[] typeDescriptorArray) throws BindingException {
        Compiler compiler = new Compiler(this.getOpts(), this.getTypeMapping(), this.getBindingConfiguration());
        compiler.compile(schemaMap, typeDescriptorArray, true);
    }

    public Iterator getReferredClasses() {
        return Collections.unmodifiableSet(this.classesInspected).iterator();
    }

    private static Map createBuiltinTypesMap() {
        HashMap<ExpName, String> hashMap = new HashMap<ExpName, String>();
        hashMap.put(SchemaTypes.XSD_BASE64BINARY_ENAME, "SchemaTypes.XSD_BASE64BINARY_ENAME");
        hashMap.put(SchemaTypes.XSD_BOOLEAN_ENAME, "SchemaTypes.XSD_BOOLEAN_ENAME");
        hashMap.put(SchemaTypes.XSD_DATETIME_ENAME, "SchemaTypes.XSD_DATETIME_ENAME");
        hashMap.put(SchemaTypes.XSD_DATE_ENAME, "SchemaTypes.XSD_DATE_ENAME");
        hashMap.put(SchemaTypes.XSD_DECIMAL_ENAME, "SchemaTypes.XSD_DECIMAL_ENAME");
        hashMap.put(SchemaTypes.XSD_DOUBLE_ENAME, "SchemaTypes.XSD_DOUBLE_ENAME");
        hashMap.put(SchemaTypes.XSD_DURATION_ENAME, "SchemaTypes.XSD_DURATION_ENAME");
        hashMap.put(SchemaTypes.XSD_FLOAT_ENAME, "SchemaTypes.XSD_FLOAT_ENAME");
        hashMap.put(SchemaTypes.XSD_GDAY_ENAME, "SchemaTypes.XSD_GDAY_ENAME");
        hashMap.put(SchemaTypes.XSD_GMONTHDAY_ENAME, "SchemaTypes.XSD_GMONTHDAY_ENAME");
        hashMap.put(SchemaTypes.XSD_GMONTH_ENAME, "SchemaTypes.XSD_GMONTH_ENAME");
        hashMap.put(SchemaTypes.XSD_GYEARMONTH_ENAME, "SchemaTypes.XSD_GYEARMONTH_ENAME");
        hashMap.put(SchemaTypes.XSD_GYEAR_ENAME, "SchemaTypes.XSD_GYEAR_ENAME");
        hashMap.put(SchemaTypes.XSD_HEXBINARY_ENAME, "SchemaTypes.XSD_HEXBINARY_ENAME");
        hashMap.put(SchemaTypes.XSD_NOTATION_ENAME, "SchemaTypes.XSD_NOTATION_ENAME");
        hashMap.put(SchemaTypes.XSD_QNAME_ENAME, "SchemaTypes.XSD_QNAME_ENAME");
        hashMap.put(SchemaTypes.XSD_STRING_ENAME, "SchemaTypes.XSD_STRING_ENAME");
        hashMap.put(SchemaTypes.XSD_TIME_ENAME, "SchemaTypes.XSD_TIME_ENAME");
        hashMap.put(SchemaTypes.XSD_NORMALIZED_STRING_ENAME, "SchemaTypes.XSD_NORMALIZED_STRING_ENAME");
        hashMap.put(SchemaTypes.XSD_TOKEN_ENAME, "SchemaTypes.XSD_TOKEN_ENAME");
        hashMap.put(SchemaTypes.XSD_LANGUAGE_ENAME, "SchemaTypes.XSD_LANGUAGE_ENAME");
        hashMap.put(SchemaTypes.XSD_NMTOKEN_ENAME, "SchemaTypes.XSD_NMTOKEN_ENAME");
        hashMap.put(SchemaTypes.XSD_NMTOKENS_ENAME, "SchemaTypes.XSD_NMTOKENS_ENAME");
        hashMap.put(SchemaTypes.XSD_NAME_ENAME, "SchemaTypes.XSD_NAME_ENAME");
        hashMap.put(SchemaTypes.XSD_NCNAME_ENAME, "SchemaTypes.XSD_NCNAME_ENAME");
        hashMap.put(SchemaTypes.XSD_ID_ENAME, "SchemaTypes.XSD_ID_ENAME");
        hashMap.put(SchemaTypes.XSD_IDREF_ENAME, "SchemaTypes.XSD_IDREF_ENAME");
        hashMap.put(SchemaTypes.XSD_IDREFS_ENAME, "SchemaTypes.XSD_IDREFS_ENAME");
        hashMap.put(SchemaTypes.XSD_ENTITY_ENAME, "SchemaTypes.XSD_ENTITY_ENAME");
        hashMap.put(SchemaTypes.XSD_ENTITIES_ENAME, "SchemaTypes.XSD_ENTITIES_ENAME");
        hashMap.put(SchemaTypes.XSD_INTEGER_ENAME, "SchemaTypes.XSD_INTEGER_ENAME");
        hashMap.put(SchemaTypes.XSD_NONPOSITIVEINTEGER_ENAME, "SchemaTypes.XSD_NONPOSITIVEINTEGER_ENAME");
        hashMap.put(SchemaTypes.XSD_NEGATIVEINTEGER_ENAME, "SchemaTypes.XSD_NEGATIVEINTEGER_ENAME");
        hashMap.put(SchemaTypes.XSD_LONG_ENAME, "SchemaTypes.XSD_LONG_ENAME");
        hashMap.put(SchemaTypes.XSD_INT_ENAME, "SchemaTypes.XSD_INT_ENAME");
        hashMap.put(SchemaTypes.XSD_SHORT_ENAME, "SchemaTypes.XSD_SHORT_ENAME");
        hashMap.put(SchemaTypes.XSD_BYTE_ENAME, "SchemaTypes.XSD_BYTE_ENAME");
        hashMap.put(SchemaTypes.XSD_NONNEGATIVEINTEGER_ENAME, "SchemaTypes.XSD_NONNEGATIVEINTEGER_ENAME");
        hashMap.put(SchemaTypes.XSD_UNSIGNEDLONG_ENAME, "SchemaTypes.XSD_UNSIGNEDLONG_ENAME");
        hashMap.put(SchemaTypes.XSD_UNSIGNEDINT_ENAME, "SchemaTypes.XSD_UNSIGNEDINT_ENAME");
        hashMap.put(SchemaTypes.XSD_UNSIGNEDSHORT_ENAME, "SchemaTypes.XSD_UNSIGNEDSHORT_ENAME");
        hashMap.put(SchemaTypes.XSD_UNSIGNEDBYTE_ENAME, "SchemaTypes.XSD_UNSIGNEDBYTE_ENAME");
        hashMap.put(SchemaTypes.XSD_POSITIVEINTEGER_ENAME, "SchemaTypes.XSD_POSITIVEINTEGER_ENAME");
        return hashMap;
    }
}

