/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weblogic.utils.Debug;
import weblogic.utils.Getopt2;
import weblogic.xml.schema.binding.BindingConfiguration;
import weblogic.xml.schema.binding.BindingException;
import weblogic.xml.schema.binding.ClassContext;
import weblogic.xml.schema.binding.SchemaContext;
import weblogic.xml.schema.binding.TypeDescriptor;
import weblogic.xml.schema.binding.TypeMapping;
import weblogic.xml.schema.binding.TypeMappingBuilder;
import weblogic.xml.schema.binding.TypeMappingEntry;
import weblogic.xml.schema.binding.internal.BindingConfigurationBase;
import weblogic.xml.schema.binding.internal.NameUtil;
import weblogic.xml.schema.binding.internal.SchemaUtil;
import weblogic.xml.schema.binding.internal.TypeMappingBuilderBase;
import weblogic.xml.schema.binding.internal.TypedClassContext;
import weblogic.xml.schema.binding.internal.TypedSchemaContext;
import weblogic.xml.schema.binding.internal.codegen.XSDGenerator;
import weblogic.xml.schema.model.XSDException;
import weblogic.xml.schema.model.XSDSchema;
import weblogic.xml.schema.model.parser.ParserUtils;
import weblogic.xml.schema.model.parser.XSDParser;
import weblogic.xml.schema.model.parser.XSDParserFactory;
import weblogic.xml.schema.model.util.SchemaMap;
import weblogic.xml.schema.model.writer.XSDWriter;
import weblogic.xml.schema.model.writer.XSDWriterFactory;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public abstract class TypeMappingBuilderBase
implements TypeMappingBuilder {
    private static final boolean DEBUG = false;
    private static final boolean VERBOSE = false;
    private BindingConfiguration bindingConfig = new BindingConfigurationBase();
    private SchemaMap registeredSchemas = new SchemaMap();
    private SchemaMap generatedSchemas = new SchemaMap();
    private TypeMapping typeMapping = null;
    private List unprocessedSchemaEntries = new ArrayList();
    private List unprocessedClassEntries = new ArrayList();
    private Getopt2 opts = new Getopt2();

    public Getopt2 getOpts() {
        return this.opts;
    }

    public void setOpts(Getopt2 getopt2) {
        this.opts = getopt2;
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        this.typeMapping = typeMapping;
    }

    public TypeMappingBuilderBase() {
        this.typeMapping = this.initTypeMapping();
        Debug.assertion(this.typeMapping != null);
    }

    TypeMappingBuilderBase(XMLInputStream xMLInputStream) throws IOException {
        this();
        this.typeMapping.readXML(xMLInputStream);
        Debug.assertion(this.typeMapping != null);
    }

    protected abstract TypeMapping initTypeMapping();

    public boolean isEmpty() {
        return this.typeMapping.getEntries().length > 0;
    }

    public void setBindingConfiguration(BindingConfiguration bindingConfiguration) {
        this.bindingConfig = bindingConfiguration;
    }

    public BindingConfiguration getBindingConfiguration() {
        return this.bindingConfig;
    }

    public void addMapping(Class clazz, ClassContext classContext) throws BindingException {
        TypeMappingEntry typeMappingEntry = this.typeMapping.get(clazz, classContext);
        if (typeMappingEntry == null || this.overwriteExistingMappings()) {
            this.mapClass(this.generatedSchemas, clazz, this.unprocessedSchemaEntries, this.bindingConfig.isAutoCreateSerials());
        }
    }

    protected String mapNamespaceToPackage(XMLName xMLName, SchemaContext schemaContext) {
        return NameUtil.getPackageName(xMLName.getNamespaceUri());
    }

    protected String mapXMLTypeToClass(XMLName xMLName, SchemaContext schemaContext) {
        return NameUtil.getClassName(xMLName.getLocalName());
    }

    protected void mapClass(SchemaMap schemaMap, Class clazz, List list, boolean bl) throws BindingException {
        this.mapClass(schemaMap, new Class[]{clazz}, list, bl);
    }

    protected abstract void mapClass(SchemaMap var1, Class[] var2, List var3, boolean var4) throws BindingException;

    protected abstract void mapClass(SchemaMap var1, Class[] var2, XMLName[] var3, List var4, boolean var5) throws BindingException;

    protected abstract void mapSchemaType(XMLName var1, XSDSchema var2, SchemaContext var3, boolean var4) throws BindingException;

    public void addMapping(Class clazz) throws BindingException {
        this.addMapping(clazz, this.createDefaultClassContext(clazz));
    }

    public void addMapping(Class[] classArray) throws BindingException {
        this.mapClass(this.generatedSchemas, classArray, this.unprocessedSchemaEntries, this.bindingConfig.isAutoCreateSerials());
    }

    public void addMapping(Class[] classArray, XMLName[] xMLNameArray) throws BindingException {
        this.mapClass(this.generatedSchemas, classArray, xMLNameArray, this.unprocessedSchemaEntries, this.bindingConfig.isAutoCreateSerials());
    }

    protected ClassContext createDefaultClassContext(Class clazz) {
        XMLName xMLName = NameUtil.getXMLNameFromClass(clazz, this.bindingConfig);
        return new TypedClassContext(xMLName);
    }

    protected SchemaContext createDefaultSchemaContext(XMLName xMLName) {
        String string = NameUtil.getClassNameFromXMLName(xMLName);
        return new TypedSchemaContext(string);
    }

    public void addMapping(XMLName xMLName, XMLInputStream xMLInputStream, SchemaContext schemaContext) throws BindingException {
        throw new BindingException("UNIMP");
    }

    public void addMapping(XMLName xMLName, XMLInputStream xMLInputStream) throws BindingException {
        this.addMapping(xMLName, xMLInputStream, this.createDefaultSchemaContext(xMLName));
    }

    public void addMapping(XMLName xMLName) throws BindingException {
        this.addMapping(xMLName, this.createDefaultSchemaContext(xMLName));
    }

    public void addMapping(XMLName xMLName, SchemaContext schemaContext) throws BindingException {
        TypeMappingEntry typeMappingEntry = this.typeMapping.get(xMLName, schemaContext);
        if (typeMappingEntry == null || this.overwriteExistingMappings()) {
            XSDSchema xSDSchema = this.registeredSchemas.getSchema(xMLName.getNamespaceUri());
            if (xSDSchema == null) {
                throw new BindingException("Type " + xMLName + " not found in any registered schemas");
            }
            String string = this.mapNamespaceToPackage(xMLName, schemaContext);
            this.mapSchemaType(xMLName, xSDSchema, schemaContext, this.bindingConfig.isAutoCreateSerials());
        }
    }

    public void registerSchema(XMLInputStream xMLInputStream) throws BindingException {
        XSDSchema xSDSchema = SchemaUtil.createNewSchema(this.getBindingConfiguration());
        this.registerSchema(xSDSchema, xMLInputStream);
    }

    public void registerSchema(XSDSchema xSDSchema, XMLInputStream xMLInputStream) throws BindingException {
        try {
            XSDParser xSDParser = XSDParserFactory.newInstance().createXSDParser();
            xSDParser.parseSchema(xMLInputStream, xSDSchema);
            String string = xSDSchema.getTargetNamespace();
            this.registeredSchemas.addSchema(xSDSchema);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new BindingException("stream error", xMLStreamException);
        }
        catch (XSDException xSDException) {
            throw new BindingException("invalid schema", xSDException);
        }
    }

    public void processSchemas(XMLInputStream xMLInputStream, String string) throws BindingException {
        try {
            SchemaMap schemaMap = ParserUtils.parseMultipleSchema((XMLInputStream)xMLInputStream, (String)string);
            Iterator iterator = schemaMap.iterator();
            while (iterator.hasNext()) {
                XSDSchema xSDSchema = (XSDSchema)iterator.next();
                this.registeredSchemas.addSchema(xSDSchema);
            }
            this.addAllTypesInSchemas(schemaMap);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new BindingException("stream error", xMLStreamException);
        }
        catch (XSDException xSDException) {
            throw new BindingException("invalid schema", xSDException);
        }
    }

    public void processSchemaTypes(XMLInputStream xMLInputStream, String string, TypeDescriptor[] typeDescriptorArray) throws BindingException {
        try {
            SchemaMap schemaMap = ParserUtils.parseMultipleSchema((XMLInputStream)xMLInputStream, (String)string);
            Iterator iterator = schemaMap.iterator();
            while (iterator.hasNext()) {
                XSDSchema xSDSchema = (XSDSchema)iterator.next();
                this.registeredSchemas.addSchema(xSDSchema);
            }
            this.addTypesInSchemas(schemaMap, typeDescriptorArray);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new BindingException("stream error", xMLStreamException);
        }
        catch (XSDException xSDException) {
            throw new BindingException("invalid schema", xSDException);
        }
    }

    protected abstract void addAllTypesInSchemas(SchemaMap var1) throws BindingException;

    protected abstract void addTypesInSchemas(SchemaMap var1, TypeDescriptor[] var2) throws BindingException;

    public TypeMapping getTypeMapping() throws BindingException {
        return this.typeMapping;
    }

    public void fillMappings() throws BindingException {
        Iterator iterator = this.unprocessedSchemaEntries.iterator();
        while (iterator.hasNext()) {
            TypeMappingEntry typeMappingEntry = (TypeMappingEntry)iterator.next();
            Debug.say("TODO: deal with " + typeMappingEntry);
        }
    }

    public void addWrappedSchemaType(Class[] classArray, String[] stringArray, XMLName xMLName) throws BindingException {
        XMLName[] xMLNameArray = this.convertTypeNames(classArray);
        XSDGenerator xSDGenerator = new XSDGenerator(this.bindingConfig);
        xSDGenerator.addWrappedSchemaType(this.generatedSchemas, xMLNameArray, stringArray, xMLName);
    }

    private XMLName[] convertTypeNames(Class[] classArray) throws BindingException {
        if (this.typeMapping == null) {
            throw new BindingException("emtpy type mapping - nothing added yet!");
        }
        int n = classArray.length;
        XMLName[] xMLNameArray = new XMLName[n];
        for (int i = 0; i < n; ++i) {
            XMLName xMLName = this.typeMapping.getXMLNameFromClass(classArray[i]);
            if (xMLName == null) {
                throw new BindingException("no xml type found for java " + classArray[i]);
            }
            xMLNameArray[i] = xMLName;
        }
        return xMLNameArray;
    }

    public void writeGeneratedSchemas(XMLOutputStream xMLOutputStream) throws BindingException {
        try {
            XSDWriter xSDWriter = XSDWriterFactory.newInstance().createXSDWriter();
            xSDWriter.setTrustPrefixs(false);
            Set set = this.generatedSchemas.getMap().keySet();
            ArrayList arrayList = new ArrayList(set.size());
            arrayList.addAll(set);
            Collections.sort(arrayList, NullSafeStringComparator.INSTANCE);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                XSDSchema xSDSchema = this.generatedSchemas.getSchema(string);
                xSDSchema.sortElements();
                xSDSchema.sortTypes();
                xSDWriter.outputSchema(xMLOutputStream, xSDSchema);
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new BindingException("stream error", xMLStreamException);
        }
    }

    public void writeRegisteredSchemas(XMLOutputStream xMLOutputStream) throws BindingException {
        try {
            XSDWriter xSDWriter = XSDWriterFactory.newInstance().createXSDWriter();
            xSDWriter.setTrustPrefixs(false);
            Set set = this.registeredSchemas.getMap().entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                XSDSchema xSDSchema = (XSDSchema)entry.getValue();
                xSDSchema.sortElements();
                xSDSchema.sortTypes();
                xSDWriter.outputSchema(xMLOutputStream, xSDSchema);
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new BindingException("stream error", xMLStreamException);
        }
    }

    protected boolean overwriteExistingMappings() {
        return false;
    }

    protected List getUnprocessedSchemaEntries() {
        return this.unprocessedSchemaEntries;
    }
}

