/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding;

import weblogic.utils.AssertionError;
import weblogic.xml.schema.binding.CodecPropertyInfo;
import weblogic.xml.schema.binding.DeserializationContext;
import weblogic.xml.schema.binding.DeserializationException;
import weblogic.xml.schema.binding.Deserializer;
import weblogic.xml.schema.binding.EncodingStyle;
import weblogic.xml.schema.binding.JAXRPCCodecBase;
import weblogic.xml.schema.binding.RuntimeUtils;
import weblogic.xml.schema.binding.SerializationContext;
import weblogic.xml.schema.binding.SerializationException;
import weblogic.xml.schema.binding.SerializationPhase;
import weblogic.xml.schema.binding.internal.SoapTypes;
import weblogic.xml.schema.binding.util.runtime.ObjectRefTable;
import weblogic.xml.schema.model.ExpName;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.ReferenceResolver;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public abstract class CodecBase
extends JAXRPCCodecBase
implements CodecPropertyInfo {
    private static final boolean DEBUG = false;
    private static final boolean ASSERT = false;
    protected static final boolean QUALIFIED_TOP_LEVEL_ELE_ONLY = System.getProperty("weblogic.xml.schema.binding.qualifytoplevelelementonly", "true").equalsIgnoreCase("true");

    public Object deserialize(XMLName xMLName, Attribute attribute, DeserializationContext deserializationContext) throws DeserializationException {
        throw new AssertionError("UNIMP");
    }

    public Object deserialize(XMLName xMLName, XMLInputStream xMLInputStream, DeserializationContext deserializationContext) throws DeserializationException {
        throw new AssertionError("UNIMP");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object deserializeReferredObject(String string, Deserializer deserializer, XMLName xMLName, XMLInputStream xMLInputStream, DeserializationContext deserializationContext) throws DeserializationException, XMLStreamException {
        Object object = null;
        ReferenceResolver referenceResolver = xMLInputStream.getReferenceResolver();
        string = referenceResolver.getId(string);
        object = deserializationContext.getObjectFromReference(string);
        if (object != null) {
            object = deserializationContext.resolveNullObject(object);
        } else {
            boolean bl = deserializationContext.isValidateNames();
            deserializationContext.setValidateNames(false);
            try {
                object = deserializer.deserialize(xMLName, referenceResolver.resolve(string), deserializationContext);
            }
            finally {
                deserializationContext.setValidateNames(bl);
            }
            deserializationContext.storeObjectWithReference(string, object);
        }
        xMLInputStream.skip(4);
        XMLEvent xMLEvent = xMLInputStream.next();
        return object;
    }

    protected boolean isCompleteType() {
        return true;
    }

    protected abstract XMLName getXmlType();

    protected abstract void gatherContents(Object var1, ObjectRefTable.Entry var2, XMLOutputStream var3, SerializationContext var4) throws SerializationException;

    protected abstract void writeContents(Object var1, ObjectRefTable.Entry var2, XMLOutputStream var3, SerializationContext var4) throws SerializationException, XMLStreamException;

    public void serialize(Object object, XMLName xMLName, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException {
        this.serialize_internal(object, xMLName, xMLOutputStream, serializationContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void serialize_internal(Object object, XMLName xMLName, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException {
        if (object == null && (serializationContext.isInAttribute() || !this.isCompleteType())) {
            return;
        }
        EncodingStyle encodingStyle = serializationContext.getEncodingStyle();
        if (encodingStyle == EncodingStyle.SOAP) {
            SerializationPhase serializationPhase = serializationContext.getPhase();
            boolean bl = serializationContext.isInTopLevelElement();
            if (QUALIFIED_TOP_LEVEL_ELE_ONLY) {
                serializationContext.setQualifyElements(bl);
            }
            serializationContext.setInTopLevelElement(false);
            if (SerializationPhase.FILL == serializationPhase) {
                this.serializeFill(object, xMLName, xMLOutputStream, serializationContext);
                if (!bl) return;
                serializationContext.setPhase(SerializationPhase.INITIAL_WRITE);
                serializationContext.setQualifyElements(bl);
                this.serializeInitialWrite(object, xMLName, xMLOutputStream, serializationContext);
                return;
            } else if (SerializationPhase.INITIAL_WRITE == serializationPhase) {
                this.serializeInitialWrite(object, xMLName, xMLOutputStream, serializationContext);
                return;
            } else {
                if (SerializationPhase.FINAL_WRITE != serializationPhase) throw new AssertionError("unknown phase: " + serializationPhase);
                this.serializeFinalWrite(object, xMLName, xMLOutputStream, serializationContext, bl);
            }
            return;
        } else {
            if (encodingStyle != EncodingStyle.LITERAL) throw new AssertionError("unknown encodingStyle: " + encodingStyle);
            this.serializeLiteral(object, xMLName, xMLOutputStream, serializationContext);
        }
    }

    private void serializeFill(Object object, XMLName xMLName, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException {
        if (object == null) {
            return;
        }
        if (!this.isCompleteType()) {
            return;
        }
        ObjectRefTable objectRefTable = serializationContext.getObjectRefTable();
        ObjectRefTable.Entry entry = objectRefTable.get(object);
        if (entry != null) {
            entry.incrementRefCnt();
            return;
        }
        entry = new ObjectRefTable.Entry();
        entry.setSerializer(this);
        entry.setName(this.getXmlType());
        entry.incrementRefCnt();
        objectRefTable.put(object, entry);
        serializationContext.setInAttribute(false);
        this.gatherContents(object, entry, xMLOutputStream, serializationContext);
    }

    private void serializeLiteral(Object object, XMLName xMLName, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException {
        try {
            boolean bl;
            if (!this.isCompleteType()) {
                this.writeContents(object, null, xMLOutputStream, serializationContext);
                return;
            }
            String string = null;
            boolean bl2 = bl = xMLName.getNamespaceUri() != null;
            if (serializationContext.isQualifyElements() && bl) {
                ExpName expName = new ExpName(xMLName);
                string = CodecBase.fillPrefixAddToMap(expName, serializationContext);
                xMLName = expName;
            } else if (bl) {
                xMLName = ElementFactory.createXMLName(xMLName.getLocalName());
            }
            this.writeStartElement(xMLName, xMLOutputStream);
            if (string != null) {
                CodecBase.declareNamespace(xMLName, xMLOutputStream, serializationContext);
            }
            if (object == null) {
                xMLOutputStream.add(RuntimeUtils.NIL_ATT);
            } else {
                this.writeTypeAndContents(object, null, xMLOutputStream, serializationContext);
            }
            this.writeEndElement(xMLName, xMLOutputStream);
            CodecBase.removePrefixFromMap(string, serializationContext);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SerializationException("stream error", xMLStreamException);
        }
    }

    protected void writeStartElement(XMLName xMLName, XMLOutputStream xMLOutputStream) throws XMLStreamException {
        xMLOutputStream.add(ElementFactory.createStartElement(xMLName));
    }

    protected void writeEndElement(XMLName xMLName, XMLOutputStream xMLOutputStream) throws XMLStreamException {
        xMLOutputStream.add(ElementFactory.createEndElement(xMLName));
    }

    private void serializeInitialWrite(Object object, XMLName xMLName, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException {
        try {
            Object object2;
            boolean bl;
            if (!this.isCompleteType()) {
                this.writeContents(object, null, xMLOutputStream, serializationContext);
                return;
            }
            String string = null;
            boolean bl2 = bl = xMLName.getNamespaceUri() != null;
            if (serializationContext.isQualifyElements() && bl) {
                object2 = new ExpName(xMLName);
                string = CodecBase.fillPrefixAddToMap((ExpName)object2, serializationContext);
                xMLName = object2;
            } else if (bl) {
                xMLName = ElementFactory.createXMLName(xMLName.getLocalName());
            }
            this.writeStartElement(xMLName, xMLOutputStream);
            if (string != null) {
                CodecBase.declareNamespace(xMLName, xMLOutputStream, serializationContext);
            }
            if (object != null) {
                int n;
                object2 = serializationContext.getObjectRefTable().get(object);
                int n2 = n = object2 == null ? 1 : ((ObjectRefTable.Entry)object2).getRefCnt();
                if (n > 1) {
                    xMLOutputStream.add(CodecBase.createRefAttribute(((ObjectRefTable.Entry)object2).getXmlIdString()));
                } else {
                    this.writeTypeAndContents(object, (ObjectRefTable.Entry)object2, xMLOutputStream, serializationContext);
                }
            } else {
                xMLOutputStream.add(RuntimeUtils.NIL_ATT);
            }
            this.writeEndElement(xMLName, xMLOutputStream);
            CodecBase.removePrefixFromMap(string, serializationContext);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SerializationException("stream error", xMLStreamException);
        }
    }

    private void writeTypeAndContents(Object object, ObjectRefTable.Entry entry, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException, XMLStreamException {
        String string = null;
        if (this.isCompleteType() && this.writeXsiType(serializationContext)) {
            string = this.addXsiTypeAttribute(xMLOutputStream, serializationContext);
        }
        this.writeContents(object, entry, xMLOutputStream, serializationContext);
        CodecBase.removePrefixFromMap(string, serializationContext);
    }

    private void serializeFinalWrite(Object object, XMLName xMLName, XMLOutputStream xMLOutputStream, SerializationContext serializationContext, boolean bl) throws SerializationException {
        try {
            Object object2;
            boolean bl2;
            String string = null;
            boolean bl3 = bl2 = xMLName.getNamespaceUri() != null;
            if (serializationContext.isQualifyElements() && bl2) {
                object2 = new ExpName(xMLName);
                string = CodecBase.fillPrefixAddToMap((ExpName)object2, serializationContext);
                xMLName = object2;
            } else if (bl2) {
                xMLName = ElementFactory.createXMLName(xMLName.getLocalName());
            }
            this.writeStartElement(xMLName, xMLOutputStream);
            if (string != null) {
                CodecBase.declareNamespace(xMLName, xMLOutputStream, serializationContext);
            }
            if (object != null) {
                object2 = serializationContext.getObjectRefTable().get(object);
                int n = object2 == null ? 0 : ((ObjectRefTable.Entry)object2).getRefCnt();
                boolean bl4 = false;
                boolean bl5 = false;
                if (n > 1) {
                    if (bl) {
                        bl4 = true;
                    } else {
                        bl5 = true;
                    }
                }
                if (bl4) {
                    xMLOutputStream.add(CodecBase.createIdAttribute(((ObjectRefTable.Entry)object2).getXmlIdString()));
                }
                if (bl5) {
                    xMLOutputStream.add(CodecBase.createRefAttribute(((ObjectRefTable.Entry)object2).getXmlIdString()));
                } else {
                    this.writeTypeAndContents(object, (ObjectRefTable.Entry)object2, xMLOutputStream, serializationContext);
                }
            } else {
                xMLOutputStream.add(RuntimeUtils.NIL_ATT);
            }
            CodecBase.removePrefixFromMap(string, serializationContext);
            this.writeEndElement(xMLName, xMLOutputStream);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SerializationException("stream error", xMLStreamException);
        }
    }

    private String addXsiTypeAttribute(XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws XMLStreamException {
        Object object;
        Object object2 = this.getXmlType();
        String string = null;
        if (object2.getNamespaceUri() != null) {
            object = new ExpName((XMLName)object2);
            string = CodecBase.fillPrefixDeclareNamespace((ExpName)object, xMLOutputStream, serializationContext);
            object2 = object;
        }
        object = ElementFactory.createAttribute(RuntimeUtils.XSI_TYPE, object2.getQualifiedName());
        xMLOutputStream.add((Attribute)object);
        return string;
    }

    protected static String checkForRef(StartElement startElement) throws DeserializationException {
        Attribute attribute = startElement.getAttributeByName(SoapTypes.HREF_NAME);
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }

    protected static String checkForId(StartElement startElement) throws DeserializationException {
        Attribute attribute = startElement.getAttributeByName(SoapTypes.ID_NAME);
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }

    protected static Attribute createIdAttribute(String string) {
        return ElementFactory.createAttribute("id", string);
    }

    protected static Attribute createRefAttribute(String string) {
        return ElementFactory.createAttribute("href", "#" + string);
    }

    protected static boolean isSoapEncoding(SerializationContext serializationContext) {
        return EncodingStyle.SOAP == serializationContext.getEncodingStyle();
    }

    protected static boolean isStrictValidation(SerializationContext serializationContext) {
        return true;
    }

    protected static boolean isStrictValidation(DeserializationContext deserializationContext) {
        return true;
    }

    protected static void checkValidityConstraint(boolean bl, String string) throws DeserializationException {
        if (!bl) {
            throw new DeserializationException("validation error: " + string);
        }
    }

    protected boolean writeXsiType(SerializationContext serializationContext) {
        return serializationContext.isIncludeXsiType();
    }

    protected static void addPrefixToMap(String string, String string2, SerializationContext serializationContext) {
        serializationContext.getNamespacePrefixMap().put(string, string2);
    }

    protected static void removePrefixFromMap(String string, SerializationContext serializationContext) {
        if (string == null) {
            return;
        }
        serializationContext.getNamespacePrefixMap().remove(string);
    }

    protected static String fillPrefixAddToMap(ExpName expName, SerializationContext serializationContext) throws XMLStreamException {
        String string = expName.getNamespaceUri();
        if (string == null) {
            return null;
        }
        String string2 = serializationContext.getPrefixForUri(string);
        if (string2 == null) {
            string2 = serializationContext.getNextRandomPrefix();
            expName.setPrefix(string2);
            CodecBase.addPrefixToMap(string, string2, serializationContext);
            return string;
        }
        expName.setPrefix(string2);
        return null;
    }

    protected static void declareNamespace(XMLName xMLName, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws XMLStreamException {
        String string = xMLName.getNamespaceUri();
        if (string == null) {
            return;
        }
        String string2 = xMLName.getPrefix();
        Attribute attribute = ElementFactory.createNamespaceAttribute(string2, string);
        xMLOutputStream.add(attribute);
    }

    protected static String fillPrefixDeclareNamespace(ExpName expName, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws XMLStreamException {
        String string = CodecBase.fillPrefixAddToMap(expName, serializationContext);
        if (string == null) {
            return null;
        }
        CodecBase.declareNamespace(expName, xMLOutputStream, serializationContext);
        return string;
    }

    protected static StartElement getNextStartElement(XMLInputStream xMLInputStream) throws XMLStreamException {
        return CodecBase.getNextStartElement(xMLInputStream, true);
    }

    protected static StartElement getNextStartElement(XMLInputStream xMLInputStream, boolean bl) throws XMLStreamException {
        XMLEvent xMLEvent = xMLInputStream.peek();
        block5: while (xMLEvent != null) {
            switch (xMLEvent.getType()) {
                case 2: {
                    return (StartElement)xMLEvent;
                }
                case 4: {
                    if (!bl) break block5;
                    xMLInputStream.next();
                    break block5;
                }
                case 8: 
                case 16: 
                case 32: 
                case 64: 
                case 1024: 
                case 2048: 
                case 4096: {
                    xMLInputStream.next();
                    break;
                }
                default: {
                    break block5;
                }
            }
            xMLEvent = xMLInputStream.peek();
        }
        return null;
    }
}

