/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import weblogic.xml.schema.binding.BeanCodecBase;
import weblogic.xml.schema.binding.ClassLoadingUtils;
import weblogic.xml.schema.binding.DeserializationContext;
import weblogic.xml.schema.binding.DeserializationException;
import weblogic.xml.schema.binding.RuntimeUtils;
import weblogic.xml.schema.binding.util.runtime.PropertyInfo;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLStreamException;

public abstract class BeanExceptionCodecBase
extends BeanCodecBase {
    private static final Object NULL_MARKER = new Object();
    private Constructor exceptionCtor = null;

    protected abstract int[] getConstructorProperties();

    protected abstract String getJavaType();

    public Object deserialize(XMLName xMLName, XMLInputStream xMLInputStream, DeserializationContext deserializationContext) throws DeserializationException {
        try {
            if (!xMLInputStream.skip(2)) {
                throw new DeserializationException("invalid xml");
            }
            StartElement startElement = (StartElement)xMLInputStream.peek();
            XMLName xMLName2 = RuntimeUtils.getXsiType(startElement);
            if (xMLName2 != null && !xMLName2.equals(this.getXmlType())) {
                return RuntimeUtils.invoke_deserializer(xMLName, xMLName2, xMLInputStream, deserializationContext);
            }
            String string = BeanExceptionCodecBase.checkForRef(startElement);
            if (string != null) {
                return BeanExceptionCodecBase.deserializeReferredObject(string, this, xMLName, xMLInputStream, deserializationContext);
            }
            if (RuntimeUtils.checkForXsiNil(startElement)) {
                xMLInputStream.skipElement();
                return null;
            }
            Object[] objectArray = this.processExceptionElements(xMLInputStream, deserializationContext);
            Object object = this.invokeConstructor(objectArray);
            this.invokeSetters(object, objectArray);
            this.processAttributes(object, startElement, deserializationContext);
            String string2 = BeanExceptionCodecBase.checkForId(startElement);
            if (string2 != null) {
                deserializationContext.storeObjectWithReference(string2, object);
            }
            return object;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DeserializationException(xMLStreamException.getMessage(), xMLStreamException);
        }
    }

    private Object[] getConstuctorProps(Object[] objectArray) {
        int[] nArray = this.getConstructorProperties();
        Object[] objectArray2 = new Object[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            objectArray2[i] = objectArray[n];
        }
        return objectArray2;
    }

    private void invokeSetters(Object object, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            Object object2 = objectArray[i];
            if (object2 == null) continue;
            if (object2 == NULL_MARKER) {
                object2 = null;
            }
            this.invokeSetter(object, i, object2);
        }
    }

    private Object invokeConstructor(Object[] objectArray) throws DeserializationException {
        Constructor constructor = this.exceptionCtor;
        if (constructor == null) {
            this.exceptionCtor = constructor = this.getConstructor();
        }
        int[] nArray = this.getConstructorProperties();
        int n = nArray.length;
        Object[] objectArray2 = new Object[n];
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[nArray[i]];
            if (object == NULL_MARKER) {
                object = null;
            }
            objectArray2[i] = object;
        }
        try {
            return constructor.newInstance(objectArray2);
        }
        catch (SecurityException securityException) {
            throw new DeserializationException("constructor error: " + securityException, securityException);
        }
        catch (InstantiationException instantiationException) {
            throw new DeserializationException("constructor error: " + instantiationException, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DeserializationException("constructor error: " + illegalAccessException, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new DeserializationException("constructor error: " + invocationTargetException, invocationTargetException);
        }
    }

    private Constructor getConstructor() throws DeserializationException {
        Object object;
        int[] nArray = this.getConstructorProperties();
        int n = nArray.length;
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            object = this.getPropertyInfo(nArray[i]);
            classArray[i] = ((PropertyInfo)object).getJavaType();
        }
        String string = this.getJavaType();
        try {
            object = ClassLoadingUtils.loadClass(this.getJavaType(), this.getClass().getClassLoader());
            return ((Class)object).getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new DeserializationException("constructor error: " + noSuchMethodException, noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new DeserializationException("constructor error: " + securityException, securityException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DeserializationException("failed to load class: " + string, classNotFoundException);
        }
    }

    private Object[] processExceptionElements(XMLInputStream xMLInputStream, DeserializationContext deserializationContext) throws DeserializationException, XMLStreamException {
        XMLEvent xMLEvent = xMLInputStream.next();
        Object[] objectArray = new Object[this.getPropertyCount()];
        StartElement startElement = BeanExceptionCodecBase.getNextStartElement(xMLInputStream);
        while (startElement != null) {
            int n = this.findMatchingElementProperty(startElement.getName());
            if (n < 0) {
                xMLInputStream.skipElement();
            } else {
                Object object = this.processElement(n, xMLInputStream, deserializationContext);
                objectArray[n] = object == null ? NULL_MARKER : object;
            }
            startElement = BeanExceptionCodecBase.getNextStartElement(xMLInputStream);
        }
        return objectArray;
    }
}

